# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetTypesResult',
    'AwaitableGetTypesResult',
    'get_types',
    'get_types_output',
]

@pulumi.output_type
class GetTypesResult:
    """
    A collection of values returned by GetTypes.
    """
    def __init__(__self__, database_name=None, id=None, region=None, schema_name=None, types=None):
        if database_name and not isinstance(database_name, str):
            raise TypeError("Expected argument 'database_name' to be a str")
        pulumi.set(__self__, "database_name", database_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if schema_name and not isinstance(schema_name, str):
            raise TypeError("Expected argument 'schema_name' to be a str")
        pulumi.set(__self__, "schema_name", schema_name)
        if types and not isinstance(types, list):
            raise TypeError("Expected argument 'types' to be a list")
        pulumi.set(__self__, "types", types)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[str]:
        """
        Limit types to a specific database
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The region in which the resource is located.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[str]:
        """
        Limit types to a specific schema within a specific database
        """
        return pulumi.get(self, "schema_name")

    @property
    @pulumi.getter
    def types(self) -> Sequence['outputs.GetTypesTypeResult']:
        """
        The types in the account
        """
        return pulumi.get(self, "types")


class AwaitableGetTypesResult(GetTypesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTypesResult(
            database_name=self.database_name,
            id=self.id,
            region=self.region,
            schema_name=self.schema_name,
            types=self.types)


def get_types(database_name: Optional[str] = None,
              schema_name: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTypesResult:
    """
    Use this data source to access information about an existing resource.

    :param str database_name: Limit types to a specific database
    :param str schema_name: Limit types to a specific schema within a specific database
    """
    __args__ = dict()
    __args__['databaseName'] = database_name
    __args__['schemaName'] = schema_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('materialize:index/getTypes:GetTypes', __args__, opts=opts, typ=GetTypesResult).value

    return AwaitableGetTypesResult(
        database_name=pulumi.get(__ret__, 'database_name'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        schema_name=pulumi.get(__ret__, 'schema_name'),
        types=pulumi.get(__ret__, 'types'))


@_utilities.lift_output_func(get_types)
def get_types_output(database_name: Optional[pulumi.Input[Optional[str]]] = None,
                     schema_name: Optional[pulumi.Input[Optional[str]]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTypesResult]:
    """
    Use this data source to access information about an existing resource.

    :param str database_name: Limit types to a specific database
    :param str schema_name: Limit types to a specific schema within a specific database
    """
    ...
