# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetViewsResult',
    'AwaitableGetViewsResult',
    'get_views',
    'get_views_output',
]

@pulumi.output_type
class GetViewsResult:
    """
    A collection of values returned by GetViews.
    """
    def __init__(__self__, database_name=None, id=None, region=None, schema_name=None, views=None):
        if database_name and not isinstance(database_name, str):
            raise TypeError("Expected argument 'database_name' to be a str")
        pulumi.set(__self__, "database_name", database_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if schema_name and not isinstance(schema_name, str):
            raise TypeError("Expected argument 'schema_name' to be a str")
        pulumi.set(__self__, "schema_name", schema_name)
        if views and not isinstance(views, list):
            raise TypeError("Expected argument 'views' to be a list")
        pulumi.set(__self__, "views", views)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[str]:
        """
        Limit views to a specific database
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The region in which the resource is located.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[str]:
        """
        Limit views to a specific schema within a specific database
        """
        return pulumi.get(self, "schema_name")

    @property
    @pulumi.getter
    def views(self) -> Sequence['outputs.GetViewsViewResult']:
        """
        The views in the account
        """
        return pulumi.get(self, "views")


class AwaitableGetViewsResult(GetViewsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetViewsResult(
            database_name=self.database_name,
            id=self.id,
            region=self.region,
            schema_name=self.schema_name,
            views=self.views)


def get_views(database_name: Optional[str] = None,
              schema_name: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetViewsResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_materialize as materialize

    all = materialize.get_views()
    materialize = materialize.get_views(database_name="materialize")
    materialize_schema = materialize.get_views(database_name="materialize",
        schema_name="schema")
    ```


    :param str database_name: Limit views to a specific database
    :param str schema_name: Limit views to a specific schema within a specific database
    """
    __args__ = dict()
    __args__['databaseName'] = database_name
    __args__['schemaName'] = schema_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('materialize:index/getViews:GetViews', __args__, opts=opts, typ=GetViewsResult).value

    return AwaitableGetViewsResult(
        database_name=pulumi.get(__ret__, 'database_name'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        schema_name=pulumi.get(__ret__, 'schema_name'),
        views=pulumi.get(__ret__, 'views'))


@_utilities.lift_output_func(get_views)
def get_views_output(database_name: Optional[pulumi.Input[Optional[str]]] = None,
                     schema_name: Optional[pulumi.Input[Optional[str]]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetViewsResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_materialize as materialize

    all = materialize.get_views()
    materialize = materialize.get_views(database_name="materialize")
    materialize_schema = materialize.get_views(database_name="materialize",
        schema_name="schema")
    ```


    :param str database_name: Limit views to a specific database
    :param str schema_name: Limit views to a specific schema within a specific database
    """
    ...
