# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['GrantDatabaseArgs', 'GrantDatabase']

@pulumi.input_type
class GrantDatabaseArgs:
    def __init__(__self__, *,
                 database_name: pulumi.Input[str],
                 privilege: pulumi.Input[str],
                 role_name: pulumi.Input[str],
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a GrantDatabase resource.
        :param pulumi.Input[str] database_name: The database that is being granted on.
        :param pulumi.Input[str] privilege: The privilege to grant to the object.
        :param pulumi.Input[str] role_name: The name of the role to grant privilege to.
        :param pulumi.Input[str] region: The region to use for the resource connection. If not set, the default region is used.
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "privilege", privilege)
        pulumi.set(__self__, "role_name", role_name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[str]:
        """
        The database that is being granted on.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter
    def privilege(self) -> pulumi.Input[str]:
        """
        The privilege to grant to the object.
        """
        return pulumi.get(self, "privilege")

    @privilege.setter
    def privilege(self, value: pulumi.Input[str]):
        pulumi.set(self, "privilege", value)

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Input[str]:
        """
        The name of the role to grant privilege to.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _GrantDatabaseState:
    def __init__(__self__, *,
                 database_name: Optional[pulumi.Input[str]] = None,
                 privilege: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 role_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering GrantDatabase resources.
        :param pulumi.Input[str] database_name: The database that is being granted on.
        :param pulumi.Input[str] privilege: The privilege to grant to the object.
        :param pulumi.Input[str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[str] role_name: The name of the role to grant privilege to.
        """
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if privilege is not None:
            pulumi.set(__self__, "privilege", privilege)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        The database that is being granted on.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter
    def privilege(self) -> Optional[pulumi.Input[str]]:
        """
        The privilege to grant to the object.
        """
        return pulumi.get(self, "privilege")

    @privilege.setter
    def privilege(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "privilege", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the role to grant privilege to.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_name", value)


class GrantDatabase(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 privilege: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages the privileges on a Materailize database for roles.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        # Grant USAGE to role example_role to database example_database
        database_grant_usage = materialize.GrantDatabase("databaseGrantUsage",
            database_name="example_database",
            privilege="USAGE",
            role_name="example_role")
        ```

        ## Import

        #Grants can be imported using the concatenation of GRANT, the object type, the id of the object, the id of the role and the privilege

        ```sh
         $ pulumi import materialize:index/grantDatabase:GrantDatabase example <region>:GRANT|DATABASE|<database_id>|<role_id>|<privilege>
        ```

         The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] database_name: The database that is being granted on.
        :param pulumi.Input[str] privilege: The privilege to grant to the object.
        :param pulumi.Input[str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[str] role_name: The name of the role to grant privilege to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GrantDatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the privileges on a Materailize database for roles.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        # Grant USAGE to role example_role to database example_database
        database_grant_usage = materialize.GrantDatabase("databaseGrantUsage",
            database_name="example_database",
            privilege="USAGE",
            role_name="example_role")
        ```

        ## Import

        #Grants can be imported using the concatenation of GRANT, the object type, the id of the object, the id of the role and the privilege

        ```sh
         $ pulumi import materialize:index/grantDatabase:GrantDatabase example <region>:GRANT|DATABASE|<database_id>|<role_id>|<privilege>
        ```

         The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param GrantDatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GrantDatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 privilege: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GrantDatabaseArgs.__new__(GrantDatabaseArgs)

            if database_name is None and not opts.urn:
                raise TypeError("Missing required property 'database_name'")
            __props__.__dict__["database_name"] = database_name
            if privilege is None and not opts.urn:
                raise TypeError("Missing required property 'privilege'")
            __props__.__dict__["privilege"] = privilege
            __props__.__dict__["region"] = region
            if role_name is None and not opts.urn:
                raise TypeError("Missing required property 'role_name'")
            __props__.__dict__["role_name"] = role_name
        super(GrantDatabase, __self__).__init__(
            'materialize:index/grantDatabase:GrantDatabase',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            database_name: Optional[pulumi.Input[str]] = None,
            privilege: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            role_name: Optional[pulumi.Input[str]] = None) -> 'GrantDatabase':
        """
        Get an existing GrantDatabase resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] database_name: The database that is being granted on.
        :param pulumi.Input[str] privilege: The privilege to grant to the object.
        :param pulumi.Input[str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[str] role_name: The name of the role to grant privilege to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GrantDatabaseState.__new__(_GrantDatabaseState)

        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["privilege"] = privilege
        __props__.__dict__["region"] = region
        __props__.__dict__["role_name"] = role_name
        return GrantDatabase(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[str]:
        """
        The database that is being granted on.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def privilege(self) -> pulumi.Output[str]:
        """
        The privilege to grant to the object.
        """
        return pulumi.get(self, "privilege")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Output[str]:
        """
        The name of the role to grant privilege to.
        """
        return pulumi.get(self, "role_name")

