# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['GrantTableDefaultPrivilegeArgs', 'GrantTableDefaultPrivilege']

@pulumi.input_type
class GrantTableDefaultPrivilegeArgs:
    def __init__(__self__, *,
                 grantee_name: pulumi.Input[str],
                 privilege: pulumi.Input[str],
                 target_role_name: pulumi.Input[str],
                 database_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 schema_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a GrantTableDefaultPrivilege resource.
        :param pulumi.Input[str] grantee_name: The role name that will gain the default privilege. Use the `PUBLIC` pseudo-role to grant privileges to all roles.
        :param pulumi.Input[str] privilege: The privilege to grant to the object.
        :param pulumi.Input[str] target_role_name: The default privilege will apply to objects created by this role. If this is left blank, then the current role is assumed. Use the `PUBLIC` pseudo-role to target objects created by all roles.
        :param pulumi.Input[str] database_name: The default privilege will apply only to objects created in this database, if specified.
        :param pulumi.Input[str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[str] schema_name: The default privilege will apply only to objects created in this schema, if specified.
        """
        pulumi.set(__self__, "grantee_name", grantee_name)
        pulumi.set(__self__, "privilege", privilege)
        pulumi.set(__self__, "target_role_name", target_role_name)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)

    @property
    @pulumi.getter(name="granteeName")
    def grantee_name(self) -> pulumi.Input[str]:
        """
        The role name that will gain the default privilege. Use the `PUBLIC` pseudo-role to grant privileges to all roles.
        """
        return pulumi.get(self, "grantee_name")

    @grantee_name.setter
    def grantee_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "grantee_name", value)

    @property
    @pulumi.getter
    def privilege(self) -> pulumi.Input[str]:
        """
        The privilege to grant to the object.
        """
        return pulumi.get(self, "privilege")

    @privilege.setter
    def privilege(self, value: pulumi.Input[str]):
        pulumi.set(self, "privilege", value)

    @property
    @pulumi.getter(name="targetRoleName")
    def target_role_name(self) -> pulumi.Input[str]:
        """
        The default privilege will apply to objects created by this role. If this is left blank, then the current role is assumed. Use the `PUBLIC` pseudo-role to target objects created by all roles.
        """
        return pulumi.get(self, "target_role_name")

    @target_role_name.setter
    def target_role_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_role_name", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        The default privilege will apply only to objects created in this database, if specified.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[str]]:
        """
        The default privilege will apply only to objects created in this schema, if specified.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema_name", value)


@pulumi.input_type
class _GrantTableDefaultPrivilegeState:
    def __init__(__self__, *,
                 database_name: Optional[pulumi.Input[str]] = None,
                 grantee_name: Optional[pulumi.Input[str]] = None,
                 privilege: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 schema_name: Optional[pulumi.Input[str]] = None,
                 target_role_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering GrantTableDefaultPrivilege resources.
        :param pulumi.Input[str] database_name: The default privilege will apply only to objects created in this database, if specified.
        :param pulumi.Input[str] grantee_name: The role name that will gain the default privilege. Use the `PUBLIC` pseudo-role to grant privileges to all roles.
        :param pulumi.Input[str] privilege: The privilege to grant to the object.
        :param pulumi.Input[str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[str] schema_name: The default privilege will apply only to objects created in this schema, if specified.
        :param pulumi.Input[str] target_role_name: The default privilege will apply to objects created by this role. If this is left blank, then the current role is assumed. Use the `PUBLIC` pseudo-role to target objects created by all roles.
        """
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if grantee_name is not None:
            pulumi.set(__self__, "grantee_name", grantee_name)
        if privilege is not None:
            pulumi.set(__self__, "privilege", privilege)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if target_role_name is not None:
            pulumi.set(__self__, "target_role_name", target_role_name)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        The default privilege will apply only to objects created in this database, if specified.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="granteeName")
    def grantee_name(self) -> Optional[pulumi.Input[str]]:
        """
        The role name that will gain the default privilege. Use the `PUBLIC` pseudo-role to grant privileges to all roles.
        """
        return pulumi.get(self, "grantee_name")

    @grantee_name.setter
    def grantee_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "grantee_name", value)

    @property
    @pulumi.getter
    def privilege(self) -> Optional[pulumi.Input[str]]:
        """
        The privilege to grant to the object.
        """
        return pulumi.get(self, "privilege")

    @privilege.setter
    def privilege(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "privilege", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[str]]:
        """
        The default privilege will apply only to objects created in this schema, if specified.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema_name", value)

    @property
    @pulumi.getter(name="targetRoleName")
    def target_role_name(self) -> Optional[pulumi.Input[str]]:
        """
        The default privilege will apply to objects created by this role. If this is left blank, then the current role is assumed. Use the `PUBLIC` pseudo-role to target objects created by all roles.
        """
        return pulumi.get(self, "target_role_name")

    @target_role_name.setter
    def target_role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_role_name", value)


class GrantTableDefaultPrivilege(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 grantee_name: Optional[pulumi.Input[str]] = None,
                 privilege: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 schema_name: Optional[pulumi.Input[str]] = None,
                 target_role_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Defines default privileges that will be applied to objects created in the future. It does not affect any existing objects.

        *Note*: This resource applies to sources, views and materialized views (https://materialize.com/docs/sql/alter-default-privileges/#compatibility)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        # Grant role the privilege USAGE for objects in the schema database.schema
        example = materialize.GrantTableDefaultPrivilege("example",
            database_name="database",
            grantee_name="grantee",
            privilege="USAGE",
            schema_name="schema",
            target_role_name="target_role")
        ```

        ## Import

        #Grants can be imported using the concatenation of GRANT DEFAULT, the grantee id of the role #Optionally you can include the target id, database id and schema id. The privilege is required

        ```sh
         $ pulumi import materialize:index/grantTableDefaultPrivilege:GrantTableDefaultPrivilege example <region>:GRANT DEFAULT|TABLE|<grantee_id>|<target_role_id>|<database_id>|<schema_id>|<privilege>
        ```

         The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] database_name: The default privilege will apply only to objects created in this database, if specified.
        :param pulumi.Input[str] grantee_name: The role name that will gain the default privilege. Use the `PUBLIC` pseudo-role to grant privileges to all roles.
        :param pulumi.Input[str] privilege: The privilege to grant to the object.
        :param pulumi.Input[str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[str] schema_name: The default privilege will apply only to objects created in this schema, if specified.
        :param pulumi.Input[str] target_role_name: The default privilege will apply to objects created by this role. If this is left blank, then the current role is assumed. Use the `PUBLIC` pseudo-role to target objects created by all roles.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GrantTableDefaultPrivilegeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Defines default privileges that will be applied to objects created in the future. It does not affect any existing objects.

        *Note*: This resource applies to sources, views and materialized views (https://materialize.com/docs/sql/alter-default-privileges/#compatibility)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        # Grant role the privilege USAGE for objects in the schema database.schema
        example = materialize.GrantTableDefaultPrivilege("example",
            database_name="database",
            grantee_name="grantee",
            privilege="USAGE",
            schema_name="schema",
            target_role_name="target_role")
        ```

        ## Import

        #Grants can be imported using the concatenation of GRANT DEFAULT, the grantee id of the role #Optionally you can include the target id, database id and schema id. The privilege is required

        ```sh
         $ pulumi import materialize:index/grantTableDefaultPrivilege:GrantTableDefaultPrivilege example <region>:GRANT DEFAULT|TABLE|<grantee_id>|<target_role_id>|<database_id>|<schema_id>|<privilege>
        ```

         The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param GrantTableDefaultPrivilegeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GrantTableDefaultPrivilegeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 grantee_name: Optional[pulumi.Input[str]] = None,
                 privilege: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 schema_name: Optional[pulumi.Input[str]] = None,
                 target_role_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GrantTableDefaultPrivilegeArgs.__new__(GrantTableDefaultPrivilegeArgs)

            __props__.__dict__["database_name"] = database_name
            if grantee_name is None and not opts.urn:
                raise TypeError("Missing required property 'grantee_name'")
            __props__.__dict__["grantee_name"] = grantee_name
            if privilege is None and not opts.urn:
                raise TypeError("Missing required property 'privilege'")
            __props__.__dict__["privilege"] = privilege
            __props__.__dict__["region"] = region
            __props__.__dict__["schema_name"] = schema_name
            if target_role_name is None and not opts.urn:
                raise TypeError("Missing required property 'target_role_name'")
            __props__.__dict__["target_role_name"] = target_role_name
        super(GrantTableDefaultPrivilege, __self__).__init__(
            'materialize:index/grantTableDefaultPrivilege:GrantTableDefaultPrivilege',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            database_name: Optional[pulumi.Input[str]] = None,
            grantee_name: Optional[pulumi.Input[str]] = None,
            privilege: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            schema_name: Optional[pulumi.Input[str]] = None,
            target_role_name: Optional[pulumi.Input[str]] = None) -> 'GrantTableDefaultPrivilege':
        """
        Get an existing GrantTableDefaultPrivilege resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] database_name: The default privilege will apply only to objects created in this database, if specified.
        :param pulumi.Input[str] grantee_name: The role name that will gain the default privilege. Use the `PUBLIC` pseudo-role to grant privileges to all roles.
        :param pulumi.Input[str] privilege: The privilege to grant to the object.
        :param pulumi.Input[str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[str] schema_name: The default privilege will apply only to objects created in this schema, if specified.
        :param pulumi.Input[str] target_role_name: The default privilege will apply to objects created by this role. If this is left blank, then the current role is assumed. Use the `PUBLIC` pseudo-role to target objects created by all roles.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GrantTableDefaultPrivilegeState.__new__(_GrantTableDefaultPrivilegeState)

        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["grantee_name"] = grantee_name
        __props__.__dict__["privilege"] = privilege
        __props__.__dict__["region"] = region
        __props__.__dict__["schema_name"] = schema_name
        __props__.__dict__["target_role_name"] = target_role_name
        return GrantTableDefaultPrivilege(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[Optional[str]]:
        """
        The default privilege will apply only to objects created in this database, if specified.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="granteeName")
    def grantee_name(self) -> pulumi.Output[str]:
        """
        The role name that will gain the default privilege. Use the `PUBLIC` pseudo-role to grant privileges to all roles.
        """
        return pulumi.get(self, "grantee_name")

    @property
    @pulumi.getter
    def privilege(self) -> pulumi.Output[str]:
        """
        The privilege to grant to the object.
        """
        return pulumi.get(self, "privilege")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> pulumi.Output[Optional[str]]:
        """
        The default privilege will apply only to objects created in this schema, if specified.
        """
        return pulumi.get(self, "schema_name")

    @property
    @pulumi.getter(name="targetRoleName")
    def target_role_name(self) -> pulumi.Output[str]:
        """
        The default privilege will apply to objects created by this role. If this is left blank, then the current role is assumed. Use the `PUBLIC` pseudo-role to target objects created by all roles.
        """
        return pulumi.get(self, "target_role_name")

