# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 base_endpoint: Optional[pulumi.Input[str]] = None,
                 cloud_endpoint: Optional[pulumi.Input[str]] = None,
                 database: Optional[pulumi.Input[str]] = None,
                 default_region: Optional[pulumi.Input[str]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 sslmode: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[str] base_endpoint: The base endpoint for Materialize.
        :param pulumi.Input[str] cloud_endpoint: The endpoint for the Materialize Cloud API.
        :param pulumi.Input[str] database: The Materialize database. Can also come from the `MZ_DATABASE` environment variable. Defaults to `materialize`.
        :param pulumi.Input[str] default_region: The default region if not specified in the resource
        :param pulumi.Input[str] endpoint: The endpoint for the Materialize API.
        :param pulumi.Input[str] password: Materialize host. Can also come from the `MZ_PASSWORD` environment variable.
        :param pulumi.Input[str] sslmode: For testing purposes, the SSL mode to use.
        """
        if base_endpoint is None:
            base_endpoint = _utilities.get_env('MZ_BASE_ENDPOINT')
        if base_endpoint is not None:
            pulumi.set(__self__, "base_endpoint", base_endpoint)
        if cloud_endpoint is None:
            cloud_endpoint = _utilities.get_env('MZ_CLOUD_ENDPOINT')
        if cloud_endpoint is not None:
            pulumi.set(__self__, "cloud_endpoint", cloud_endpoint)
        if database is None:
            database = _utilities.get_env('MZ_DATABASE')
        if database is not None:
            pulumi.set(__self__, "database", database)
        if default_region is None:
            default_region = _utilities.get_env('MZ_DEFAULT_REGION')
        if default_region is not None:
            pulumi.set(__self__, "default_region", default_region)
        if endpoint is None:
            endpoint = _utilities.get_env('MZ_ENDPOINT')
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if password is None:
            password = _utilities.get_env('MZ_PASSWORD')
        if password is not None:
            pulumi.set(__self__, "password", password)
        if sslmode is None:
            sslmode = _utilities.get_env('MZ_SSLMODE')
        if sslmode is not None:
            pulumi.set(__self__, "sslmode", sslmode)

    @property
    @pulumi.getter(name="baseEndpoint")
    def base_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The base endpoint for Materialize.
        """
        return pulumi.get(self, "base_endpoint")

    @base_endpoint.setter
    def base_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_endpoint", value)

    @property
    @pulumi.getter(name="cloudEndpoint")
    def cloud_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint for the Materialize Cloud API.
        """
        return pulumi.get(self, "cloud_endpoint")

    @cloud_endpoint.setter
    def cloud_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_endpoint", value)

    @property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[str]]:
        """
        The Materialize database. Can also come from the `MZ_DATABASE` environment variable. Defaults to `materialize`.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter(name="defaultRegion")
    def default_region(self) -> Optional[pulumi.Input[str]]:
        """
        The default region if not specified in the resource
        """
        return pulumi.get(self, "default_region")

    @default_region.setter
    def default_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_region", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint for the Materialize API.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Materialize host. Can also come from the `MZ_PASSWORD` environment variable.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def sslmode(self) -> Optional[pulumi.Input[str]]:
        """
        For testing purposes, the SSL mode to use.
        """
        return pulumi.get(self, "sslmode")

    @sslmode.setter
    def sslmode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sslmode", value)


class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_endpoint: Optional[pulumi.Input[str]] = None,
                 cloud_endpoint: Optional[pulumi.Input[str]] = None,
                 database: Optional[pulumi.Input[str]] = None,
                 default_region: Optional[pulumi.Input[str]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 sslmode: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The provider type for the materialize package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] base_endpoint: The base endpoint for Materialize.
        :param pulumi.Input[str] cloud_endpoint: The endpoint for the Materialize Cloud API.
        :param pulumi.Input[str] database: The Materialize database. Can also come from the `MZ_DATABASE` environment variable. Defaults to `materialize`.
        :param pulumi.Input[str] default_region: The default region if not specified in the resource
        :param pulumi.Input[str] endpoint: The endpoint for the Materialize API.
        :param pulumi.Input[str] password: Materialize host. Can also come from the `MZ_PASSWORD` environment variable.
        :param pulumi.Input[str] sslmode: For testing purposes, the SSL mode to use.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the materialize package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_endpoint: Optional[pulumi.Input[str]] = None,
                 cloud_endpoint: Optional[pulumi.Input[str]] = None,
                 database: Optional[pulumi.Input[str]] = None,
                 default_region: Optional[pulumi.Input[str]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 sslmode: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            if base_endpoint is None:
                base_endpoint = _utilities.get_env('MZ_BASE_ENDPOINT')
            __props__.__dict__["base_endpoint"] = base_endpoint
            if cloud_endpoint is None:
                cloud_endpoint = _utilities.get_env('MZ_CLOUD_ENDPOINT')
            __props__.__dict__["cloud_endpoint"] = cloud_endpoint
            if database is None:
                database = _utilities.get_env('MZ_DATABASE')
            __props__.__dict__["database"] = database
            if default_region is None:
                default_region = _utilities.get_env('MZ_DEFAULT_REGION')
            __props__.__dict__["default_region"] = default_region
            if endpoint is None:
                endpoint = _utilities.get_env('MZ_ENDPOINT')
            __props__.__dict__["endpoint"] = endpoint
            if password is None:
                password = _utilities.get_env('MZ_PASSWORD')
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            if sslmode is None:
                sslmode = _utilities.get_env('MZ_SSLMODE')
            __props__.__dict__["sslmode"] = sslmode
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Provider, __self__).__init__(
            'materialize',
            resource_name,
            __props__,
            opts)

    @property
    @pulumi.getter(name="baseEndpoint")
    def base_endpoint(self) -> pulumi.Output[Optional[str]]:
        """
        The base endpoint for Materialize.
        """
        return pulumi.get(self, "base_endpoint")

    @property
    @pulumi.getter(name="cloudEndpoint")
    def cloud_endpoint(self) -> pulumi.Output[Optional[str]]:
        """
        The endpoint for the Materialize Cloud API.
        """
        return pulumi.get(self, "cloud_endpoint")

    @property
    @pulumi.getter
    def database(self) -> pulumi.Output[Optional[str]]:
        """
        The Materialize database. Can also come from the `MZ_DATABASE` environment variable. Defaults to `materialize`.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter(name="defaultRegion")
    def default_region(self) -> pulumi.Output[Optional[str]]:
        """
        The default region if not specified in the resource
        """
        return pulumi.get(self, "default_region")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[Optional[str]]:
        """
        The endpoint for the Materialize API.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        Materialize host. Can also come from the `MZ_PASSWORD` environment variable.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def sslmode(self) -> pulumi.Output[Optional[str]]:
        """
        For testing purposes, the SSL mode to use.
        """
        return pulumi.get(self, "sslmode")

