# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SinkKafkaArgs', 'SinkKafka']

@pulumi.input_type
class SinkKafkaArgs:
    def __init__(__self__, *,
                 from_: pulumi.Input['SinkKafkaFromArgs'],
                 kafka_connection: pulumi.Input['SinkKafkaKafkaConnectionArgs'],
                 topic: pulumi.Input[str],
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 compression_type: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 envelope: Optional[pulumi.Input['SinkKafkaEnvelopeArgs']] = None,
                 format: Optional[pulumi.Input['SinkKafkaFormatArgs']] = None,
                 key_not_enforced: Optional[pulumi.Input[bool]] = None,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ownership_role: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 schema_name: Optional[pulumi.Input[str]] = None,
                 snapshot: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a SinkKafka resource.
        :param pulumi.Input['SinkKafkaFromArgs'] from_: The name of the source, table or materialized view you want to send to the sink.
        :param pulumi.Input['SinkKafkaKafkaConnectionArgs'] kafka_connection: The name of the Kafka connection to use in the sink.
        :param pulumi.Input[str] topic: The Kafka topic you want to subscribe to.
        :param pulumi.Input[str] cluster_name: The cluster to maintain this sink.
        :param pulumi.Input[str] comment: **Public Preview** Comment on an object in the database.
        :param pulumi.Input[str] compression_type: The type of compression to apply to messages before they are sent to Kafka.
        :param pulumi.Input[str] database_name: The identifier for the sink database. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input['SinkKafkaEnvelopeArgs'] envelope: How to interpret records (e.g. Debezium, Upsert).
        :param pulumi.Input['SinkKafkaFormatArgs'] format: How to decode raw bytes from different formats into data structures it can understand at runtime.
        :param pulumi.Input[bool] key_not_enforced: Disable Materialize's validation of the key's uniqueness.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] keys: An optional list of columns to use for the Kafka key. If unspecified, the Kafka key is left unset.
        :param pulumi.Input[str] name: The identifier for the sink.
        :param pulumi.Input[str] ownership_role: The owernship role of the object.
        :param pulumi.Input[str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[str] schema_name: The identifier for the sink schema. Defaults to `public`.
        :param pulumi.Input[bool] snapshot: Whether to emit the consolidated results of the query before the sink was created at the start of the sink.
        """
        pulumi.set(__self__, "from_", from_)
        pulumi.set(__self__, "kafka_connection", kafka_connection)
        pulumi.set(__self__, "topic", topic)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if compression_type is not None:
            pulumi.set(__self__, "compression_type", compression_type)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if envelope is not None:
            pulumi.set(__self__, "envelope", envelope)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if key_not_enforced is not None:
            pulumi.set(__self__, "key_not_enforced", key_not_enforced)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ownership_role is not None:
            pulumi.set(__self__, "ownership_role", ownership_role)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if snapshot is not None:
            pulumi.set(__self__, "snapshot", snapshot)

    @property
    @pulumi.getter(name="from")
    def from_(self) -> pulumi.Input['SinkKafkaFromArgs']:
        """
        The name of the source, table or materialized view you want to send to the sink.
        """
        return pulumi.get(self, "from_")

    @from_.setter
    def from_(self, value: pulumi.Input['SinkKafkaFromArgs']):
        pulumi.set(self, "from_", value)

    @property
    @pulumi.getter(name="kafkaConnection")
    def kafka_connection(self) -> pulumi.Input['SinkKafkaKafkaConnectionArgs']:
        """
        The name of the Kafka connection to use in the sink.
        """
        return pulumi.get(self, "kafka_connection")

    @kafka_connection.setter
    def kafka_connection(self, value: pulumi.Input['SinkKafkaKafkaConnectionArgs']):
        pulumi.set(self, "kafka_connection", value)

    @property
    @pulumi.getter
    def topic(self) -> pulumi.Input[str]:
        """
        The Kafka topic you want to subscribe to.
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: pulumi.Input[str]):
        pulumi.set(self, "topic", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster to maintain this sink.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        **Public Preview** Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="compressionType")
    def compression_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of compression to apply to messages before they are sent to Kafka.
        """
        return pulumi.get(self, "compression_type")

    @compression_type.setter
    def compression_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression_type", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the sink database. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter
    def envelope(self) -> Optional[pulumi.Input['SinkKafkaEnvelopeArgs']]:
        """
        How to interpret records (e.g. Debezium, Upsert).
        """
        return pulumi.get(self, "envelope")

    @envelope.setter
    def envelope(self, value: Optional[pulumi.Input['SinkKafkaEnvelopeArgs']]):
        pulumi.set(self, "envelope", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input['SinkKafkaFormatArgs']]:
        """
        How to decode raw bytes from different formats into data structures it can understand at runtime.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input['SinkKafkaFormatArgs']]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="keyNotEnforced")
    def key_not_enforced(self) -> Optional[pulumi.Input[bool]]:
        """
        Disable Materialize's validation of the key's uniqueness.
        """
        return pulumi.get(self, "key_not_enforced")

    @key_not_enforced.setter
    def key_not_enforced(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "key_not_enforced", value)

    @property
    @pulumi.getter
    def keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An optional list of columns to use for the Kafka key. If unspecified, the Kafka key is left unset.
        """
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "keys", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the sink.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> Optional[pulumi.Input[str]]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @ownership_role.setter
    def ownership_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ownership_role", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the sink schema. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema_name", value)

    @property
    @pulumi.getter
    def snapshot(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to emit the consolidated results of the query before the sink was created at the start of the sink.
        """
        return pulumi.get(self, "snapshot")

    @snapshot.setter
    def snapshot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "snapshot", value)


@pulumi.input_type
class _SinkKafkaState:
    def __init__(__self__, *,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 compression_type: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 envelope: Optional[pulumi.Input['SinkKafkaEnvelopeArgs']] = None,
                 format: Optional[pulumi.Input['SinkKafkaFormatArgs']] = None,
                 from_: Optional[pulumi.Input['SinkKafkaFromArgs']] = None,
                 kafka_connection: Optional[pulumi.Input['SinkKafkaKafkaConnectionArgs']] = None,
                 key_not_enforced: Optional[pulumi.Input[bool]] = None,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ownership_role: Optional[pulumi.Input[str]] = None,
                 qualified_sql_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 schema_name: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 snapshot: Optional[pulumi.Input[bool]] = None,
                 topic: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SinkKafka resources.
        :param pulumi.Input[str] cluster_name: The cluster to maintain this sink.
        :param pulumi.Input[str] comment: **Public Preview** Comment on an object in the database.
        :param pulumi.Input[str] compression_type: The type of compression to apply to messages before they are sent to Kafka.
        :param pulumi.Input[str] database_name: The identifier for the sink database. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input['SinkKafkaEnvelopeArgs'] envelope: How to interpret records (e.g. Debezium, Upsert).
        :param pulumi.Input['SinkKafkaFormatArgs'] format: How to decode raw bytes from different formats into data structures it can understand at runtime.
        :param pulumi.Input['SinkKafkaFromArgs'] from_: The name of the source, table or materialized view you want to send to the sink.
        :param pulumi.Input['SinkKafkaKafkaConnectionArgs'] kafka_connection: The name of the Kafka connection to use in the sink.
        :param pulumi.Input[bool] key_not_enforced: Disable Materialize's validation of the key's uniqueness.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] keys: An optional list of columns to use for the Kafka key. If unspecified, the Kafka key is left unset.
        :param pulumi.Input[str] name: The identifier for the sink.
        :param pulumi.Input[str] ownership_role: The owernship role of the object.
        :param pulumi.Input[str] qualified_sql_name: The fully qualified name of the sink.
        :param pulumi.Input[str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[str] schema_name: The identifier for the sink schema. Defaults to `public`.
        :param pulumi.Input[str] size: The size of the cluster maintaining this sink.
        :param pulumi.Input[bool] snapshot: Whether to emit the consolidated results of the query before the sink was created at the start of the sink.
        :param pulumi.Input[str] topic: The Kafka topic you want to subscribe to.
        """
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if compression_type is not None:
            pulumi.set(__self__, "compression_type", compression_type)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if envelope is not None:
            pulumi.set(__self__, "envelope", envelope)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if from_ is not None:
            pulumi.set(__self__, "from_", from_)
        if kafka_connection is not None:
            pulumi.set(__self__, "kafka_connection", kafka_connection)
        if key_not_enforced is not None:
            pulumi.set(__self__, "key_not_enforced", key_not_enforced)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ownership_role is not None:
            pulumi.set(__self__, "ownership_role", ownership_role)
        if qualified_sql_name is not None:
            pulumi.set(__self__, "qualified_sql_name", qualified_sql_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if snapshot is not None:
            pulumi.set(__self__, "snapshot", snapshot)
        if topic is not None:
            pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster to maintain this sink.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        **Public Preview** Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="compressionType")
    def compression_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of compression to apply to messages before they are sent to Kafka.
        """
        return pulumi.get(self, "compression_type")

    @compression_type.setter
    def compression_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression_type", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the sink database. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter
    def envelope(self) -> Optional[pulumi.Input['SinkKafkaEnvelopeArgs']]:
        """
        How to interpret records (e.g. Debezium, Upsert).
        """
        return pulumi.get(self, "envelope")

    @envelope.setter
    def envelope(self, value: Optional[pulumi.Input['SinkKafkaEnvelopeArgs']]):
        pulumi.set(self, "envelope", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input['SinkKafkaFormatArgs']]:
        """
        How to decode raw bytes from different formats into data structures it can understand at runtime.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input['SinkKafkaFormatArgs']]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="from")
    def from_(self) -> Optional[pulumi.Input['SinkKafkaFromArgs']]:
        """
        The name of the source, table or materialized view you want to send to the sink.
        """
        return pulumi.get(self, "from_")

    @from_.setter
    def from_(self, value: Optional[pulumi.Input['SinkKafkaFromArgs']]):
        pulumi.set(self, "from_", value)

    @property
    @pulumi.getter(name="kafkaConnection")
    def kafka_connection(self) -> Optional[pulumi.Input['SinkKafkaKafkaConnectionArgs']]:
        """
        The name of the Kafka connection to use in the sink.
        """
        return pulumi.get(self, "kafka_connection")

    @kafka_connection.setter
    def kafka_connection(self, value: Optional[pulumi.Input['SinkKafkaKafkaConnectionArgs']]):
        pulumi.set(self, "kafka_connection", value)

    @property
    @pulumi.getter(name="keyNotEnforced")
    def key_not_enforced(self) -> Optional[pulumi.Input[bool]]:
        """
        Disable Materialize's validation of the key's uniqueness.
        """
        return pulumi.get(self, "key_not_enforced")

    @key_not_enforced.setter
    def key_not_enforced(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "key_not_enforced", value)

    @property
    @pulumi.getter
    def keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An optional list of columns to use for the Kafka key. If unspecified, the Kafka key is left unset.
        """
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "keys", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the sink.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> Optional[pulumi.Input[str]]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @ownership_role.setter
    def ownership_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ownership_role", value)

    @property
    @pulumi.getter(name="qualifiedSqlName")
    def qualified_sql_name(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified name of the sink.
        """
        return pulumi.get(self, "qualified_sql_name")

    @qualified_sql_name.setter
    def qualified_sql_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "qualified_sql_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the sink schema. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema_name", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        The size of the cluster maintaining this sink.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def snapshot(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to emit the consolidated results of the query before the sink was created at the start of the sink.
        """
        return pulumi.get(self, "snapshot")

    @snapshot.setter
    def snapshot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "snapshot", value)

    @property
    @pulumi.getter
    def topic(self) -> Optional[pulumi.Input[str]]:
        """
        The Kafka topic you want to subscribe to.
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "topic", value)


class SinkKafka(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 compression_type: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 envelope: Optional[pulumi.Input[pulumi.InputType['SinkKafkaEnvelopeArgs']]] = None,
                 format: Optional[pulumi.Input[pulumi.InputType['SinkKafkaFormatArgs']]] = None,
                 from_: Optional[pulumi.Input[pulumi.InputType['SinkKafkaFromArgs']]] = None,
                 kafka_connection: Optional[pulumi.Input[pulumi.InputType['SinkKafkaKafkaConnectionArgs']]] = None,
                 key_not_enforced: Optional[pulumi.Input[bool]] = None,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ownership_role: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 schema_name: Optional[pulumi.Input[str]] = None,
                 snapshot: Optional[pulumi.Input[bool]] = None,
                 topic: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A Kafka sink establishes a link to a Kafka cluster that you want Materialize to write data to.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        example_sink_kafka = materialize.SinkKafka("exampleSinkKafka",
            cluster_name="quickstart",
            envelope=materialize.SinkKafkaEnvelopeArgs(
                upsert=True,
            ),
            format=materialize.SinkKafkaFormatArgs(
                avro=materialize.SinkKafkaFormatAvroArgs(
                    schema_registry_connection=materialize.SinkKafkaFormatAvroSchemaRegistryConnectionArgs(
                        database_name="database",
                        name="csr_connection",
                        schema_name="schema",
                    ),
                ),
            ),
            from_=materialize.SinkKafkaFromArgs(
                name="table",
            ),
            kafka_connection=materialize.SinkKafkaKafkaConnectionArgs(
                name="kafka_connection",
            ),
            schema_name="schema",
            topic="test_avro_topic")
        ```

        ## Import

        Sinks can be imported using the sink id

        ```sh
         $ pulumi import materialize:index/sinkKafka:SinkKafka example_sink_kafka <region>:<sink_id>
        ```

         Sink id and information be found in the `mz_catalog.mz_sinks` table The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_name: The cluster to maintain this sink.
        :param pulumi.Input[str] comment: **Public Preview** Comment on an object in the database.
        :param pulumi.Input[str] compression_type: The type of compression to apply to messages before they are sent to Kafka.
        :param pulumi.Input[str] database_name: The identifier for the sink database. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[pulumi.InputType['SinkKafkaEnvelopeArgs']] envelope: How to interpret records (e.g. Debezium, Upsert).
        :param pulumi.Input[pulumi.InputType['SinkKafkaFormatArgs']] format: How to decode raw bytes from different formats into data structures it can understand at runtime.
        :param pulumi.Input[pulumi.InputType['SinkKafkaFromArgs']] from_: The name of the source, table or materialized view you want to send to the sink.
        :param pulumi.Input[pulumi.InputType['SinkKafkaKafkaConnectionArgs']] kafka_connection: The name of the Kafka connection to use in the sink.
        :param pulumi.Input[bool] key_not_enforced: Disable Materialize's validation of the key's uniqueness.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] keys: An optional list of columns to use for the Kafka key. If unspecified, the Kafka key is left unset.
        :param pulumi.Input[str] name: The identifier for the sink.
        :param pulumi.Input[str] ownership_role: The owernship role of the object.
        :param pulumi.Input[str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[str] schema_name: The identifier for the sink schema. Defaults to `public`.
        :param pulumi.Input[bool] snapshot: Whether to emit the consolidated results of the query before the sink was created at the start of the sink.
        :param pulumi.Input[str] topic: The Kafka topic you want to subscribe to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SinkKafkaArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Kafka sink establishes a link to a Kafka cluster that you want Materialize to write data to.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        example_sink_kafka = materialize.SinkKafka("exampleSinkKafka",
            cluster_name="quickstart",
            envelope=materialize.SinkKafkaEnvelopeArgs(
                upsert=True,
            ),
            format=materialize.SinkKafkaFormatArgs(
                avro=materialize.SinkKafkaFormatAvroArgs(
                    schema_registry_connection=materialize.SinkKafkaFormatAvroSchemaRegistryConnectionArgs(
                        database_name="database",
                        name="csr_connection",
                        schema_name="schema",
                    ),
                ),
            ),
            from_=materialize.SinkKafkaFromArgs(
                name="table",
            ),
            kafka_connection=materialize.SinkKafkaKafkaConnectionArgs(
                name="kafka_connection",
            ),
            schema_name="schema",
            topic="test_avro_topic")
        ```

        ## Import

        Sinks can be imported using the sink id

        ```sh
         $ pulumi import materialize:index/sinkKafka:SinkKafka example_sink_kafka <region>:<sink_id>
        ```

         Sink id and information be found in the `mz_catalog.mz_sinks` table The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param SinkKafkaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SinkKafkaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 compression_type: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 envelope: Optional[pulumi.Input[pulumi.InputType['SinkKafkaEnvelopeArgs']]] = None,
                 format: Optional[pulumi.Input[pulumi.InputType['SinkKafkaFormatArgs']]] = None,
                 from_: Optional[pulumi.Input[pulumi.InputType['SinkKafkaFromArgs']]] = None,
                 kafka_connection: Optional[pulumi.Input[pulumi.InputType['SinkKafkaKafkaConnectionArgs']]] = None,
                 key_not_enforced: Optional[pulumi.Input[bool]] = None,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ownership_role: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 schema_name: Optional[pulumi.Input[str]] = None,
                 snapshot: Optional[pulumi.Input[bool]] = None,
                 topic: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SinkKafkaArgs.__new__(SinkKafkaArgs)

            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["comment"] = comment
            __props__.__dict__["compression_type"] = compression_type
            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["envelope"] = envelope
            __props__.__dict__["format"] = format
            if from_ is None and not opts.urn:
                raise TypeError("Missing required property 'from_'")
            __props__.__dict__["from_"] = from_
            if kafka_connection is None and not opts.urn:
                raise TypeError("Missing required property 'kafka_connection'")
            __props__.__dict__["kafka_connection"] = kafka_connection
            __props__.__dict__["key_not_enforced"] = key_not_enforced
            __props__.__dict__["keys"] = keys
            __props__.__dict__["name"] = name
            __props__.__dict__["ownership_role"] = ownership_role
            __props__.__dict__["region"] = region
            __props__.__dict__["schema_name"] = schema_name
            __props__.__dict__["snapshot"] = snapshot
            if topic is None and not opts.urn:
                raise TypeError("Missing required property 'topic'")
            __props__.__dict__["topic"] = topic
            __props__.__dict__["qualified_sql_name"] = None
            __props__.__dict__["size"] = None
        super(SinkKafka, __self__).__init__(
            'materialize:index/sinkKafka:SinkKafka',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_name: Optional[pulumi.Input[str]] = None,
            comment: Optional[pulumi.Input[str]] = None,
            compression_type: Optional[pulumi.Input[str]] = None,
            database_name: Optional[pulumi.Input[str]] = None,
            envelope: Optional[pulumi.Input[pulumi.InputType['SinkKafkaEnvelopeArgs']]] = None,
            format: Optional[pulumi.Input[pulumi.InputType['SinkKafkaFormatArgs']]] = None,
            from_: Optional[pulumi.Input[pulumi.InputType['SinkKafkaFromArgs']]] = None,
            kafka_connection: Optional[pulumi.Input[pulumi.InputType['SinkKafkaKafkaConnectionArgs']]] = None,
            key_not_enforced: Optional[pulumi.Input[bool]] = None,
            keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            ownership_role: Optional[pulumi.Input[str]] = None,
            qualified_sql_name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            schema_name: Optional[pulumi.Input[str]] = None,
            size: Optional[pulumi.Input[str]] = None,
            snapshot: Optional[pulumi.Input[bool]] = None,
            topic: Optional[pulumi.Input[str]] = None) -> 'SinkKafka':
        """
        Get an existing SinkKafka resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_name: The cluster to maintain this sink.
        :param pulumi.Input[str] comment: **Public Preview** Comment on an object in the database.
        :param pulumi.Input[str] compression_type: The type of compression to apply to messages before they are sent to Kafka.
        :param pulumi.Input[str] database_name: The identifier for the sink database. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[pulumi.InputType['SinkKafkaEnvelopeArgs']] envelope: How to interpret records (e.g. Debezium, Upsert).
        :param pulumi.Input[pulumi.InputType['SinkKafkaFormatArgs']] format: How to decode raw bytes from different formats into data structures it can understand at runtime.
        :param pulumi.Input[pulumi.InputType['SinkKafkaFromArgs']] from_: The name of the source, table or materialized view you want to send to the sink.
        :param pulumi.Input[pulumi.InputType['SinkKafkaKafkaConnectionArgs']] kafka_connection: The name of the Kafka connection to use in the sink.
        :param pulumi.Input[bool] key_not_enforced: Disable Materialize's validation of the key's uniqueness.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] keys: An optional list of columns to use for the Kafka key. If unspecified, the Kafka key is left unset.
        :param pulumi.Input[str] name: The identifier for the sink.
        :param pulumi.Input[str] ownership_role: The owernship role of the object.
        :param pulumi.Input[str] qualified_sql_name: The fully qualified name of the sink.
        :param pulumi.Input[str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[str] schema_name: The identifier for the sink schema. Defaults to `public`.
        :param pulumi.Input[str] size: The size of the cluster maintaining this sink.
        :param pulumi.Input[bool] snapshot: Whether to emit the consolidated results of the query before the sink was created at the start of the sink.
        :param pulumi.Input[str] topic: The Kafka topic you want to subscribe to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SinkKafkaState.__new__(_SinkKafkaState)

        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["comment"] = comment
        __props__.__dict__["compression_type"] = compression_type
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["envelope"] = envelope
        __props__.__dict__["format"] = format
        __props__.__dict__["from_"] = from_
        __props__.__dict__["kafka_connection"] = kafka_connection
        __props__.__dict__["key_not_enforced"] = key_not_enforced
        __props__.__dict__["keys"] = keys
        __props__.__dict__["name"] = name
        __props__.__dict__["ownership_role"] = ownership_role
        __props__.__dict__["qualified_sql_name"] = qualified_sql_name
        __props__.__dict__["region"] = region
        __props__.__dict__["schema_name"] = schema_name
        __props__.__dict__["size"] = size
        __props__.__dict__["snapshot"] = snapshot
        __props__.__dict__["topic"] = topic
        return SinkKafka(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[str]:
        """
        The cluster to maintain this sink.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[str]]:
        """
        **Public Preview** Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="compressionType")
    def compression_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of compression to apply to messages before they are sent to Kafka.
        """
        return pulumi.get(self, "compression_type")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[Optional[str]]:
        """
        The identifier for the sink database. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def envelope(self) -> pulumi.Output[Optional['outputs.SinkKafkaEnvelope']]:
        """
        How to interpret records (e.g. Debezium, Upsert).
        """
        return pulumi.get(self, "envelope")

    @property
    @pulumi.getter
    def format(self) -> pulumi.Output[Optional['outputs.SinkKafkaFormat']]:
        """
        How to decode raw bytes from different formats into data structures it can understand at runtime.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="from")
    def from_(self) -> pulumi.Output['outputs.SinkKafkaFrom']:
        """
        The name of the source, table or materialized view you want to send to the sink.
        """
        return pulumi.get(self, "from_")

    @property
    @pulumi.getter(name="kafkaConnection")
    def kafka_connection(self) -> pulumi.Output['outputs.SinkKafkaKafkaConnection']:
        """
        The name of the Kafka connection to use in the sink.
        """
        return pulumi.get(self, "kafka_connection")

    @property
    @pulumi.getter(name="keyNotEnforced")
    def key_not_enforced(self) -> pulumi.Output[Optional[bool]]:
        """
        Disable Materialize's validation of the key's uniqueness.
        """
        return pulumi.get(self, "key_not_enforced")

    @property
    @pulumi.getter
    def keys(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        An optional list of columns to use for the Kafka key. If unspecified, the Kafka key is left unset.
        """
        return pulumi.get(self, "keys")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The identifier for the sink.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> pulumi.Output[str]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @property
    @pulumi.getter(name="qualifiedSqlName")
    def qualified_sql_name(self) -> pulumi.Output[str]:
        """
        The fully qualified name of the sink.
        """
        return pulumi.get(self, "qualified_sql_name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> pulumi.Output[Optional[str]]:
        """
        The identifier for the sink schema. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[str]:
        """
        The size of the cluster maintaining this sink.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def snapshot(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to emit the consolidated results of the query before the sink was created at the start of the sink.
        """
        return pulumi.get(self, "snapshot")

    @property
    @pulumi.getter
    def topic(self) -> pulumi.Output[str]:
        """
        The Kafka topic you want to subscribe to.
        """
        return pulumi.get(self, "topic")

