# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SourcePostgresArgs', 'SourcePostgres']

@pulumi.input_type
class SourcePostgresArgs:
    def __init__(__self__, *,
                 postgres_connection: pulumi.Input['SourcePostgresPostgresConnectionArgs'],
                 publication: pulumi.Input[str],
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 expose_progress: Optional[pulumi.Input['SourcePostgresExposeProgressArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ownership_role: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 schema_name: Optional[pulumi.Input[str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tables: Optional[pulumi.Input[Sequence[pulumi.Input['SourcePostgresTableArgs']]]] = None,
                 text_columns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a SourcePostgres resource.
        :param pulumi.Input['SourcePostgresPostgresConnectionArgs'] postgres_connection: The PostgreSQL connection to use in the source.
        :param pulumi.Input[str] publication: The PostgreSQL publication (the replication data set containing the tables to be streamed to Materialize).
        :param pulumi.Input[str] cluster_name: The cluster to maintain this source.
        :param pulumi.Input[str] comment: **Public Preview** Comment on an object in the database.
        :param pulumi.Input[str] database_name: The identifier for the source database. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input['SourcePostgresExposeProgressArgs'] expose_progress: The name of the progress subsource for the source. If this is not specified, the subsource will be named `<src_name>_progress`.
        :param pulumi.Input[str] name: The identifier for the source.
        :param pulumi.Input[str] ownership_role: The owernship role of the object.
        :param pulumi.Input[str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[str] schema_name: The identifier for the source schema. Defaults to `public`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: Creates subsources for specific schemas. If neither table or schema is specified, will default to ALL TABLES
        :param pulumi.Input[Sequence[pulumi.Input['SourcePostgresTableArgs']]] tables: Creates subsources for specific tables. If neither table or schema is specified, will default to ALL TABLES
        :param pulumi.Input[Sequence[pulumi.Input[str]]] text_columns: Decode data as text for specific columns that contain PostgreSQL types that are unsupported in Materialize. Can only be updated in place when also updating a corresponding `table` attribute.
        """
        pulumi.set(__self__, "postgres_connection", postgres_connection)
        pulumi.set(__self__, "publication", publication)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if expose_progress is not None:
            pulumi.set(__self__, "expose_progress", expose_progress)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ownership_role is not None:
            pulumi.set(__self__, "ownership_role", ownership_role)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if schemas is not None:
            pulumi.set(__self__, "schemas", schemas)
        if tables is not None:
            pulumi.set(__self__, "tables", tables)
        if text_columns is not None:
            pulumi.set(__self__, "text_columns", text_columns)

    @property
    @pulumi.getter(name="postgresConnection")
    def postgres_connection(self) -> pulumi.Input['SourcePostgresPostgresConnectionArgs']:
        """
        The PostgreSQL connection to use in the source.
        """
        return pulumi.get(self, "postgres_connection")

    @postgres_connection.setter
    def postgres_connection(self, value: pulumi.Input['SourcePostgresPostgresConnectionArgs']):
        pulumi.set(self, "postgres_connection", value)

    @property
    @pulumi.getter
    def publication(self) -> pulumi.Input[str]:
        """
        The PostgreSQL publication (the replication data set containing the tables to be streamed to Materialize).
        """
        return pulumi.get(self, "publication")

    @publication.setter
    def publication(self, value: pulumi.Input[str]):
        pulumi.set(self, "publication", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster to maintain this source.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        **Public Preview** Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the source database. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="exposeProgress")
    def expose_progress(self) -> Optional[pulumi.Input['SourcePostgresExposeProgressArgs']]:
        """
        The name of the progress subsource for the source. If this is not specified, the subsource will be named `<src_name>_progress`.
        """
        return pulumi.get(self, "expose_progress")

    @expose_progress.setter
    def expose_progress(self, value: Optional[pulumi.Input['SourcePostgresExposeProgressArgs']]):
        pulumi.set(self, "expose_progress", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the source.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> Optional[pulumi.Input[str]]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @ownership_role.setter
    def ownership_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ownership_role", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the source schema. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema_name", value)

    @property
    @pulumi.getter
    def schemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Creates subsources for specific schemas. If neither table or schema is specified, will default to ALL TABLES
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter
    def tables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SourcePostgresTableArgs']]]]:
        """
        Creates subsources for specific tables. If neither table or schema is specified, will default to ALL TABLES
        """
        return pulumi.get(self, "tables")

    @tables.setter
    def tables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SourcePostgresTableArgs']]]]):
        pulumi.set(self, "tables", value)

    @property
    @pulumi.getter(name="textColumns")
    def text_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Decode data as text for specific columns that contain PostgreSQL types that are unsupported in Materialize. Can only be updated in place when also updating a corresponding `table` attribute.
        """
        return pulumi.get(self, "text_columns")

    @text_columns.setter
    def text_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "text_columns", value)


@pulumi.input_type
class _SourcePostgresState:
    def __init__(__self__, *,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 expose_progress: Optional[pulumi.Input['SourcePostgresExposeProgressArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ownership_role: Optional[pulumi.Input[str]] = None,
                 postgres_connection: Optional[pulumi.Input['SourcePostgresPostgresConnectionArgs']] = None,
                 publication: Optional[pulumi.Input[str]] = None,
                 qualified_sql_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 schema_name: Optional[pulumi.Input[str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 subsources: Optional[pulumi.Input[Sequence[pulumi.Input['SourcePostgresSubsourceArgs']]]] = None,
                 tables: Optional[pulumi.Input[Sequence[pulumi.Input['SourcePostgresTableArgs']]]] = None,
                 text_columns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering SourcePostgres resources.
        :param pulumi.Input[str] cluster_name: The cluster to maintain this source.
        :param pulumi.Input[str] comment: **Public Preview** Comment on an object in the database.
        :param pulumi.Input[str] database_name: The identifier for the source database. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input['SourcePostgresExposeProgressArgs'] expose_progress: The name of the progress subsource for the source. If this is not specified, the subsource will be named `<src_name>_progress`.
        :param pulumi.Input[str] name: The identifier for the source.
        :param pulumi.Input[str] ownership_role: The owernship role of the object.
        :param pulumi.Input['SourcePostgresPostgresConnectionArgs'] postgres_connection: The PostgreSQL connection to use in the source.
        :param pulumi.Input[str] publication: The PostgreSQL publication (the replication data set containing the tables to be streamed to Materialize).
        :param pulumi.Input[str] qualified_sql_name: The fully qualified name of the source.
        :param pulumi.Input[str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[str] schema_name: The identifier for the source schema. Defaults to `public`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: Creates subsources for specific schemas. If neither table or schema is specified, will default to ALL TABLES
        :param pulumi.Input[str] size: The size of the cluster maintaining this source.
        :param pulumi.Input[Sequence[pulumi.Input['SourcePostgresSubsourceArgs']]] subsources: Subsources of a source.
        :param pulumi.Input[Sequence[pulumi.Input['SourcePostgresTableArgs']]] tables: Creates subsources for specific tables. If neither table or schema is specified, will default to ALL TABLES
        :param pulumi.Input[Sequence[pulumi.Input[str]]] text_columns: Decode data as text for specific columns that contain PostgreSQL types that are unsupported in Materialize. Can only be updated in place when also updating a corresponding `table` attribute.
        """
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if expose_progress is not None:
            pulumi.set(__self__, "expose_progress", expose_progress)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ownership_role is not None:
            pulumi.set(__self__, "ownership_role", ownership_role)
        if postgres_connection is not None:
            pulumi.set(__self__, "postgres_connection", postgres_connection)
        if publication is not None:
            pulumi.set(__self__, "publication", publication)
        if qualified_sql_name is not None:
            pulumi.set(__self__, "qualified_sql_name", qualified_sql_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if schemas is not None:
            pulumi.set(__self__, "schemas", schemas)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if subsources is not None:
            pulumi.set(__self__, "subsources", subsources)
        if tables is not None:
            pulumi.set(__self__, "tables", tables)
        if text_columns is not None:
            pulumi.set(__self__, "text_columns", text_columns)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster to maintain this source.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        **Public Preview** Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the source database. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="exposeProgress")
    def expose_progress(self) -> Optional[pulumi.Input['SourcePostgresExposeProgressArgs']]:
        """
        The name of the progress subsource for the source. If this is not specified, the subsource will be named `<src_name>_progress`.
        """
        return pulumi.get(self, "expose_progress")

    @expose_progress.setter
    def expose_progress(self, value: Optional[pulumi.Input['SourcePostgresExposeProgressArgs']]):
        pulumi.set(self, "expose_progress", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the source.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> Optional[pulumi.Input[str]]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @ownership_role.setter
    def ownership_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ownership_role", value)

    @property
    @pulumi.getter(name="postgresConnection")
    def postgres_connection(self) -> Optional[pulumi.Input['SourcePostgresPostgresConnectionArgs']]:
        """
        The PostgreSQL connection to use in the source.
        """
        return pulumi.get(self, "postgres_connection")

    @postgres_connection.setter
    def postgres_connection(self, value: Optional[pulumi.Input['SourcePostgresPostgresConnectionArgs']]):
        pulumi.set(self, "postgres_connection", value)

    @property
    @pulumi.getter
    def publication(self) -> Optional[pulumi.Input[str]]:
        """
        The PostgreSQL publication (the replication data set containing the tables to be streamed to Materialize).
        """
        return pulumi.get(self, "publication")

    @publication.setter
    def publication(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "publication", value)

    @property
    @pulumi.getter(name="qualifiedSqlName")
    def qualified_sql_name(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified name of the source.
        """
        return pulumi.get(self, "qualified_sql_name")

    @qualified_sql_name.setter
    def qualified_sql_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "qualified_sql_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the source schema. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema_name", value)

    @property
    @pulumi.getter
    def schemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Creates subsources for specific schemas. If neither table or schema is specified, will default to ALL TABLES
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        The size of the cluster maintaining this source.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def subsources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SourcePostgresSubsourceArgs']]]]:
        """
        Subsources of a source.
        """
        return pulumi.get(self, "subsources")

    @subsources.setter
    def subsources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SourcePostgresSubsourceArgs']]]]):
        pulumi.set(self, "subsources", value)

    @property
    @pulumi.getter
    def tables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SourcePostgresTableArgs']]]]:
        """
        Creates subsources for specific tables. If neither table or schema is specified, will default to ALL TABLES
        """
        return pulumi.get(self, "tables")

    @tables.setter
    def tables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SourcePostgresTableArgs']]]]):
        pulumi.set(self, "tables", value)

    @property
    @pulumi.getter(name="textColumns")
    def text_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Decode data as text for specific columns that contain PostgreSQL types that are unsupported in Materialize. Can only be updated in place when also updating a corresponding `table` attribute.
        """
        return pulumi.get(self, "text_columns")

    @text_columns.setter
    def text_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "text_columns", value)


class SourcePostgres(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 expose_progress: Optional[pulumi.Input[pulumi.InputType['SourcePostgresExposeProgressArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ownership_role: Optional[pulumi.Input[str]] = None,
                 postgres_connection: Optional[pulumi.Input[pulumi.InputType['SourcePostgresPostgresConnectionArgs']]] = None,
                 publication: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 schema_name: Optional[pulumi.Input[str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tables: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SourcePostgresTableArgs']]]]] = None,
                 text_columns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        A Postgres source describes a PostgreSQL instance you want Materialize to read data from.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        example_source_postgres = materialize.SourcePostgres("exampleSourcePostgres",
            cluster_name="quickstart",
            postgres_connection=materialize.SourcePostgresPostgresConnectionArgs(
                name="pg_connection",
            ),
            publication="mz_source",
            schema_name="schema",
            tables=[
                materialize.SourcePostgresTableArgs(
                    alias="s1_table_1",
                    name="schema1.table_1",
                ),
                materialize.SourcePostgresTableArgs(
                    alias="s2_table_1",
                    name="schema2.table_1",
                ),
            ])
        ```

        ## Import

        Sources can be imported using the source id

        ```sh
         $ pulumi import materialize:index/sourcePostgres:SourcePostgres example_source_postgres <region>:<source_id>
        ```

         Source id and information be found in the `mz_catalog.mz_sources` table The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_name: The cluster to maintain this source.
        :param pulumi.Input[str] comment: **Public Preview** Comment on an object in the database.
        :param pulumi.Input[str] database_name: The identifier for the source database. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[pulumi.InputType['SourcePostgresExposeProgressArgs']] expose_progress: The name of the progress subsource for the source. If this is not specified, the subsource will be named `<src_name>_progress`.
        :param pulumi.Input[str] name: The identifier for the source.
        :param pulumi.Input[str] ownership_role: The owernship role of the object.
        :param pulumi.Input[pulumi.InputType['SourcePostgresPostgresConnectionArgs']] postgres_connection: The PostgreSQL connection to use in the source.
        :param pulumi.Input[str] publication: The PostgreSQL publication (the replication data set containing the tables to be streamed to Materialize).
        :param pulumi.Input[str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[str] schema_name: The identifier for the source schema. Defaults to `public`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: Creates subsources for specific schemas. If neither table or schema is specified, will default to ALL TABLES
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SourcePostgresTableArgs']]]] tables: Creates subsources for specific tables. If neither table or schema is specified, will default to ALL TABLES
        :param pulumi.Input[Sequence[pulumi.Input[str]]] text_columns: Decode data as text for specific columns that contain PostgreSQL types that are unsupported in Materialize. Can only be updated in place when also updating a corresponding `table` attribute.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SourcePostgresArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Postgres source describes a PostgreSQL instance you want Materialize to read data from.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        example_source_postgres = materialize.SourcePostgres("exampleSourcePostgres",
            cluster_name="quickstart",
            postgres_connection=materialize.SourcePostgresPostgresConnectionArgs(
                name="pg_connection",
            ),
            publication="mz_source",
            schema_name="schema",
            tables=[
                materialize.SourcePostgresTableArgs(
                    alias="s1_table_1",
                    name="schema1.table_1",
                ),
                materialize.SourcePostgresTableArgs(
                    alias="s2_table_1",
                    name="schema2.table_1",
                ),
            ])
        ```

        ## Import

        Sources can be imported using the source id

        ```sh
         $ pulumi import materialize:index/sourcePostgres:SourcePostgres example_source_postgres <region>:<source_id>
        ```

         Source id and information be found in the `mz_catalog.mz_sources` table The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param SourcePostgresArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SourcePostgresArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 expose_progress: Optional[pulumi.Input[pulumi.InputType['SourcePostgresExposeProgressArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ownership_role: Optional[pulumi.Input[str]] = None,
                 postgres_connection: Optional[pulumi.Input[pulumi.InputType['SourcePostgresPostgresConnectionArgs']]] = None,
                 publication: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 schema_name: Optional[pulumi.Input[str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tables: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SourcePostgresTableArgs']]]]] = None,
                 text_columns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SourcePostgresArgs.__new__(SourcePostgresArgs)

            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["comment"] = comment
            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["expose_progress"] = expose_progress
            __props__.__dict__["name"] = name
            __props__.__dict__["ownership_role"] = ownership_role
            if postgres_connection is None and not opts.urn:
                raise TypeError("Missing required property 'postgres_connection'")
            __props__.__dict__["postgres_connection"] = postgres_connection
            if publication is None and not opts.urn:
                raise TypeError("Missing required property 'publication'")
            __props__.__dict__["publication"] = publication
            __props__.__dict__["region"] = region
            __props__.__dict__["schema_name"] = schema_name
            __props__.__dict__["schemas"] = schemas
            __props__.__dict__["tables"] = tables
            __props__.__dict__["text_columns"] = text_columns
            __props__.__dict__["qualified_sql_name"] = None
            __props__.__dict__["size"] = None
            __props__.__dict__["subsources"] = None
        super(SourcePostgres, __self__).__init__(
            'materialize:index/sourcePostgres:SourcePostgres',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_name: Optional[pulumi.Input[str]] = None,
            comment: Optional[pulumi.Input[str]] = None,
            database_name: Optional[pulumi.Input[str]] = None,
            expose_progress: Optional[pulumi.Input[pulumi.InputType['SourcePostgresExposeProgressArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            ownership_role: Optional[pulumi.Input[str]] = None,
            postgres_connection: Optional[pulumi.Input[pulumi.InputType['SourcePostgresPostgresConnectionArgs']]] = None,
            publication: Optional[pulumi.Input[str]] = None,
            qualified_sql_name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            schema_name: Optional[pulumi.Input[str]] = None,
            schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            size: Optional[pulumi.Input[str]] = None,
            subsources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SourcePostgresSubsourceArgs']]]]] = None,
            tables: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SourcePostgresTableArgs']]]]] = None,
            text_columns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'SourcePostgres':
        """
        Get an existing SourcePostgres resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_name: The cluster to maintain this source.
        :param pulumi.Input[str] comment: **Public Preview** Comment on an object in the database.
        :param pulumi.Input[str] database_name: The identifier for the source database. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[pulumi.InputType['SourcePostgresExposeProgressArgs']] expose_progress: The name of the progress subsource for the source. If this is not specified, the subsource will be named `<src_name>_progress`.
        :param pulumi.Input[str] name: The identifier for the source.
        :param pulumi.Input[str] ownership_role: The owernship role of the object.
        :param pulumi.Input[pulumi.InputType['SourcePostgresPostgresConnectionArgs']] postgres_connection: The PostgreSQL connection to use in the source.
        :param pulumi.Input[str] publication: The PostgreSQL publication (the replication data set containing the tables to be streamed to Materialize).
        :param pulumi.Input[str] qualified_sql_name: The fully qualified name of the source.
        :param pulumi.Input[str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[str] schema_name: The identifier for the source schema. Defaults to `public`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: Creates subsources for specific schemas. If neither table or schema is specified, will default to ALL TABLES
        :param pulumi.Input[str] size: The size of the cluster maintaining this source.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SourcePostgresSubsourceArgs']]]] subsources: Subsources of a source.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SourcePostgresTableArgs']]]] tables: Creates subsources for specific tables. If neither table or schema is specified, will default to ALL TABLES
        :param pulumi.Input[Sequence[pulumi.Input[str]]] text_columns: Decode data as text for specific columns that contain PostgreSQL types that are unsupported in Materialize. Can only be updated in place when also updating a corresponding `table` attribute.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SourcePostgresState.__new__(_SourcePostgresState)

        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["comment"] = comment
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["expose_progress"] = expose_progress
        __props__.__dict__["name"] = name
        __props__.__dict__["ownership_role"] = ownership_role
        __props__.__dict__["postgres_connection"] = postgres_connection
        __props__.__dict__["publication"] = publication
        __props__.__dict__["qualified_sql_name"] = qualified_sql_name
        __props__.__dict__["region"] = region
        __props__.__dict__["schema_name"] = schema_name
        __props__.__dict__["schemas"] = schemas
        __props__.__dict__["size"] = size
        __props__.__dict__["subsources"] = subsources
        __props__.__dict__["tables"] = tables
        __props__.__dict__["text_columns"] = text_columns
        return SourcePostgres(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[str]:
        """
        The cluster to maintain this source.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[str]]:
        """
        **Public Preview** Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[Optional[str]]:
        """
        The identifier for the source database. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="exposeProgress")
    def expose_progress(self) -> pulumi.Output[Optional['outputs.SourcePostgresExposeProgress']]:
        """
        The name of the progress subsource for the source. If this is not specified, the subsource will be named `<src_name>_progress`.
        """
        return pulumi.get(self, "expose_progress")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The identifier for the source.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> pulumi.Output[str]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @property
    @pulumi.getter(name="postgresConnection")
    def postgres_connection(self) -> pulumi.Output['outputs.SourcePostgresPostgresConnection']:
        """
        The PostgreSQL connection to use in the source.
        """
        return pulumi.get(self, "postgres_connection")

    @property
    @pulumi.getter
    def publication(self) -> pulumi.Output[str]:
        """
        The PostgreSQL publication (the replication data set containing the tables to be streamed to Materialize).
        """
        return pulumi.get(self, "publication")

    @property
    @pulumi.getter(name="qualifiedSqlName")
    def qualified_sql_name(self) -> pulumi.Output[str]:
        """
        The fully qualified name of the source.
        """
        return pulumi.get(self, "qualified_sql_name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> pulumi.Output[Optional[str]]:
        """
        The identifier for the source schema. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Creates subsources for specific schemas. If neither table or schema is specified, will default to ALL TABLES
        """
        return pulumi.get(self, "schemas")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[str]:
        """
        The size of the cluster maintaining this source.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def subsources(self) -> pulumi.Output[Sequence['outputs.SourcePostgresSubsource']]:
        """
        Subsources of a source.
        """
        return pulumi.get(self, "subsources")

    @property
    @pulumi.getter
    def tables(self) -> pulumi.Output[Optional[Sequence['outputs.SourcePostgresTable']]]:
        """
        Creates subsources for specific tables. If neither table or schema is specified, will default to ALL TABLES
        """
        return pulumi.get(self, "tables")

    @property
    @pulumi.getter(name="textColumns")
    def text_columns(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Decode data as text for specific columns that contain PostgreSQL types that are unsupported in Materialize. Can only be updated in place when also updating a corresponding `table` attribute.
        """
        return pulumi.get(self, "text_columns")

