# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SourceWebhookArgs', 'SourceWebhook']

@pulumi.input_type
class SourceWebhookArgs:
    def __init__(__self__, *,
                 body_format: pulumi.Input[str],
                 check_expression: Optional[pulumi.Input[str]] = None,
                 check_options: Optional[pulumi.Input[Sequence[pulumi.Input['SourceWebhookCheckOptionArgs']]]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 include_header: Optional[pulumi.Input[Sequence[pulumi.Input['SourceWebhookIncludeHeaderArgs']]]] = None,
                 include_headers: Optional[pulumi.Input['SourceWebhookIncludeHeadersArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ownership_role: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 schema_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SourceWebhook resource.
        :param pulumi.Input[str] body_format: The body format of the webhook.
        :param pulumi.Input[str] check_expression: The check expression for the webhook.
        :param pulumi.Input[Sequence[pulumi.Input['SourceWebhookCheckOptionArgs']]] check_options: The check options for the webhook.
        :param pulumi.Input[str] cluster_name: The cluster to maintain this source.
        :param pulumi.Input[str] comment: **Public Preview** Comment on an object in the database.
        :param pulumi.Input[str] database_name: The identifier for the source database. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[Sequence[pulumi.Input['SourceWebhookIncludeHeaderArgs']]] include_header: Map a header value from a request into a column.
        :param pulumi.Input['SourceWebhookIncludeHeadersArgs'] include_headers: Include headers in the webhook.
        :param pulumi.Input[str] name: The identifier for the source.
        :param pulumi.Input[str] ownership_role: The owernship role of the object.
        :param pulumi.Input[str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[str] schema_name: The identifier for the source schema. Defaults to `public`.
        """
        pulumi.set(__self__, "body_format", body_format)
        if check_expression is not None:
            pulumi.set(__self__, "check_expression", check_expression)
        if check_options is not None:
            pulumi.set(__self__, "check_options", check_options)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if include_header is not None:
            pulumi.set(__self__, "include_header", include_header)
        if include_headers is not None:
            pulumi.set(__self__, "include_headers", include_headers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ownership_role is not None:
            pulumi.set(__self__, "ownership_role", ownership_role)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)

    @property
    @pulumi.getter(name="bodyFormat")
    def body_format(self) -> pulumi.Input[str]:
        """
        The body format of the webhook.
        """
        return pulumi.get(self, "body_format")

    @body_format.setter
    def body_format(self, value: pulumi.Input[str]):
        pulumi.set(self, "body_format", value)

    @property
    @pulumi.getter(name="checkExpression")
    def check_expression(self) -> Optional[pulumi.Input[str]]:
        """
        The check expression for the webhook.
        """
        return pulumi.get(self, "check_expression")

    @check_expression.setter
    def check_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "check_expression", value)

    @property
    @pulumi.getter(name="checkOptions")
    def check_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SourceWebhookCheckOptionArgs']]]]:
        """
        The check options for the webhook.
        """
        return pulumi.get(self, "check_options")

    @check_options.setter
    def check_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SourceWebhookCheckOptionArgs']]]]):
        pulumi.set(self, "check_options", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster to maintain this source.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        **Public Preview** Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the source database. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="includeHeader")
    def include_header(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SourceWebhookIncludeHeaderArgs']]]]:
        """
        Map a header value from a request into a column.
        """
        return pulumi.get(self, "include_header")

    @include_header.setter
    def include_header(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SourceWebhookIncludeHeaderArgs']]]]):
        pulumi.set(self, "include_header", value)

    @property
    @pulumi.getter(name="includeHeaders")
    def include_headers(self) -> Optional[pulumi.Input['SourceWebhookIncludeHeadersArgs']]:
        """
        Include headers in the webhook.
        """
        return pulumi.get(self, "include_headers")

    @include_headers.setter
    def include_headers(self, value: Optional[pulumi.Input['SourceWebhookIncludeHeadersArgs']]):
        pulumi.set(self, "include_headers", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the source.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> Optional[pulumi.Input[str]]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @ownership_role.setter
    def ownership_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ownership_role", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the source schema. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema_name", value)


@pulumi.input_type
class _SourceWebhookState:
    def __init__(__self__, *,
                 body_format: Optional[pulumi.Input[str]] = None,
                 check_expression: Optional[pulumi.Input[str]] = None,
                 check_options: Optional[pulumi.Input[Sequence[pulumi.Input['SourceWebhookCheckOptionArgs']]]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 include_header: Optional[pulumi.Input[Sequence[pulumi.Input['SourceWebhookIncludeHeaderArgs']]]] = None,
                 include_headers: Optional[pulumi.Input['SourceWebhookIncludeHeadersArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ownership_role: Optional[pulumi.Input[str]] = None,
                 qualified_sql_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 schema_name: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 subsources: Optional[pulumi.Input[Sequence[pulumi.Input['SourceWebhookSubsourceArgs']]]] = None):
        """
        Input properties used for looking up and filtering SourceWebhook resources.
        :param pulumi.Input[str] body_format: The body format of the webhook.
        :param pulumi.Input[str] check_expression: The check expression for the webhook.
        :param pulumi.Input[Sequence[pulumi.Input['SourceWebhookCheckOptionArgs']]] check_options: The check options for the webhook.
        :param pulumi.Input[str] cluster_name: The cluster to maintain this source.
        :param pulumi.Input[str] comment: **Public Preview** Comment on an object in the database.
        :param pulumi.Input[str] database_name: The identifier for the source database. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[Sequence[pulumi.Input['SourceWebhookIncludeHeaderArgs']]] include_header: Map a header value from a request into a column.
        :param pulumi.Input['SourceWebhookIncludeHeadersArgs'] include_headers: Include headers in the webhook.
        :param pulumi.Input[str] name: The identifier for the source.
        :param pulumi.Input[str] ownership_role: The owernship role of the object.
        :param pulumi.Input[str] qualified_sql_name: The fully qualified name of the source.
        :param pulumi.Input[str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[str] schema_name: The identifier for the source schema. Defaults to `public`.
        :param pulumi.Input[str] size: The size of the cluster maintaining this source.
        :param pulumi.Input[Sequence[pulumi.Input['SourceWebhookSubsourceArgs']]] subsources: Subsources of a source.
        """
        if body_format is not None:
            pulumi.set(__self__, "body_format", body_format)
        if check_expression is not None:
            pulumi.set(__self__, "check_expression", check_expression)
        if check_options is not None:
            pulumi.set(__self__, "check_options", check_options)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if include_header is not None:
            pulumi.set(__self__, "include_header", include_header)
        if include_headers is not None:
            pulumi.set(__self__, "include_headers", include_headers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ownership_role is not None:
            pulumi.set(__self__, "ownership_role", ownership_role)
        if qualified_sql_name is not None:
            pulumi.set(__self__, "qualified_sql_name", qualified_sql_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if subsources is not None:
            pulumi.set(__self__, "subsources", subsources)

    @property
    @pulumi.getter(name="bodyFormat")
    def body_format(self) -> Optional[pulumi.Input[str]]:
        """
        The body format of the webhook.
        """
        return pulumi.get(self, "body_format")

    @body_format.setter
    def body_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "body_format", value)

    @property
    @pulumi.getter(name="checkExpression")
    def check_expression(self) -> Optional[pulumi.Input[str]]:
        """
        The check expression for the webhook.
        """
        return pulumi.get(self, "check_expression")

    @check_expression.setter
    def check_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "check_expression", value)

    @property
    @pulumi.getter(name="checkOptions")
    def check_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SourceWebhookCheckOptionArgs']]]]:
        """
        The check options for the webhook.
        """
        return pulumi.get(self, "check_options")

    @check_options.setter
    def check_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SourceWebhookCheckOptionArgs']]]]):
        pulumi.set(self, "check_options", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster to maintain this source.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        **Public Preview** Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the source database. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="includeHeader")
    def include_header(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SourceWebhookIncludeHeaderArgs']]]]:
        """
        Map a header value from a request into a column.
        """
        return pulumi.get(self, "include_header")

    @include_header.setter
    def include_header(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SourceWebhookIncludeHeaderArgs']]]]):
        pulumi.set(self, "include_header", value)

    @property
    @pulumi.getter(name="includeHeaders")
    def include_headers(self) -> Optional[pulumi.Input['SourceWebhookIncludeHeadersArgs']]:
        """
        Include headers in the webhook.
        """
        return pulumi.get(self, "include_headers")

    @include_headers.setter
    def include_headers(self, value: Optional[pulumi.Input['SourceWebhookIncludeHeadersArgs']]):
        pulumi.set(self, "include_headers", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the source.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> Optional[pulumi.Input[str]]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @ownership_role.setter
    def ownership_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ownership_role", value)

    @property
    @pulumi.getter(name="qualifiedSqlName")
    def qualified_sql_name(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified name of the source.
        """
        return pulumi.get(self, "qualified_sql_name")

    @qualified_sql_name.setter
    def qualified_sql_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "qualified_sql_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the source schema. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema_name", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        The size of the cluster maintaining this source.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def subsources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SourceWebhookSubsourceArgs']]]]:
        """
        Subsources of a source.
        """
        return pulumi.get(self, "subsources")

    @subsources.setter
    def subsources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SourceWebhookSubsourceArgs']]]]):
        pulumi.set(self, "subsources", value)


class SourceWebhook(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 body_format: Optional[pulumi.Input[str]] = None,
                 check_expression: Optional[pulumi.Input[str]] = None,
                 check_options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SourceWebhookCheckOptionArgs']]]]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 include_header: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SourceWebhookIncludeHeaderArgs']]]]] = None,
                 include_headers: Optional[pulumi.Input[pulumi.InputType['SourceWebhookIncludeHeadersArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ownership_role: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 schema_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        **Private Preview** A webhook source describes a webhook you want Materialize to read data from.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        example_webhook = materialize.SourceWebhook("exampleWebhook",
            cluster_name=materialize_cluster["cluster"]["name"],
            body_format="json",
            check_expression="headers->'x-mz-api-key' = secret",
            include_headers=materialize.SourceWebhookIncludeHeadersArgs(
                nots=["x-mz-api-key"],
            ),
            check_options=[
                materialize.SourceWebhookCheckOptionArgs(
                    field=materialize.SourceWebhookCheckOptionFieldArgs(
                        headers=True,
                    ),
                ),
                materialize.SourceWebhookCheckOptionArgs(
                    field=materialize.SourceWebhookCheckOptionFieldArgs(
                        secret=materialize.SourceWebhookCheckOptionFieldSecretArgs(
                            name=materialize_secret["password"]["name"],
                            database_name=materialize_secret["password"]["database_name"],
                            schema_name=materialize_secret["password"]["schema_name"],
                        ),
                    ),
                    alias="secret",
                ),
            ])
        ```

        ## Import

        Sources can be imported using the source id

        ```sh
         $ pulumi import materialize:index/sourceWebhook:SourceWebhook example_source_webhook <region>:<source_id>
        ```

         Source id and information be found in the `mz_catalog.mz_sources` table The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] body_format: The body format of the webhook.
        :param pulumi.Input[str] check_expression: The check expression for the webhook.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SourceWebhookCheckOptionArgs']]]] check_options: The check options for the webhook.
        :param pulumi.Input[str] cluster_name: The cluster to maintain this source.
        :param pulumi.Input[str] comment: **Public Preview** Comment on an object in the database.
        :param pulumi.Input[str] database_name: The identifier for the source database. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SourceWebhookIncludeHeaderArgs']]]] include_header: Map a header value from a request into a column.
        :param pulumi.Input[pulumi.InputType['SourceWebhookIncludeHeadersArgs']] include_headers: Include headers in the webhook.
        :param pulumi.Input[str] name: The identifier for the source.
        :param pulumi.Input[str] ownership_role: The owernship role of the object.
        :param pulumi.Input[str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[str] schema_name: The identifier for the source schema. Defaults to `public`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SourceWebhookArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        **Private Preview** A webhook source describes a webhook you want Materialize to read data from.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        example_webhook = materialize.SourceWebhook("exampleWebhook",
            cluster_name=materialize_cluster["cluster"]["name"],
            body_format="json",
            check_expression="headers->'x-mz-api-key' = secret",
            include_headers=materialize.SourceWebhookIncludeHeadersArgs(
                nots=["x-mz-api-key"],
            ),
            check_options=[
                materialize.SourceWebhookCheckOptionArgs(
                    field=materialize.SourceWebhookCheckOptionFieldArgs(
                        headers=True,
                    ),
                ),
                materialize.SourceWebhookCheckOptionArgs(
                    field=materialize.SourceWebhookCheckOptionFieldArgs(
                        secret=materialize.SourceWebhookCheckOptionFieldSecretArgs(
                            name=materialize_secret["password"]["name"],
                            database_name=materialize_secret["password"]["database_name"],
                            schema_name=materialize_secret["password"]["schema_name"],
                        ),
                    ),
                    alias="secret",
                ),
            ])
        ```

        ## Import

        Sources can be imported using the source id

        ```sh
         $ pulumi import materialize:index/sourceWebhook:SourceWebhook example_source_webhook <region>:<source_id>
        ```

         Source id and information be found in the `mz_catalog.mz_sources` table The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param SourceWebhookArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SourceWebhookArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 body_format: Optional[pulumi.Input[str]] = None,
                 check_expression: Optional[pulumi.Input[str]] = None,
                 check_options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SourceWebhookCheckOptionArgs']]]]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 include_header: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SourceWebhookIncludeHeaderArgs']]]]] = None,
                 include_headers: Optional[pulumi.Input[pulumi.InputType['SourceWebhookIncludeHeadersArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ownership_role: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 schema_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SourceWebhookArgs.__new__(SourceWebhookArgs)

            if body_format is None and not opts.urn:
                raise TypeError("Missing required property 'body_format'")
            __props__.__dict__["body_format"] = body_format
            __props__.__dict__["check_expression"] = check_expression
            __props__.__dict__["check_options"] = check_options
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["comment"] = comment
            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["include_header"] = include_header
            __props__.__dict__["include_headers"] = include_headers
            __props__.__dict__["name"] = name
            __props__.__dict__["ownership_role"] = ownership_role
            __props__.__dict__["region"] = region
            __props__.__dict__["schema_name"] = schema_name
            __props__.__dict__["qualified_sql_name"] = None
            __props__.__dict__["size"] = None
            __props__.__dict__["subsources"] = None
        super(SourceWebhook, __self__).__init__(
            'materialize:index/sourceWebhook:SourceWebhook',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            body_format: Optional[pulumi.Input[str]] = None,
            check_expression: Optional[pulumi.Input[str]] = None,
            check_options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SourceWebhookCheckOptionArgs']]]]] = None,
            cluster_name: Optional[pulumi.Input[str]] = None,
            comment: Optional[pulumi.Input[str]] = None,
            database_name: Optional[pulumi.Input[str]] = None,
            include_header: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SourceWebhookIncludeHeaderArgs']]]]] = None,
            include_headers: Optional[pulumi.Input[pulumi.InputType['SourceWebhookIncludeHeadersArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            ownership_role: Optional[pulumi.Input[str]] = None,
            qualified_sql_name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            schema_name: Optional[pulumi.Input[str]] = None,
            size: Optional[pulumi.Input[str]] = None,
            subsources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SourceWebhookSubsourceArgs']]]]] = None) -> 'SourceWebhook':
        """
        Get an existing SourceWebhook resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] body_format: The body format of the webhook.
        :param pulumi.Input[str] check_expression: The check expression for the webhook.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SourceWebhookCheckOptionArgs']]]] check_options: The check options for the webhook.
        :param pulumi.Input[str] cluster_name: The cluster to maintain this source.
        :param pulumi.Input[str] comment: **Public Preview** Comment on an object in the database.
        :param pulumi.Input[str] database_name: The identifier for the source database. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SourceWebhookIncludeHeaderArgs']]]] include_header: Map a header value from a request into a column.
        :param pulumi.Input[pulumi.InputType['SourceWebhookIncludeHeadersArgs']] include_headers: Include headers in the webhook.
        :param pulumi.Input[str] name: The identifier for the source.
        :param pulumi.Input[str] ownership_role: The owernship role of the object.
        :param pulumi.Input[str] qualified_sql_name: The fully qualified name of the source.
        :param pulumi.Input[str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[str] schema_name: The identifier for the source schema. Defaults to `public`.
        :param pulumi.Input[str] size: The size of the cluster maintaining this source.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SourceWebhookSubsourceArgs']]]] subsources: Subsources of a source.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SourceWebhookState.__new__(_SourceWebhookState)

        __props__.__dict__["body_format"] = body_format
        __props__.__dict__["check_expression"] = check_expression
        __props__.__dict__["check_options"] = check_options
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["comment"] = comment
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["include_header"] = include_header
        __props__.__dict__["include_headers"] = include_headers
        __props__.__dict__["name"] = name
        __props__.__dict__["ownership_role"] = ownership_role
        __props__.__dict__["qualified_sql_name"] = qualified_sql_name
        __props__.__dict__["region"] = region
        __props__.__dict__["schema_name"] = schema_name
        __props__.__dict__["size"] = size
        __props__.__dict__["subsources"] = subsources
        return SourceWebhook(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bodyFormat")
    def body_format(self) -> pulumi.Output[str]:
        """
        The body format of the webhook.
        """
        return pulumi.get(self, "body_format")

    @property
    @pulumi.getter(name="checkExpression")
    def check_expression(self) -> pulumi.Output[Optional[str]]:
        """
        The check expression for the webhook.
        """
        return pulumi.get(self, "check_expression")

    @property
    @pulumi.getter(name="checkOptions")
    def check_options(self) -> pulumi.Output[Optional[Sequence['outputs.SourceWebhookCheckOption']]]:
        """
        The check options for the webhook.
        """
        return pulumi.get(self, "check_options")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[Optional[str]]:
        """
        The cluster to maintain this source.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[str]]:
        """
        **Public Preview** Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[Optional[str]]:
        """
        The identifier for the source database. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="includeHeader")
    def include_header(self) -> pulumi.Output[Optional[Sequence['outputs.SourceWebhookIncludeHeader']]]:
        """
        Map a header value from a request into a column.
        """
        return pulumi.get(self, "include_header")

    @property
    @pulumi.getter(name="includeHeaders")
    def include_headers(self) -> pulumi.Output[Optional['outputs.SourceWebhookIncludeHeaders']]:
        """
        Include headers in the webhook.
        """
        return pulumi.get(self, "include_headers")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The identifier for the source.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> pulumi.Output[str]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @property
    @pulumi.getter(name="qualifiedSqlName")
    def qualified_sql_name(self) -> pulumi.Output[str]:
        """
        The fully qualified name of the source.
        """
        return pulumi.get(self, "qualified_sql_name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> pulumi.Output[Optional[str]]:
        """
        The identifier for the source schema. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[str]:
        """
        The size of the cluster maintaining this source.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def subsources(self) -> pulumi.Output[Sequence['outputs.SourceWebhookSubsource']]:
        """
        Subsources of a source.
        """
        return pulumi.get(self, "subsources")

