# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['SSORoleGroupMappingArgs', 'SSORoleGroupMapping']

@pulumi.input_type
class SSORoleGroupMappingArgs:
    def __init__(__self__, *,
                 group: pulumi.Input[str],
                 roles: pulumi.Input[Sequence[pulumi.Input[str]]],
                 sso_config_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a SSORoleGroupMapping resource.
        :param pulumi.Input[str] group: The name of the SSO group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: List of role names associated with the group.
        :param pulumi.Input[str] sso_config_id: The ID of the associated SSO configuration.
        """
        pulumi.set(__self__, "group", group)
        pulumi.set(__self__, "roles", roles)
        pulumi.set(__self__, "sso_config_id", sso_config_id)

    @property
    @pulumi.getter
    def group(self) -> pulumi.Input[str]:
        """
        The name of the SSO group.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: pulumi.Input[str]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of role names associated with the group.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter(name="ssoConfigId")
    def sso_config_id(self) -> pulumi.Input[str]:
        """
        The ID of the associated SSO configuration.
        """
        return pulumi.get(self, "sso_config_id")

    @sso_config_id.setter
    def sso_config_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "sso_config_id", value)


@pulumi.input_type
class _SSORoleGroupMappingState:
    def __init__(__self__, *,
                 group: Optional[pulumi.Input[str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sso_config_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SSORoleGroupMapping resources.
        :param pulumi.Input[str] group: The name of the SSO group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: List of role names associated with the group.
        :param pulumi.Input[str] sso_config_id: The ID of the associated SSO configuration.
        """
        if group is not None:
            pulumi.set(__self__, "group", group)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if sso_config_id is not None:
            pulumi.set(__self__, "sso_config_id", sso_config_id)

    @property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the SSO group.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of role names associated with the group.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter(name="ssoConfigId")
    def sso_config_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the associated SSO configuration.
        """
        return pulumi.get(self, "sso_config_id")

    @sso_config_id.setter
    def sso_config_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sso_config_id", value)


class SSORoleGroupMapping(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group: Optional[pulumi.Input[str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sso_config_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The SSO group role mapping resource allows you to set the roles for an SSO group. This allows you to automatically assign additional roles according to your identity provider groups

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        example_sso_group_mapping = materialize.SSORoleGroupMapping("exampleSsoGroupMapping",
            group="admins",
            sso_config_id=materialize_sso_config["example_sso_config"]["id"],
            roles=["Admin"])
        ```

        ## Import

        The SSO Configuration ID and the Group Mapping ID can be found using the `materialize_sso_config` data source

        ```sh
         $ pulumi import materialize:index/sSORoleGroupMapping:SSORoleGroupMapping example <sso_config_id>:<sso_group_mapping_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] group: The name of the SSO group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: List of role names associated with the group.
        :param pulumi.Input[str] sso_config_id: The ID of the associated SSO configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SSORoleGroupMappingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The SSO group role mapping resource allows you to set the roles for an SSO group. This allows you to automatically assign additional roles according to your identity provider groups

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        example_sso_group_mapping = materialize.SSORoleGroupMapping("exampleSsoGroupMapping",
            group="admins",
            sso_config_id=materialize_sso_config["example_sso_config"]["id"],
            roles=["Admin"])
        ```

        ## Import

        The SSO Configuration ID and the Group Mapping ID can be found using the `materialize_sso_config` data source

        ```sh
         $ pulumi import materialize:index/sSORoleGroupMapping:SSORoleGroupMapping example <sso_config_id>:<sso_group_mapping_id>
        ```

        :param str resource_name: The name of the resource.
        :param SSORoleGroupMappingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SSORoleGroupMappingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group: Optional[pulumi.Input[str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sso_config_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SSORoleGroupMappingArgs.__new__(SSORoleGroupMappingArgs)

            if group is None and not opts.urn:
                raise TypeError("Missing required property 'group'")
            __props__.__dict__["group"] = group
            if roles is None and not opts.urn:
                raise TypeError("Missing required property 'roles'")
            __props__.__dict__["roles"] = roles
            if sso_config_id is None and not opts.urn:
                raise TypeError("Missing required property 'sso_config_id'")
            __props__.__dict__["sso_config_id"] = sso_config_id
        super(SSORoleGroupMapping, __self__).__init__(
            'materialize:index/sSORoleGroupMapping:SSORoleGroupMapping',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            group: Optional[pulumi.Input[str]] = None,
            roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            sso_config_id: Optional[pulumi.Input[str]] = None) -> 'SSORoleGroupMapping':
        """
        Get an existing SSORoleGroupMapping resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] group: The name of the SSO group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: List of role names associated with the group.
        :param pulumi.Input[str] sso_config_id: The ID of the associated SSO configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SSORoleGroupMappingState.__new__(_SSORoleGroupMappingState)

        __props__.__dict__["group"] = group
        __props__.__dict__["roles"] = roles
        __props__.__dict__["sso_config_id"] = sso_config_id
        return SSORoleGroupMapping(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def group(self) -> pulumi.Output[str]:
        """
        The name of the SSO group.
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Output[Sequence[str]]:
        """
        List of role names associated with the group.
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter(name="ssoConfigId")
    def sso_config_id(self) -> pulumi.Output[str]:
        """
        The ID of the associated SSO configuration.
        """
        return pulumi.get(self, "sso_config_id")

