# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TypeArgs', 'Type']

@pulumi.input_type
class TypeArgs:
    def __init__(__self__, *,
                 comment: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 list_properties: Optional[pulumi.Input['TypeListPropertiesArgs']] = None,
                 map_properties: Optional[pulumi.Input['TypeMapPropertiesArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ownership_role: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 row_properties: Optional[pulumi.Input[Sequence[pulumi.Input['TypeRowPropertyArgs']]]] = None,
                 schema_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Type resource.
        :param pulumi.Input[str] comment: **Public Preview** Comment on an object in the database.
        :param pulumi.Input[str] database_name: The identifier for the type database. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input['TypeListPropertiesArgs'] list_properties: List properties.
        :param pulumi.Input['TypeMapPropertiesArgs'] map_properties: Map properties.
        :param pulumi.Input[str] name: The identifier for the type.
        :param pulumi.Input[str] ownership_role: The owernship role of the object.
        :param pulumi.Input[str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[Sequence[pulumi.Input['TypeRowPropertyArgs']]] row_properties: Row properties.
        :param pulumi.Input[str] schema_name: The identifier for the type schema. Defaults to `public`.
        """
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if list_properties is not None:
            pulumi.set(__self__, "list_properties", list_properties)
        if map_properties is not None:
            pulumi.set(__self__, "map_properties", map_properties)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ownership_role is not None:
            pulumi.set(__self__, "ownership_role", ownership_role)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if row_properties is not None:
            pulumi.set(__self__, "row_properties", row_properties)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        **Public Preview** Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the type database. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="listProperties")
    def list_properties(self) -> Optional[pulumi.Input['TypeListPropertiesArgs']]:
        """
        List properties.
        """
        return pulumi.get(self, "list_properties")

    @list_properties.setter
    def list_properties(self, value: Optional[pulumi.Input['TypeListPropertiesArgs']]):
        pulumi.set(self, "list_properties", value)

    @property
    @pulumi.getter(name="mapProperties")
    def map_properties(self) -> Optional[pulumi.Input['TypeMapPropertiesArgs']]:
        """
        Map properties.
        """
        return pulumi.get(self, "map_properties")

    @map_properties.setter
    def map_properties(self, value: Optional[pulumi.Input['TypeMapPropertiesArgs']]):
        pulumi.set(self, "map_properties", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the type.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> Optional[pulumi.Input[str]]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @ownership_role.setter
    def ownership_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ownership_role", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="rowProperties")
    def row_properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TypeRowPropertyArgs']]]]:
        """
        Row properties.
        """
        return pulumi.get(self, "row_properties")

    @row_properties.setter
    def row_properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TypeRowPropertyArgs']]]]):
        pulumi.set(self, "row_properties", value)

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the type schema. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema_name", value)


@pulumi.input_type
class _TypeState:
    def __init__(__self__, *,
                 category: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 list_properties: Optional[pulumi.Input['TypeListPropertiesArgs']] = None,
                 map_properties: Optional[pulumi.Input['TypeMapPropertiesArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ownership_role: Optional[pulumi.Input[str]] = None,
                 qualified_sql_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 row_properties: Optional[pulumi.Input[Sequence[pulumi.Input['TypeRowPropertyArgs']]]] = None,
                 schema_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Type resources.
        :param pulumi.Input[str] category: Type category.
        :param pulumi.Input[str] comment: **Public Preview** Comment on an object in the database.
        :param pulumi.Input[str] database_name: The identifier for the type database. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input['TypeListPropertiesArgs'] list_properties: List properties.
        :param pulumi.Input['TypeMapPropertiesArgs'] map_properties: Map properties.
        :param pulumi.Input[str] name: The identifier for the type.
        :param pulumi.Input[str] ownership_role: The owernship role of the object.
        :param pulumi.Input[str] qualified_sql_name: The fully qualified name of the type.
        :param pulumi.Input[str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[Sequence[pulumi.Input['TypeRowPropertyArgs']]] row_properties: Row properties.
        :param pulumi.Input[str] schema_name: The identifier for the type schema. Defaults to `public`.
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if list_properties is not None:
            pulumi.set(__self__, "list_properties", list_properties)
        if map_properties is not None:
            pulumi.set(__self__, "map_properties", map_properties)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ownership_role is not None:
            pulumi.set(__self__, "ownership_role", ownership_role)
        if qualified_sql_name is not None:
            pulumi.set(__self__, "qualified_sql_name", qualified_sql_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if row_properties is not None:
            pulumi.set(__self__, "row_properties", row_properties)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[str]]:
        """
        Type category.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        **Public Preview** Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the type database. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="listProperties")
    def list_properties(self) -> Optional[pulumi.Input['TypeListPropertiesArgs']]:
        """
        List properties.
        """
        return pulumi.get(self, "list_properties")

    @list_properties.setter
    def list_properties(self, value: Optional[pulumi.Input['TypeListPropertiesArgs']]):
        pulumi.set(self, "list_properties", value)

    @property
    @pulumi.getter(name="mapProperties")
    def map_properties(self) -> Optional[pulumi.Input['TypeMapPropertiesArgs']]:
        """
        Map properties.
        """
        return pulumi.get(self, "map_properties")

    @map_properties.setter
    def map_properties(self, value: Optional[pulumi.Input['TypeMapPropertiesArgs']]):
        pulumi.set(self, "map_properties", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the type.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> Optional[pulumi.Input[str]]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @ownership_role.setter
    def ownership_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ownership_role", value)

    @property
    @pulumi.getter(name="qualifiedSqlName")
    def qualified_sql_name(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified name of the type.
        """
        return pulumi.get(self, "qualified_sql_name")

    @qualified_sql_name.setter
    def qualified_sql_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "qualified_sql_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="rowProperties")
    def row_properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TypeRowPropertyArgs']]]]:
        """
        Row properties.
        """
        return pulumi.get(self, "row_properties")

    @row_properties.setter
    def row_properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TypeRowPropertyArgs']]]]):
        pulumi.set(self, "row_properties", value)

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the type schema. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema_name", value)


class Type(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 list_properties: Optional[pulumi.Input[pulumi.InputType['TypeListPropertiesArgs']]] = None,
                 map_properties: Optional[pulumi.Input[pulumi.InputType['TypeMapPropertiesArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ownership_role: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 row_properties: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TypeRowPropertyArgs']]]]] = None,
                 schema_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A custom types, which let you create named versions of anonymous types.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        list_type = materialize.Type("listType",
            schema_name=materialize_schema["schema"]["name"],
            database_name=materialize_database["database"]["name"],
            list_properties=materialize.TypeListPropertiesArgs(
                element_type="int4",
            ))
        map_type = materialize.Type("mapType",
            schema_name=materialize_schema["schema"]["name"],
            database_name=materialize_database["database"]["name"],
            map_properties=materialize.TypeMapPropertiesArgs(
                key_type="text",
                value_type="int4",
            ))
        ```

        ## Import

        Types can be imported using the type id

        ```sh
         $ pulumi import materialize:index/type:Type example_type <region>:<type_id>
        ```

         Type id and information be found in the `mz_catalog.mz_types` table The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] comment: **Public Preview** Comment on an object in the database.
        :param pulumi.Input[str] database_name: The identifier for the type database. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[pulumi.InputType['TypeListPropertiesArgs']] list_properties: List properties.
        :param pulumi.Input[pulumi.InputType['TypeMapPropertiesArgs']] map_properties: Map properties.
        :param pulumi.Input[str] name: The identifier for the type.
        :param pulumi.Input[str] ownership_role: The owernship role of the object.
        :param pulumi.Input[str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TypeRowPropertyArgs']]]] row_properties: Row properties.
        :param pulumi.Input[str] schema_name: The identifier for the type schema. Defaults to `public`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[TypeArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A custom types, which let you create named versions of anonymous types.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        list_type = materialize.Type("listType",
            schema_name=materialize_schema["schema"]["name"],
            database_name=materialize_database["database"]["name"],
            list_properties=materialize.TypeListPropertiesArgs(
                element_type="int4",
            ))
        map_type = materialize.Type("mapType",
            schema_name=materialize_schema["schema"]["name"],
            database_name=materialize_database["database"]["name"],
            map_properties=materialize.TypeMapPropertiesArgs(
                key_type="text",
                value_type="int4",
            ))
        ```

        ## Import

        Types can be imported using the type id

        ```sh
         $ pulumi import materialize:index/type:Type example_type <region>:<type_id>
        ```

         Type id and information be found in the `mz_catalog.mz_types` table The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param TypeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TypeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 list_properties: Optional[pulumi.Input[pulumi.InputType['TypeListPropertiesArgs']]] = None,
                 map_properties: Optional[pulumi.Input[pulumi.InputType['TypeMapPropertiesArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ownership_role: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 row_properties: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TypeRowPropertyArgs']]]]] = None,
                 schema_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TypeArgs.__new__(TypeArgs)

            __props__.__dict__["comment"] = comment
            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["list_properties"] = list_properties
            __props__.__dict__["map_properties"] = map_properties
            __props__.__dict__["name"] = name
            __props__.__dict__["ownership_role"] = ownership_role
            __props__.__dict__["region"] = region
            __props__.__dict__["row_properties"] = row_properties
            __props__.__dict__["schema_name"] = schema_name
            __props__.__dict__["category"] = None
            __props__.__dict__["qualified_sql_name"] = None
        super(Type, __self__).__init__(
            'materialize:index/type:Type',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            category: Optional[pulumi.Input[str]] = None,
            comment: Optional[pulumi.Input[str]] = None,
            database_name: Optional[pulumi.Input[str]] = None,
            list_properties: Optional[pulumi.Input[pulumi.InputType['TypeListPropertiesArgs']]] = None,
            map_properties: Optional[pulumi.Input[pulumi.InputType['TypeMapPropertiesArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            ownership_role: Optional[pulumi.Input[str]] = None,
            qualified_sql_name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            row_properties: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TypeRowPropertyArgs']]]]] = None,
            schema_name: Optional[pulumi.Input[str]] = None) -> 'Type':
        """
        Get an existing Type resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] category: Type category.
        :param pulumi.Input[str] comment: **Public Preview** Comment on an object in the database.
        :param pulumi.Input[str] database_name: The identifier for the type database. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[pulumi.InputType['TypeListPropertiesArgs']] list_properties: List properties.
        :param pulumi.Input[pulumi.InputType['TypeMapPropertiesArgs']] map_properties: Map properties.
        :param pulumi.Input[str] name: The identifier for the type.
        :param pulumi.Input[str] ownership_role: The owernship role of the object.
        :param pulumi.Input[str] qualified_sql_name: The fully qualified name of the type.
        :param pulumi.Input[str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TypeRowPropertyArgs']]]] row_properties: Row properties.
        :param pulumi.Input[str] schema_name: The identifier for the type schema. Defaults to `public`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TypeState.__new__(_TypeState)

        __props__.__dict__["category"] = category
        __props__.__dict__["comment"] = comment
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["list_properties"] = list_properties
        __props__.__dict__["map_properties"] = map_properties
        __props__.__dict__["name"] = name
        __props__.__dict__["ownership_role"] = ownership_role
        __props__.__dict__["qualified_sql_name"] = qualified_sql_name
        __props__.__dict__["region"] = region
        __props__.__dict__["row_properties"] = row_properties
        __props__.__dict__["schema_name"] = schema_name
        return Type(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def category(self) -> pulumi.Output[str]:
        """
        Type category.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[str]]:
        """
        **Public Preview** Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[Optional[str]]:
        """
        The identifier for the type database. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="listProperties")
    def list_properties(self) -> pulumi.Output[Optional['outputs.TypeListProperties']]:
        """
        List properties.
        """
        return pulumi.get(self, "list_properties")

    @property
    @pulumi.getter(name="mapProperties")
    def map_properties(self) -> pulumi.Output[Optional['outputs.TypeMapProperties']]:
        """
        Map properties.
        """
        return pulumi.get(self, "map_properties")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The identifier for the type.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> pulumi.Output[str]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @property
    @pulumi.getter(name="qualifiedSqlName")
    def qualified_sql_name(self) -> pulumi.Output[str]:
        """
        The fully qualified name of the type.
        """
        return pulumi.get(self, "qualified_sql_name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="rowProperties")
    def row_properties(self) -> pulumi.Output[Optional[Sequence['outputs.TypeRowProperty']]]:
        """
        Row properties.
        """
        return pulumi.get(self, "row_properties")

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> pulumi.Output[Optional[str]]:
        """
        The identifier for the type schema. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

