# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 email: pulumi.Input[str],
                 roles: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[str] email: The email address of the user. This must be unique across all users in the organization.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: The roles to assign to the user. Allowed values are 'Member' and 'Admin'.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "roles", roles)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Input[str]:
        """
        The email address of the user. This must be unique across all users in the organization.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[str]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The roles to assign to the user. Allowed values are 'Member' and 'Admin'.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "roles", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 auth_provider: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 verified: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[str] auth_provider: The authentication provider for the user.
        :param pulumi.Input[str] email: The email address of the user. This must be unique across all users in the organization.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: The roles to assign to the user. Allowed values are 'Member' and 'Admin'.
        """
        if auth_provider is not None:
            pulumi.set(__self__, "auth_provider", auth_provider)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if verified is not None:
            pulumi.set(__self__, "verified", verified)

    @property
    @pulumi.getter(name="authProvider")
    def auth_provider(self) -> Optional[pulumi.Input[str]]:
        """
        The authentication provider for the user.
        """
        return pulumi.get(self, "auth_provider")

    @auth_provider.setter
    def auth_provider(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_provider", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        The email address of the user. This must be unique across all users in the organization.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The roles to assign to the user. Allowed values are 'Member' and 'Admin'.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter
    def verified(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "verified")

    @verified.setter
    def verified(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "verified", value)


class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        example_user = materialize.User("exampleUser",
            email="example-user@example.com",
            roles=[
                "Member",
                "Admin",
            ])
        ```

        ## Import

        Users can be imported using the user id

        ```sh
         $ pulumi import materialize:index/user:User example_user <user_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] email: The email address of the user. This must be unique across all users in the organization.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: The roles to assign to the user. Allowed values are 'Member' and 'Admin'.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        example_user = materialize.User("exampleUser",
            email="example-user@example.com",
            roles=[
                "Member",
                "Admin",
            ])
        ```

        ## Import

        Users can be imported using the user id

        ```sh
         $ pulumi import materialize:index/user:User example_user <user_id>
        ```

        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            if roles is None and not opts.urn:
                raise TypeError("Missing required property 'roles'")
            __props__.__dict__["roles"] = roles
            __props__.__dict__["auth_provider"] = None
            __props__.__dict__["metadata"] = None
            __props__.__dict__["verified"] = None
        super(User, __self__).__init__(
            'materialize:index/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auth_provider: Optional[pulumi.Input[str]] = None,
            email: Optional[pulumi.Input[str]] = None,
            metadata: Optional[pulumi.Input[str]] = None,
            roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            verified: Optional[pulumi.Input[bool]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auth_provider: The authentication provider for the user.
        :param pulumi.Input[str] email: The email address of the user. This must be unique across all users in the organization.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: The roles to assign to the user. Allowed values are 'Member' and 'Admin'.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["auth_provider"] = auth_provider
        __props__.__dict__["email"] = email
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["roles"] = roles
        __props__.__dict__["verified"] = verified
        return User(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authProvider")
    def auth_provider(self) -> pulumi.Output[str]:
        """
        The authentication provider for the user.
        """
        return pulumi.get(self, "auth_provider")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[str]:
        """
        The email address of the user. This must be unique across all users in the organization.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[str]:
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Output[Sequence[str]]:
        """
        The roles to assign to the user. Allowed values are 'Member' and 'Admin'.
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter
    def verified(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "verified")

