# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ConfigstoreEntriesArgs', 'ConfigstoreEntries']

@pulumi.input_type
class ConfigstoreEntriesArgs:
    def __init__(__self__, *,
                 entries: pulumi.Input[Mapping[str, Any]],
                 store_id: pulumi.Input[str],
                 manage_entries: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a ConfigstoreEntries resource.
        :param pulumi.Input[Mapping[str, Any]] entries: A map representing an entry in the Config Store, (key/value)
        :param pulumi.Input[str] store_id: An alphanumeric string identifying the Config Store.
        :param pulumi.Input[bool] manage_entries: Have Terraform manage the entries (default: false). If set to `true` Terraform will remove any entries that were added
               externally from the config seeded values.
        """
        ConfigstoreEntriesArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            entries=entries,
            store_id=store_id,
            manage_entries=manage_entries,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             entries: pulumi.Input[Mapping[str, Any]],
             store_id: pulumi.Input[str],
             manage_entries: Optional[pulumi.Input[bool]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("entries", entries)
        _setter("store_id", store_id)
        if manage_entries is not None:
            _setter("manage_entries", manage_entries)

    @property
    @pulumi.getter
    def entries(self) -> pulumi.Input[Mapping[str, Any]]:
        """
        A map representing an entry in the Config Store, (key/value)
        """
        return pulumi.get(self, "entries")

    @entries.setter
    def entries(self, value: pulumi.Input[Mapping[str, Any]]):
        pulumi.set(self, "entries", value)

    @property
    @pulumi.getter(name="storeId")
    def store_id(self) -> pulumi.Input[str]:
        """
        An alphanumeric string identifying the Config Store.
        """
        return pulumi.get(self, "store_id")

    @store_id.setter
    def store_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "store_id", value)

    @property
    @pulumi.getter(name="manageEntries")
    def manage_entries(self) -> Optional[pulumi.Input[bool]]:
        """
        Have Terraform manage the entries (default: false). If set to `true` Terraform will remove any entries that were added
        externally from the config seeded values.
        """
        return pulumi.get(self, "manage_entries")

    @manage_entries.setter
    def manage_entries(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "manage_entries", value)


@pulumi.input_type
class _ConfigstoreEntriesState:
    def __init__(__self__, *,
                 entries: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 manage_entries: Optional[pulumi.Input[bool]] = None,
                 store_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ConfigstoreEntries resources.
        :param pulumi.Input[Mapping[str, Any]] entries: A map representing an entry in the Config Store, (key/value)
        :param pulumi.Input[bool] manage_entries: Have Terraform manage the entries (default: false). If set to `true` Terraform will remove any entries that were added
               externally from the config seeded values.
        :param pulumi.Input[str] store_id: An alphanumeric string identifying the Config Store.
        """
        _ConfigstoreEntriesState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            entries=entries,
            manage_entries=manage_entries,
            store_id=store_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             entries: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             manage_entries: Optional[pulumi.Input[bool]] = None,
             store_id: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if entries is not None:
            _setter("entries", entries)
        if manage_entries is not None:
            _setter("manage_entries", manage_entries)
        if store_id is not None:
            _setter("store_id", store_id)

    @property
    @pulumi.getter
    def entries(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A map representing an entry in the Config Store, (key/value)
        """
        return pulumi.get(self, "entries")

    @entries.setter
    def entries(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "entries", value)

    @property
    @pulumi.getter(name="manageEntries")
    def manage_entries(self) -> Optional[pulumi.Input[bool]]:
        """
        Have Terraform manage the entries (default: false). If set to `true` Terraform will remove any entries that were added
        externally from the config seeded values.
        """
        return pulumi.get(self, "manage_entries")

    @manage_entries.setter
    def manage_entries(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "manage_entries", value)

    @property
    @pulumi.getter(name="storeId")
    def store_id(self) -> Optional[pulumi.Input[str]]:
        """
        An alphanumeric string identifying the Config Store.
        """
        return pulumi.get(self, "store_id")

    @store_id.setter
    def store_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "store_id", value)


class ConfigstoreEntries(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 entries: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 manage_entries: Optional[pulumi.Input[bool]] = None,
                 store_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Import

        Fastly Config Stores entries can be imported using the corresponding Config Store ID with the `/entries` suffix, e.g.

        ```sh
         $ pulumi import fastly:index/configstoreEntries:ConfigstoreEntries example xxxxxxxxxxxxxxxxxxxx/entries
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, Any]] entries: A map representing an entry in the Config Store, (key/value)
        :param pulumi.Input[bool] manage_entries: Have Terraform manage the entries (default: false). If set to `true` Terraform will remove any entries that were added
               externally from the config seeded values.
        :param pulumi.Input[str] store_id: An alphanumeric string identifying the Config Store.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConfigstoreEntriesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Fastly Config Stores entries can be imported using the corresponding Config Store ID with the `/entries` suffix, e.g.

        ```sh
         $ pulumi import fastly:index/configstoreEntries:ConfigstoreEntries example xxxxxxxxxxxxxxxxxxxx/entries
        ```

        :param str resource_name: The name of the resource.
        :param ConfigstoreEntriesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConfigstoreEntriesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            ConfigstoreEntriesArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 entries: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 manage_entries: Optional[pulumi.Input[bool]] = None,
                 store_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConfigstoreEntriesArgs.__new__(ConfigstoreEntriesArgs)

            if entries is None and not opts.urn:
                raise TypeError("Missing required property 'entries'")
            __props__.__dict__["entries"] = entries
            __props__.__dict__["manage_entries"] = manage_entries
            if store_id is None and not opts.urn:
                raise TypeError("Missing required property 'store_id'")
            __props__.__dict__["store_id"] = store_id
        super(ConfigstoreEntries, __self__).__init__(
            'fastly:index/configstoreEntries:ConfigstoreEntries',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            entries: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            manage_entries: Optional[pulumi.Input[bool]] = None,
            store_id: Optional[pulumi.Input[str]] = None) -> 'ConfigstoreEntries':
        """
        Get an existing ConfigstoreEntries resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, Any]] entries: A map representing an entry in the Config Store, (key/value)
        :param pulumi.Input[bool] manage_entries: Have Terraform manage the entries (default: false). If set to `true` Terraform will remove any entries that were added
               externally from the config seeded values.
        :param pulumi.Input[str] store_id: An alphanumeric string identifying the Config Store.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConfigstoreEntriesState.__new__(_ConfigstoreEntriesState)

        __props__.__dict__["entries"] = entries
        __props__.__dict__["manage_entries"] = manage_entries
        __props__.__dict__["store_id"] = store_id
        return ConfigstoreEntries(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def entries(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        A map representing an entry in the Config Store, (key/value)
        """
        return pulumi.get(self, "entries")

    @property
    @pulumi.getter(name="manageEntries")
    def manage_entries(self) -> pulumi.Output[Optional[bool]]:
        """
        Have Terraform manage the entries (default: false). If set to `true` Terraform will remove any entries that were added
        externally from the config seeded values.
        """
        return pulumi.get(self, "manage_entries")

    @property
    @pulumi.getter(name="storeId")
    def store_id(self) -> pulumi.Output[str]:
        """
        An alphanumeric string identifying the Config Store.
        """
        return pulumi.get(self, "store_id")

