# Generated by Django 4.2.8 on 2024-09-10 12:57

from django.db import migrations, models
import django.db.models.deletion
import modelcluster.fields
import wagtail.contrib.routable_page.models
import wagtail.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('wagtailcore', '0089_log_entry_data_json_null_to_object'),
    ]

    operations = [
        migrations.CreateModel(
            name='PlacesPage',
            fields=[
                ('page_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='wagtailcore.page')),
                ('sidebar_title', models.CharField(blank=True, help_text='Title of the sidebar', max_length=255, null=True)),
                ('no_place_message', wagtail.fields.RichTextField(blank=True, help_text='Message to display when no place is selected', null=True)),
                ('description', wagtail.fields.RichTextField(blank=True, help_text='Description of the places', null=True)),
            ],
            options={
                'verbose_name': 'Places Page',
                'verbose_name_plural': 'Places Pages',
            },
            bases=(wagtail.contrib.routable_page.models.RoutablePageMixin, 'wagtailcore.page'),
        ),
        migrations.CreateModel(
            name='Place',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('name', models.CharField(help_text="What's the name of this place? I.E. 'New York City', 'Amsterdam'", max_length=255)),
                ('slug', models.SlugField(help_text='Slug of the place', max_length=255)),
                ('place_id', models.CharField(blank=True, help_text='(Optional) Google Place ID', max_length=255, null=True)),
                ('address', models.CharField(blank=True, help_text='Full address of the place', max_length=255, null=True)),
                ('description', wagtail.fields.RichTextField(blank=True, help_text='Description of the place', null=True)),
                ('page', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='places', to='places.placespage')),
            ],
            options={
                'verbose_name': 'Place',
                'verbose_name_plural': 'Places',
                'ordering': ['sort_order'],
            },
        ),
    ]
