# This file was auto-generated by Fern from our API Definition.

import typing
import urllib.parse
from json.decoder import JSONDecodeError

import httpx
import pydantic

from ...core.api_error import ApiError
from ...core.jsonable_encoder import jsonable_encoder
from ...core.remove_none_from_headers import remove_none_from_headers
from ...environment import DoptApiEnvironment
from ...errors.bad_request_error import BadRequestError
from ...errors.internal_server_error import InternalServerError
from ...errors.unauthorized_error import UnauthorizedError
from ...types.bad_request_error_response_body import BadRequestErrorResponseBody
from ...types.identify_batch_request_body_item import IdentifyBatchRequestBodyItem
from ...types.identify_batch_response_body import IdentifyBatchResponseBody
from ...types.identify_user_request_body_groups_item import IdentifyUserRequestBodyGroupsItem
from ...types.internal_server_error_response_body import InternalServerErrorResponseBody
from ...types.unauthorized_error_response_body import UnauthorizedErrorResponseBody

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class UsersClient:
    def __init__(self, *, environment: DoptApiEnvironment = DoptApiEnvironment.DEFAULT, api_key: str):
        self._environment = environment
        self.api_key = api_key

    def identify_user(
        self,
        *,
        identifier: str,
        properties: typing.Dict[str, typing.Any],
        groups: typing.Optional[typing.List[IdentifyUserRequestBodyGroupsItem]] = OMIT,
    ) -> None:
        _request: typing.Dict[str, typing.Any] = {"identifier": identifier, "properties": properties}
        if groups is not OMIT:
            _request["groups"] = groups
        _response = httpx.request(
            "POST",
            urllib.parse.urljoin(f"{self._environment.value}/", "identify"),
            json=jsonable_encoder(_request),
            headers=remove_none_from_headers({"X-Api-Key": self.api_key}),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(BadRequestErrorResponseBody, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(
                pydantic.parse_obj_as(UnauthorizedErrorResponseBody, _response.json())  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic.parse_obj_as(InternalServerErrorResponseBody, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def identify_users(self, *, request: typing.List[IdentifyBatchRequestBodyItem]) -> IdentifyBatchResponseBody:
        _response = httpx.request(
            "POST",
            urllib.parse.urljoin(f"{self._environment.value}/", "identify/batch"),
            json=jsonable_encoder(request),
            headers=remove_none_from_headers({"X-Api-Key": self.api_key}),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(IdentifyBatchResponseBody, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(BadRequestErrorResponseBody, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(
                pydantic.parse_obj_as(UnauthorizedErrorResponseBody, _response.json())  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic.parse_obj_as(InternalServerErrorResponseBody, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncUsersClient:
    def __init__(self, *, environment: DoptApiEnvironment = DoptApiEnvironment.DEFAULT, api_key: str):
        self._environment = environment
        self.api_key = api_key

    async def identify_user(
        self,
        *,
        identifier: str,
        properties: typing.Dict[str, typing.Any],
        groups: typing.Optional[typing.List[IdentifyUserRequestBodyGroupsItem]] = OMIT,
    ) -> None:
        _request: typing.Dict[str, typing.Any] = {"identifier": identifier, "properties": properties}
        if groups is not OMIT:
            _request["groups"] = groups
        async with httpx.AsyncClient() as _client:
            _response = await _client.request(
                "POST",
                urllib.parse.urljoin(f"{self._environment.value}/", "identify"),
                json=jsonable_encoder(_request),
                headers=remove_none_from_headers({"X-Api-Key": self.api_key}),
                timeout=60,
            )
        if 200 <= _response.status_code < 300:
            return
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(BadRequestErrorResponseBody, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(
                pydantic.parse_obj_as(UnauthorizedErrorResponseBody, _response.json())  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic.parse_obj_as(InternalServerErrorResponseBody, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def identify_users(self, *, request: typing.List[IdentifyBatchRequestBodyItem]) -> IdentifyBatchResponseBody:
        async with httpx.AsyncClient() as _client:
            _response = await _client.request(
                "POST",
                urllib.parse.urljoin(f"{self._environment.value}/", "identify/batch"),
                json=jsonable_encoder(request),
                headers=remove_none_from_headers({"X-Api-Key": self.api_key}),
                timeout=60,
            )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(IdentifyBatchResponseBody, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(BadRequestErrorResponseBody, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(
                pydantic.parse_obj_as(UnauthorizedErrorResponseBody, _response.json())  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic.parse_obj_as(InternalServerErrorResponseBody, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
