/*
 * Decompiled with CFR 0.152.
 */
package org.astria;

import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.astria.DataManager;
import org.astria.Estimation;
import org.astria.Settings;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Euclidean3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.ode.ODEIntegrator;
import org.hipparchus.ode.ODEState;
import org.hipparchus.ode.OrdinaryDifferentialEquation;
import org.hipparchus.ode.nonstiff.DormandPrince853Integrator;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.LofOffset;
import org.orekit.forces.ForceModel;
import org.orekit.frames.Frame;
import org.orekit.frames.LOFType;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedPVCoordinates;

public final class ManualPropagation
implements PVCoordinatesProvider {
    private final Settings odCfg;
    private final int stateDim;
    private final Task[] tasks;
    private CountDownLatch taskSignal;
    private double propStart;
    private double propFinal;
    private final AbsoluteDate epoch;
    private final AttitudeProvider attProvider;
    private final LofOffset lofFrame;
    private AbsoluteDate savedTime;
    private TimeStampedPVCoordinates savedPos;
    private boolean enableDMC;
    private final int[] posParameters;

    public ManualPropagation(Settings odCfg) {
        int i;
        this.odCfg = odCfg;
        this.stateDim = odCfg.parameters.size() + 6;
        this.tasks = new Task[2 * this.stateDim];
        for (i = 0; i < this.tasks.length; ++i) {
            this.tasks[i] = new Task();
        }
        this.epoch = DataManager.parseDateTime(odCfg.propStart);
        this.attProvider = odCfg.getAttitudeProvider();
        this.lofFrame = new LofOffset(odCfg.propFrame, LOFType.VVLH);
        this.enableDMC = true;
        this.posParameters = new int[odCfg.forces.size() + 3];
        for (i = 0; i < odCfg.forces.size(); ++i) {
            this.posParameters[i] = -1;
            ForceModel fmod = odCfg.forces.get(i);
            double[] fpar = fmod.getParameters();
            for (int j = 0; j < odCfg.parameters.size(); ++j) {
                if (!fmod.isSupported(odCfg.parameters.get((int)j).name)) continue;
                this.posParameters[i] = j + 6;
            }
        }
        for (i = 0; i < odCfg.parameters.size(); ++i) {
            if (!odCfg.parameters.get((int)i).name.equalsIgnoreCase(Estimation.DMC_ACC_ESTM[0])) continue;
            this.posParameters[this.posParameters.length - 3] = i + 6;
            this.posParameters[this.posParameters.length - 2] = i + 7;
            this.posParameters[this.posParameters.length - 1] = i + 8;
            break;
        }
    }

    public Array2DRowRealMatrix propagate(double t0, Array2DRowRealMatrix inp, double t1, Array2DRowRealMatrix out, boolean enableDMC) {
        int i;
        this.propStart = t0;
        this.propFinal = t1;
        this.enableDMC = enableDMC;
        this.taskSignal = new CountDownLatch(inp.getColumnDimension());
        for (i = 0; i < inp.getColumnDimension(); ++i) {
            this.tasks[i].xStart = inp.getColumn(i);
            DataManager.threadPool.execute(this.tasks[i]);
        }
        try {
            if (!this.taskSignal.await(10L, TimeUnit.MINUTES)) {
                throw new RuntimeException("Propagation of UKF sigma points timed out");
            }
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
        for (i = 0; i < inp.getColumnDimension(); ++i) {
            if (this.tasks[i].xFinal == null) {
                throw new RuntimeException(this.tasks[i].exception);
            }
            out.setColumn(i, this.tasks[i].xFinal);
        }
        return out;
    }

    public Attitude getAttitude(AbsoluteDate time, double[] X) {
        this.savedTime = new AbsoluteDate(time, 0.0);
        this.savedPos = new TimeStampedPVCoordinates(time, new Vector3D(X[0], X[1], X[2]), new Vector3D(X[3], X[4], X[5]));
        if (this.attProvider != null) {
            return this.attProvider.getAttitude(this, time, this.odCfg.propFrame);
        }
        return this.lofFrame.getAttitude(this, time, this.odCfg.propFrame);
    }

    @Override
    public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate date, Frame frame) {
        return this.odCfg.propFrame.getTransformTo(frame, date).transformPVCoordinates(this.savedPos.shiftedBy(date.durationFrom(this.savedTime)));
    }

    private final class Task
    implements Runnable,
    OrdinaryDifferentialEquation {
        private final ODEIntegrator odeInt;
        public double[] xStart;
        public double[] xFinal;
        public Exception exception;

        public Task() {
            this.odeInt = new DormandPrince853Integrator(((ManualPropagation)ManualPropagation.this).odCfg.integMinTimeStep, ((ManualPropagation)ManualPropagation.this).odCfg.integMaxTimeStep, ((ManualPropagation)ManualPropagation.this).odCfg.integAbsTolerance, ((ManualPropagation)ManualPropagation.this).odCfg.integRelTolerance);
        }

        @Override
        public void run() {
            try {
                this.exception = null;
                this.xFinal = this.odeInt.integrate(this, new ODEState(ManualPropagation.this.propStart, this.xStart), ManualPropagation.this.propFinal).getPrimaryState();
            }
            catch (Exception exc) {
                this.xFinal = null;
                this.exception = exc;
            }
            finally {
                ManualPropagation.this.taskSignal.countDown();
            }
        }

        @Override
        public int getDimension() {
            return ManualPropagation.this.stateDim;
        }

        @Override
        public double[] computeDerivatives(double t, double[] X) {
            double[] xDot = new double[ManualPropagation.this.stateDim];
            Arrays.fill(xDot, 0.0);
            AbsoluteDate tm = new AbsoluteDate(ManualPropagation.this.epoch, t);
            SpacecraftState ss = new SpacecraftState((Orbit)new CartesianOrbit(new PVCoordinates(new Vector3D(X[0], X[1], X[2]), new Vector3D(X[3], X[4], X[5])), ((ManualPropagation)ManualPropagation.this).odCfg.propFrame, tm, 3.986004415E14), ManualPropagation.this.getAttitude(tm, Arrays.copyOfRange(X, 0, 6)), ((ManualPropagation)ManualPropagation.this).odCfg.rsoMass);
            Vector<Euclidean3D> acc = Vector3D.ZERO;
            for (int j = 0; j < ((ManualPropagation)ManualPropagation.this).odCfg.forces.size(); ++j) {
                ForceModel fmod = ((ManualPropagation)ManualPropagation.this).odCfg.forces.get(j);
                double[] fpar = fmod.getParameters();
                if (ManualPropagation.this.posParameters[j] != -1) {
                    fpar[0] = X[ManualPropagation.this.posParameters[j]];
                }
                acc = ((Vector3D)acc).add((Vector)fmod.acceleration(ss, fpar));
            }
            xDot[0] = X[3];
            xDot[1] = X[4];
            xDot[2] = X[5];
            xDot[3] = ((Vector3D)acc).getX();
            xDot[4] = ((Vector3D)acc).getY();
            xDot[5] = ((Vector3D)acc).getZ();
            if (ManualPropagation.this.enableDMC && ((ManualPropagation)ManualPropagation.this).odCfg.estmDMCCorrTime > 0.0 && ((ManualPropagation)ManualPropagation.this).odCfg.estmDMCSigmaPert > 0.0) {
                xDot[3] = xDot[3] + X[ManualPropagation.this.posParameters[ManualPropagation.this.posParameters.length - 3]];
                xDot[4] = xDot[4] + X[ManualPropagation.this.posParameters[ManualPropagation.this.posParameters.length - 2]];
                xDot[5] = xDot[5] + X[ManualPropagation.this.posParameters[ManualPropagation.this.posParameters.length - 1]];
                xDot[((ManualPropagation)ManualPropagation.this).posParameters[((ManualPropagation)ManualPropagation.this).posParameters.length - 3]] = -X[ManualPropagation.this.posParameters[ManualPropagation.this.posParameters.length - 3]] / ((ManualPropagation)ManualPropagation.this).odCfg.estmDMCCorrTime;
                xDot[((ManualPropagation)ManualPropagation.this).posParameters[((ManualPropagation)ManualPropagation.this).posParameters.length - 2]] = -X[ManualPropagation.this.posParameters[ManualPropagation.this.posParameters.length - 2]] / ((ManualPropagation)ManualPropagation.this).odCfg.estmDMCCorrTime;
                xDot[((ManualPropagation)ManualPropagation.this).posParameters[((ManualPropagation)ManualPropagation.this).posParameters.length - 1]] = -X[ManualPropagation.this.posParameters[ManualPropagation.this.posParameters.length - 1]] / ((ManualPropagation)ManualPropagation.this).odCfg.estmDMCCorrTime;
            }
            return xDot;
        }
    }
}

