/*
 * Decompiled with CFR 0.152.
 */
package org.astria;

import java.util.ArrayList;
import org.astria.DataManager;
import org.astria.Settings;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.ode.nonstiff.DormandPrince853Integrator;
import org.hipparchus.util.FastMath;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.forces.ForceModel;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.tle.TLE;
import org.orekit.propagation.analytical.tle.TLEPropagator;
import org.orekit.propagation.numerical.NumericalPropagator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public final class ParallelPropagation {
    private final ArrayList<Settings> configObjs;
    private final ArrayList<Propagator> propagators;

    public ParallelPropagation(ArrayList<Settings> configObjs) {
        this.configObjs = configObjs;
        this.propagators = new ArrayList(configObjs.size());
        for (int i = 0; i < configObjs.size(); ++i) {
            this.propagators.add(this.buildPropagator(configObjs.get(i)));
        }
    }

    public ArrayList<PropagationOutput> propagate() throws Exception {
        double dt;
        Settings obj0 = this.configObjs.get(0);
        String start = obj0.propStart;
        String end = obj0.propEnd;
        double step = obj0.propStep;
        for (Settings s : this.configObjs) {
            if (obj0.propStep > 0.0) {
                if (start.compareTo(s.propStart) > 0) {
                    start = s.propStart;
                }
                if (end.compareTo(s.propEnd) < 0) {
                    end = s.propEnd;
                }
                if (s.propStep == 0.0) continue;
                step = FastMath.min(step, s.propStep);
                continue;
            }
            if (start.compareTo(s.propStart) < 0) {
                start = s.propStart;
            }
            if (end.compareTo(s.propEnd) > 0) {
                end = s.propEnd;
            }
            if (s.propStep == 0.0) continue;
            step = FastMath.max(step, s.propStep);
        }
        AbsoluteDate tmFinal = DataManager.parseDateTime(start);
        AbsoluteDate tmStart = new AbsoluteDate(tmFinal, -0.1);
        AbsoluteDate prend = DataManager.parseDateTime(end);
        ArrayList<PropagationOutput> propOutput = new ArrayList<PropagationOutput>((int)FastMath.abs(prend.durationFrom(tmFinal) / step) + 2);
        do {
            AbsoluteDate t0 = tmStart;
            AbsoluteDate t1 = tmFinal;
            PropagationOutput pout = new PropagationOutput(tmFinal, this.propagators.size());
            propOutput.add(pout);
            for (int i = 0; i < this.propagators.size(); ++i) {
                Propagator prop = this.propagators.get(i);
                SpacecraftState state = DataManager.threadPool.submit(() -> prop.propagate(t0, t1)).get();
                tmStart = state.getDate();
                pout.addState(state.getPVCoordinates(DataManager.getFrame(this.configObjs.get((int)i).propInertialFrame)));
            }
            dt = prend.durationFrom(tmStart);
            if (step >= 0.0) {
                tmFinal = new AbsoluteDate(tmFinal, FastMath.min(dt, step));
                continue;
            }
            tmFinal = new AbsoluteDate(tmFinal, FastMath.max(dt, step));
            dt = -dt;
        } while (!(dt <= 0.0));
        return propOutput;
    }

    private Propagator buildPropagator(Settings cfg) {
        if (cfg.propInitialTLE != null && cfg.propInitialTLE[0] != null && cfg.propInitialTLE[1] != null) {
            TLE parser = new TLE(cfg.propInitialTLE[0], cfg.propInitialTLE[1]);
            if (cfg.propStart == null || cfg.propStart.length() == 0) {
                cfg.propStart = DataManager.getUTCString(parser.getDate());
            }
            if (cfg.propEnd == null || cfg.propEnd.length() == 0) {
                cfg.propEnd = cfg.propStart;
            }
            return TLEPropagator.selectExtrapolator(parser);
        }
        NumericalPropagator prop = new NumericalPropagator(new DormandPrince853Integrator(cfg.integMinTimeStep, cfg.integMaxTimeStep, cfg.integAbsTolerance, cfg.integRelTolerance));
        for (ForceModel fm : cfg.forces) {
            prop.addForceModel(fm);
        }
        AttitudeProvider attpro = cfg.getAttitudeProvider();
        if (attpro != null) {
            prop.setAttitudeProvider(attpro);
        }
        double[] Xi = cfg.getInitialState();
        AbsoluteDate tm = DataManager.parseDateTime(cfg.propStart);
        prop.setInitialState(new SpacecraftState((Orbit)new CartesianOrbit(new PVCoordinates(new Vector3D(Xi[0], Xi[1], Xi[2]), new Vector3D(Xi[3], Xi[4], Xi[5])), cfg.propFrame, tm, 3.986004415E14), cfg.rsoMass));
        return prop;
    }

    public static class PropagationOutput {
        public String time;
        public ArrayList<double[]> states;

        public PropagationOutput(AbsoluteDate time, int objCount) {
            this.time = DataManager.getUTCString(time);
            this.states = new ArrayList(objCount);
        }

        public void addState(TimeStampedPVCoordinates pva) {
            Vector3D p = pva.getPosition();
            Vector3D v = pva.getVelocity();
            this.states.add(new double[]{p.getX(), p.getY(), p.getZ(), v.getX(), v.getY(), v.getZ()});
        }
    }
}

