/*
 * Decompiled with CFR 0.152.
 */
package org.astria.rpc;

import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.nio.file.Paths;
import org.astria.DataManager;
import org.astria.rpc.ConversionService;
import org.astria.rpc.EstimationService;
import org.astria.rpc.PropagationService;
import org.astria.rpc.SimulationService;
import org.astria.rpc.UtilitiesService;

public final class RPCServer {
    private int port;
    private String dataPath;
    private Server server;

    private RPCServer(int port, String dataPath) {
        this.port = port;
        this.dataPath = dataPath;
    }

    private void start() throws Exception {
        Package pack = Package.getPackage("org.astria.rpc");
        if (pack != null && pack.getImplementationTitle() != null && pack.getImplementationVersion() != null) {
            System.out.println(String.format("%s version %s", pack.getImplementationTitle(), pack.getImplementationVersion()));
        }
        DataManager.initialize(this.dataPath);
        this.server = ((ServerBuilder)((ServerBuilder)((ServerBuilder)((ServerBuilder)((ServerBuilder)((ServerBuilder)ServerBuilder.forPort(this.port).maxInboundMessageSize(Integer.MAX_VALUE)).addService(new ConversionService())).addService(new EstimationService())).addService(new PropagationService())).addService(new SimulationService())).addService(new UtilitiesService())).build().start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.out.println("Shutting down server...");
                RPCServer.this.stop();
            }
        });
    }

    private void block() throws Exception {
        if (this.server != null) {
            this.server.awaitTermination();
        }
    }

    private void stop() {
        if (this.server != null) {
            this.server.shutdown();
        }
    }

    public static void main(String[] args) throws Exception {
        int port = 50051;
        String dataPath = Paths.get(".", new String[0]).toAbsolutePath().toString();
        if (args.length > 0) {
            port = Integer.parseInt(args[0]);
        }
        if (args.length > 1) {
            dataPath = args[1];
        }
        RPCServer server = new RPCServer(port, dataPath);
        server.start();
        server.block();
    }
}

