/*
 * Decompiled with CFR 0.152.
 */
package org.astria.rpc;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import org.astria.Measurements;
import org.astria.Settings;
import org.astria.Simulation;
import org.astria.rpc.Messages;
import org.astria.rpc.SimulationGrpc;
import org.astria.rpc.Tools;

public final class SimulationService
extends SimulationGrpc.SimulationImplBase {
    @Override
    public void simulateMeasurements(Messages.Settings req, StreamObserver<Messages.MeasurementArray> resp) {
        try {
            Settings simCfg = Tools.buildSettingsFromRequest(req);
            ArrayList<Measurements.SimulatedMeasurement> mlist = new Simulation(simCfg).simulateMeasurements();
            Messages.MeasurementArray.Builder builder = Messages.MeasurementArray.newBuilder().addAllArray(Tools.buildResponseFromMeasurements(mlist));
            resp.onNext(builder.build());
            resp.onCompleted();
        }
        catch (Throwable exc) {
            resp.onError(new StatusRuntimeException(Status.INTERNAL.withDescription(Tools.getStackTrace(exc))));
        }
    }
}

