/*
 * Decompiled with CFR 0.152.
 */
package org.astria.rpc;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import org.astria.Measurements;
import org.astria.Utilities;
import org.astria.rpc.Messages;
import org.astria.rpc.Tools;
import org.astria.rpc.UtilitiesGrpc;

public final class UtilitiesService
extends UtilitiesGrpc.UtilitiesImplBase {
    @Override
    public void importTDM(Messages.ImportTDMInput req, StreamObserver<Messages.Measurement2DArray> resp) {
        try {
            ArrayList<ArrayList<Measurements.SimulatedMeasurement>> mlist = Utilities.importTDM(req.getFileName(), req.getFileFormat());
            Messages.Measurement2DArray.Builder outer = Messages.Measurement2DArray.newBuilder();
            for (ArrayList<Measurements.SimulatedMeasurement> m : mlist) {
                Messages.MeasurementArray.Builder inner = Messages.MeasurementArray.newBuilder().addAllArray(Tools.buildResponseFromMeasurements(m));
                outer = outer.addArray(inner);
            }
            resp.onNext(outer.build());
            resp.onCompleted();
        }
        catch (Throwable exc) {
            resp.onError(new StatusRuntimeException(Status.INTERNAL.withDescription(Tools.getStackTrace(exc))));
        }
    }

    @Override
    public void interpolateEphemeris(Messages.InterpolateEphemerisInput req, StreamObserver<Messages.InterpolationOutputArray> resp) {
        try {
            ArrayList<Double[]> ephem = new ArrayList<Double[]>(req.getEphemCount());
            for (int i = 0; i < req.getTimeCount(); ++i) {
                ephem.add(req.getEphem(i).getArrayList().toArray(new Double[0]));
            }
            ArrayList<Utilities.InterpolationOutput> interp = Utilities.interpolateEphemeris(req.getSourceFrame(), req.getTimeList(), ephem, req.getNumPoints(), req.getDestFrame(), req.getInterpStart(), req.getInterpEnd(), req.getStepSize());
            Messages.InterpolationOutputArray.Builder outer = Messages.InterpolationOutputArray.newBuilder();
            for (Utilities.InterpolationOutput i : interp) {
                Messages.InterpolationOutput.Builder inner = Messages.InterpolationOutput.newBuilder().setTime(i.time);
                for (int j = 0; j < 6; ++j) {
                    inner = inner.addState(i.state[j]);
                }
                outer = outer.addArray(inner);
            }
            resp.onNext(outer.build());
            resp.onCompleted();
        }
        catch (Throwable exc) {
            resp.onError(new StatusRuntimeException(Status.INTERNAL.withDescription(Tools.getStackTrace(exc))));
        }
    }
}

