/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.differentiation;

import java.io.Serializable;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.differentiation.DSCompiler;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;

public class DSFactory
implements Serializable {
    private static final long serialVersionUID = 20161222L;
    private final transient DSCompiler compiler;
    private final transient Field<DerivativeStructure> derivativeField;

    public DSFactory(int parameters, int order) {
        this.compiler = DSCompiler.getCompiler(parameters, order);
        this.derivativeField = new DSField(this.constant(0.0), this.constant(1.0));
    }

    public Field<DerivativeStructure> getDerivativeField() {
        return this.derivativeField;
    }

    public DerivativeStructure constant(double value) {
        DerivativeStructure ds = new DerivativeStructure(this);
        ds.setDerivativeComponent(0, value);
        return ds;
    }

    public DerivativeStructure variable(int index, double value) throws MathIllegalArgumentException {
        if (index >= this.getCompiler().getFreeParameters()) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_LARGE_BOUND_EXCLUDED, index, this.getCompiler().getFreeParameters());
        }
        DerivativeStructure ds = new DerivativeStructure(this);
        ds.setDerivativeComponent(0, value);
        if (this.getCompiler().getOrder() > 0) {
            ds.setDerivativeComponent(DSCompiler.getCompiler(index, this.getCompiler().getOrder()).getSize(), 1.0);
        }
        return ds;
    }

    @SafeVarargs
    public final DerivativeStructure build(double ... derivatives) throws MathIllegalArgumentException {
        if (derivatives.length != this.compiler.getSize()) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, derivatives.length, this.compiler.getSize());
        }
        return new DerivativeStructure(this, derivatives);
    }

    DerivativeStructure build() {
        return new DerivativeStructure(this);
    }

    public DSCompiler getCompiler() {
        return this.compiler;
    }

    void checkCompatibility(DSFactory factory) throws MathIllegalArgumentException {
        this.compiler.checkCompatibility(factory.compiler);
    }

    private Object writeReplace() {
        return new DataTransferObject(this.compiler.getFreeParameters(), this.compiler.getOrder());
    }

    private static class DSField
    implements Field<DerivativeStructure> {
        private final DerivativeStructure zero;
        private final DerivativeStructure one;

        DSField(DerivativeStructure zero, DerivativeStructure one) {
            this.zero = zero;
            this.one = one;
        }

        @Override
        public DerivativeStructure getZero() {
            return this.zero;
        }

        @Override
        public DerivativeStructure getOne() {
            return this.one;
        }

        @Override
        public Class<? extends FieldElement<DerivativeStructure>> getRuntimeClass() {
            return DerivativeStructure.class;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof DSField) {
                DSFactory lhsFactory = this.zero.getFactory();
                DSFactory rhsFactory = ((DSField)other).zero.getFactory();
                return lhsFactory.compiler == rhsFactory.compiler;
            }
            return false;
        }

        public int hashCode() {
            DSCompiler compiler = this.zero.getFactory().getCompiler();
            return 0x9943B886 ^ compiler.getFreeParameters() << 16 & compiler.getOrder();
        }
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20161222L;
        private final int variables;
        private final int order;

        DataTransferObject(int variables, int order) {
            this.variables = variables;
            this.order = order;
        }

        private Object readResolve() {
            return new DSFactory(this.variables, this.order);
        }
    }
}

