/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.function;

import java.util.Arrays;
import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.util.MathArrays;

public class StepFunction
implements UnivariateFunction {
    private final double[] abscissa;
    private final double[] ordinate;

    public StepFunction(double[] x, double[] y) throws MathIllegalArgumentException, NullArgumentException {
        if (x == null || y == null) {
            throw new NullArgumentException();
        }
        if (x.length == 0 || y.length == 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NO_DATA, new Object[0]);
        }
        MathArrays.checkEqualLength(y, x);
        MathArrays.checkOrder(x);
        this.abscissa = (double[])x.clone();
        this.ordinate = (double[])y.clone();
    }

    @Override
    public double value(double x) {
        int index = Arrays.binarySearch(this.abscissa, x);
        double fx = 0.0;
        fx = index < -1 ? this.ordinate[-index - 2] : (index >= 0 ? this.ordinate[index] : this.ordinate[0]);
        return fx;
    }
}

