/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.interpolation;

import java.util.Arrays;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.BivariateFunction;
import org.hipparchus.analysis.FieldBivariateFunction;
import org.hipparchus.analysis.RealFieldUnivariateFunction;
import org.hipparchus.analysis.interpolation.AkimaSplineInterpolator;
import org.hipparchus.analysis.polynomials.FieldPolynomialSplineFunction;
import org.hipparchus.analysis.polynomials.PolynomialSplineFunction;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.util.MathArrays;

public class PiecewiseBicubicSplineInterpolatingFunction
implements BivariateFunction,
FieldBivariateFunction {
    private static final int MIN_NUM_POINTS = 5;
    private final double[] xval;
    private final double[] yval;
    private final double[][] fval;

    public PiecewiseBicubicSplineInterpolatingFunction(double[] x, double[] y, double[][] f) throws MathIllegalArgumentException, NullArgumentException {
        if (x == null || y == null || f == null || f[0] == null) {
            throw new NullArgumentException();
        }
        int xLen = x.length;
        int yLen = y.length;
        if (xLen == 0 || yLen == 0 || f.length == 0 || f[0].length == 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NO_DATA, new Object[0]);
        }
        if (xLen < 5 || yLen < 5 || f.length < 5 || f[0].length < 5) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.INSUFFICIENT_DATA, new Object[0]);
        }
        if (xLen != f.length) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, xLen, f.length);
        }
        if (yLen != f[0].length) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, yLen, f[0].length);
        }
        MathArrays.checkOrder(x);
        MathArrays.checkOrder(y);
        this.xval = (double[])x.clone();
        this.yval = (double[])y.clone();
        this.fval = (double[][])f.clone();
    }

    @Override
    public double value(double x, double y) throws MathIllegalArgumentException {
        AkimaSplineInterpolator interpolator = new AkimaSplineInterpolator();
        int offset = 2;
        int count = 5;
        int i = this.searchIndex(x, this.xval, 2, 5);
        int j = this.searchIndex(y, this.yval, 2, 5);
        double[] xArray = new double[5];
        double[] yArray = new double[5];
        double[] zArray = new double[5];
        double[] interpArray = new double[5];
        for (int index = 0; index < 5; ++index) {
            xArray[index] = this.xval[i + index];
            yArray[index] = this.yval[j + index];
        }
        for (int zIndex = 0; zIndex < 5; ++zIndex) {
            for (int index = 0; index < 5; ++index) {
                zArray[index] = this.fval[i + index][j + zIndex];
            }
            PolynomialSplineFunction spline = interpolator.interpolate(xArray, zArray);
            interpArray[zIndex] = spline.value(x);
        }
        PolynomialSplineFunction spline = interpolator.interpolate(yArray, interpArray);
        return spline.value(y);
    }

    @Override
    public <T extends RealFieldElement<T>> T value(T x, T y) throws MathIllegalArgumentException {
        AkimaSplineInterpolator interpolator = new AkimaSplineInterpolator();
        int offset = 2;
        int count = 5;
        int i = this.searchIndex(x.getReal(), this.xval, 2, 5);
        int j = this.searchIndex(y.getReal(), this.yval, 2, 5);
        double[] xArray = new double[5];
        RealFieldElement[] yArray = (RealFieldElement[])MathArrays.buildArray(x.getField(), 5);
        double[] zArray = new double[5];
        RealFieldElement[] interpArray = (RealFieldElement[])MathArrays.buildArray(x.getField(), 5);
        RealFieldElement zero = (RealFieldElement)x.getField().getZero();
        for (int index = 0; index < 5; ++index) {
            xArray[index] = this.xval[i + index];
            yArray[index] = (RealFieldElement)zero.add(this.yval[j + index]);
        }
        for (int zIndex = 0; zIndex < 5; ++zIndex) {
            for (int index = 0; index < 5; ++index) {
                zArray[index] = this.fval[i + index][j + zIndex];
            }
            PolynomialSplineFunction spline = interpolator.interpolate(xArray, zArray);
            interpArray[zIndex] = spline.value(x);
        }
        RealFieldUnivariateFunction spline = interpolator.interpolate(yArray, interpArray);
        return ((FieldPolynomialSplineFunction)spline).value(y);
    }

    public boolean isValidPoint(double x, double y) {
        return !(x < this.xval[0] || x > this.xval[this.xval.length - 1] || y < this.yval[0]) && !(y > this.yval[this.yval.length - 1]);
    }

    private int searchIndex(double c, double[] val, int offset, int count) {
        int r = Arrays.binarySearch(val, c);
        if (r == -1 || r == -val.length - 1) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.OUT_OF_RANGE_SIMPLE, c, val[0], val[val.length - 1]);
        }
        r = r < 0 ? -r - offset - 1 : (r -= offset);
        if (r < 0) {
            r = 0;
        }
        if (r + count >= val.length) {
            r = val.length - count;
        }
        return r;
    }
}

