/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.interpolation;

import java.lang.reflect.Array;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.interpolation.FieldUnivariateInterpolator;
import org.hipparchus.analysis.interpolation.UnivariateInterpolator;
import org.hipparchus.analysis.polynomials.FieldPolynomialFunction;
import org.hipparchus.analysis.polynomials.FieldPolynomialSplineFunction;
import org.hipparchus.analysis.polynomials.PolynomialFunction;
import org.hipparchus.analysis.polynomials.PolynomialSplineFunction;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public class SplineInterpolator
implements UnivariateInterpolator,
FieldUnivariateInterpolator {
    @Override
    public PolynomialSplineFunction interpolate(double[] x, double[] y) throws MathIllegalArgumentException {
        MathUtils.checkNotNull(x);
        MathUtils.checkNotNull(y);
        MathArrays.checkEqualLength(x, y);
        if (x.length < 3) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_OF_POINTS, x.length, 3, true);
        }
        int n = x.length - 1;
        MathArrays.checkOrder(x);
        double[] h = new double[n];
        for (int i = 0; i < n; ++i) {
            h[i] = x[i + 1] - x[i];
        }
        double[] mu = new double[n];
        double[] z = new double[n + 1];
        mu[0] = 0.0;
        z[0] = 0.0;
        double g = 0.0;
        for (int i = 1; i < n; ++i) {
            g = 2.0 * (x[i + 1] - x[i - 1]) - h[i - 1] * mu[i - 1];
            mu[i] = h[i] / g;
            z[i] = (3.0 * (y[i + 1] * h[i - 1] - y[i] * (x[i + 1] - x[i - 1]) + y[i - 1] * h[i]) / (h[i - 1] * h[i]) - h[i - 1] * z[i - 1]) / g;
        }
        double[] b = new double[n];
        double[] c = new double[n + 1];
        double[] d = new double[n];
        z[n] = 0.0;
        c[n] = 0.0;
        for (int j = n - 1; j >= 0; --j) {
            c[j] = z[j] - mu[j] * c[j + 1];
            b[j] = (y[j + 1] - y[j]) / h[j] - h[j] * (c[j + 1] + 2.0 * c[j]) / 3.0;
            d[j] = (c[j + 1] - c[j]) / (3.0 * h[j]);
        }
        PolynomialFunction[] polynomials = new PolynomialFunction[n];
        double[] coefficients = new double[4];
        for (int i = 0; i < n; ++i) {
            coefficients[0] = y[i];
            coefficients[1] = b[i];
            coefficients[2] = c[i];
            coefficients[3] = d[i];
            polynomials[i] = new PolynomialFunction(coefficients);
        }
        return new PolynomialSplineFunction(x, polynomials);
    }

    public <T extends RealFieldElement<T>> FieldPolynomialSplineFunction<T> interpolate(T[] x, T[] y) throws MathIllegalArgumentException {
        MathUtils.checkNotNull(x);
        MathUtils.checkNotNull(y);
        MathArrays.checkEqualLength(x, y);
        if (x.length < 3) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_OF_POINTS, x.length, 3, true);
        }
        int n = x.length - 1;
        MathArrays.checkOrder(x);
        Field field = x[0].getField();
        RealFieldElement[] h = (RealFieldElement[])MathArrays.buildArray(field, n);
        for (int i = 0; i < n; ++i) {
            h[i] = (RealFieldElement)x[i + 1].subtract(x[i]);
        }
        RealFieldElement[] mu = (RealFieldElement[])MathArrays.buildArray(field, n);
        RealFieldElement[] z = (RealFieldElement[])MathArrays.buildArray(field, n + 1);
        mu[0] = (RealFieldElement)field.getZero();
        z[0] = (RealFieldElement)field.getZero();
        for (int i = 1; i < n; ++i) {
            RealFieldElement g = ((RealFieldElement)((RealFieldElement)x[i + 1].subtract(x[i - 1])).multiply(2)).subtract(h[i - 1].multiply(mu[i - 1]));
            mu[i] = h[i].divide(g);
            z[i] = ((RealFieldElement)((RealFieldElement)y[i + 1].multiply((RealFieldElement)h[i - 1]).subtract(y[i].multiply(x[i + 1].subtract(x[i - 1])))).add(y[i - 1].multiply((RealFieldElement)h[i])).multiply(3)).divide(h[i - 1].multiply(h[i])).subtract(h[i - 1].multiply(z[i - 1])).divide(g);
        }
        RealFieldElement[] b = (RealFieldElement[])MathArrays.buildArray(field, n);
        RealFieldElement[] c = (RealFieldElement[])MathArrays.buildArray(field, n + 1);
        RealFieldElement[] d = (RealFieldElement[])MathArrays.buildArray(field, n);
        z[n] = (RealFieldElement)field.getZero();
        c[n] = (RealFieldElement)field.getZero();
        for (int j = n - 1; j >= 0; --j) {
            c[j] = z[j].subtract(mu[j].multiply(c[j + 1]));
            b[j] = (RealFieldElement)((RealFieldElement)y[j + 1].subtract(y[j])).divide(h[j]).subtract(h[j].multiply(c[j + 1].add(c[j]).add(c[j])).divide(3.0));
            d[j] = (RealFieldElement)c[j + 1].subtract(c[j]).divide(h[j].multiply(3));
        }
        FieldPolynomialFunction[] polynomials = (FieldPolynomialFunction[])Array.newInstance(FieldPolynomialFunction.class, n);
        RealFieldElement[] coefficients = (RealFieldElement[])MathArrays.buildArray(field, 4);
        for (int i = 0; i < n; ++i) {
            coefficients[0] = y[i];
            coefficients[1] = b[i];
            coefficients[2] = c[i];
            coefficients[3] = d[i];
            polynomials[i] = new FieldPolynomialFunction(coefficients);
        }
        return new FieldPolynomialSplineFunction(x, polynomials);
    }
}

