/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.distribution.continuous;

import java.io.Serializable;
import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.solvers.UnivariateSolverUtils;
import org.hipparchus.distribution.RealDistribution;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;

public abstract class AbstractRealDistribution
implements RealDistribution,
Serializable {
    protected static final double DEFAULT_SOLVER_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = 20160320L;
    private final double solverAbsoluteAccuracy;

    protected AbstractRealDistribution(double solverAbsoluteAccuracy) {
        this.solverAbsoluteAccuracy = solverAbsoluteAccuracy;
    }

    protected AbstractRealDistribution() {
        this.solverAbsoluteAccuracy = 1.0E-9;
    }

    @Override
    public double probability(double x0, double x1) throws MathIllegalArgumentException {
        if (x0 > x1) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.LOWER_ENDPOINT_ABOVE_UPPER_ENDPOINT, x0, x1, true);
        }
        return this.cumulativeProbability(x1) - this.cumulativeProbability(x0);
    }

    @Override
    public double inverseCumulativeProbability(final double p) throws MathIllegalArgumentException {
        double dx;
        boolean chebyshevApplies;
        MathUtils.checkRangeInclusive(p, 0.0, 1.0);
        double lowerBound = this.getSupportLowerBound();
        if (p == 0.0) {
            return lowerBound;
        }
        double upperBound = this.getSupportUpperBound();
        if (p == 1.0) {
            return upperBound;
        }
        double mu = this.getNumericalMean();
        double sig = FastMath.sqrt(this.getNumericalVariance());
        boolean bl = chebyshevApplies = !Double.isInfinite(mu) && !Double.isNaN(mu) && !Double.isInfinite(sig) && !Double.isNaN(sig);
        if (lowerBound == Double.NEGATIVE_INFINITY) {
            if (chebyshevApplies) {
                lowerBound = mu - sig * FastMath.sqrt((1.0 - p) / p);
            } else {
                lowerBound = -1.0;
                while (this.cumulativeProbability(lowerBound) >= p) {
                    lowerBound *= 2.0;
                }
            }
        }
        if (upperBound == Double.POSITIVE_INFINITY) {
            if (chebyshevApplies) {
                upperBound = mu + sig * FastMath.sqrt(p / (1.0 - p));
            } else {
                upperBound = 1.0;
                while (this.cumulativeProbability(upperBound) < p) {
                    upperBound *= 2.0;
                }
            }
        }
        UnivariateFunction toSolve = new UnivariateFunction(){

            @Override
            public double value(double x) {
                return AbstractRealDistribution.this.cumulativeProbability(x) - p;
            }
        };
        double x = UnivariateSolverUtils.solve(toSolve, lowerBound, upperBound, this.getSolverAbsoluteAccuracy());
        if (!this.isSupportConnected() && x - (dx = this.getSolverAbsoluteAccuracy()) >= this.getSupportLowerBound()) {
            double px = this.cumulativeProbability(x);
            if (this.cumulativeProbability(x - dx) == px) {
                upperBound = x;
                while (upperBound - lowerBound > dx) {
                    double midPoint = 0.5 * (lowerBound + upperBound);
                    if (this.cumulativeProbability(midPoint) < px) {
                        lowerBound = midPoint;
                        continue;
                    }
                    upperBound = midPoint;
                }
                return upperBound;
            }
        }
        return x;
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    @Override
    public double logDensity(double x) {
        return FastMath.log(this.density(x));
    }
}

