/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.fitting;

import java.util.Collection;
import org.hipparchus.analysis.MultivariateMatrixFunction;
import org.hipparchus.analysis.MultivariateVectorFunction;
import org.hipparchus.analysis.ParametricUnivariateFunction;
import org.hipparchus.fitting.WeightedObservedPoint;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LeastSquaresOptimizer;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LeastSquaresProblem;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LevenbergMarquardtOptimizer;

public abstract class AbstractCurveFitter {
    public double[] fit(Collection<WeightedObservedPoint> points) {
        return this.getOptimizer().optimize(this.getProblem(points)).getPoint().toArray();
    }

    protected LeastSquaresOptimizer getOptimizer() {
        return new LevenbergMarquardtOptimizer();
    }

    protected abstract LeastSquaresProblem getProblem(Collection<WeightedObservedPoint> var1);

    protected static class TheoreticalValuesFunction {
        private final ParametricUnivariateFunction f;
        private final double[] points;

        public TheoreticalValuesFunction(ParametricUnivariateFunction f, Collection<WeightedObservedPoint> observations) {
            this.f = f;
            int len = observations.size();
            this.points = new double[len];
            int i = 0;
            for (WeightedObservedPoint obs : observations) {
                this.points[i++] = obs.getX();
            }
        }

        public MultivariateVectorFunction getModelFunction() {
            return new MultivariateVectorFunction(){

                @Override
                public double[] value(double[] p) {
                    int len = points.length;
                    double[] values = new double[len];
                    for (int i = 0; i < len; ++i) {
                        values[i] = f.value(points[i], p);
                    }
                    return values;
                }
            };
        }

        public MultivariateMatrixFunction getModelFunctionJacobian() {
            return new MultivariateMatrixFunction(){

                @Override
                public double[][] value(double[] p) {
                    int len = points.length;
                    double[][] jacobian = new double[len][];
                    for (int i = 0; i < len; ++i) {
                        jacobian[i] = f.gradient(points[i], p);
                    }
                    return jacobian;
                }
            };
        }
    }
}

