/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.spherical.oned;

import java.io.Serializable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.geometry.LocalizedGeometryFormats;
import org.hipparchus.geometry.Space;
import org.hipparchus.util.FastMath;

public class Sphere1D
implements Serializable,
Space {
    public static final double SMALLEST_TOLERANCE = FastMath.ulp(Math.PI * 2);
    private static final long serialVersionUID = 20131218L;

    private Sphere1D() {
    }

    public static Sphere1D getInstance() {
        return LazyHolder.INSTANCE;
    }

    public static void checkTolerance(double tolerance) throws MathIllegalArgumentException {
        if (tolerance < SMALLEST_TOLERANCE) {
            throw new MathIllegalArgumentException(LocalizedGeometryFormats.TOO_SMALL_TOLERANCE, tolerance, "Sphere1D.SMALLEST_TOLERANCE", SMALLEST_TOLERANCE);
        }
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public Space getSubSpace() throws NoSubSpaceException {
        throw new NoSubSpaceException();
    }

    private Object readResolve() {
        return LazyHolder.INSTANCE;
    }

    public static class NoSubSpaceException
    extends MathRuntimeException {
        private static final long serialVersionUID = 20140225L;

        public NoSubSpaceException() {
            super(LocalizedGeometryFormats.NOT_SUPPORTED_IN_DIMENSION_N, 1);
        }
    }

    private static class LazyHolder {
        private static final Sphere1D INSTANCE = new Sphere1D();

        private LazyHolder() {
        }
    }
}

