/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.linear;

import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.linear.AnyMatrix;
import org.hipparchus.linear.FieldMatrixChangingVisitor;
import org.hipparchus.linear.FieldMatrixPreservingVisitor;
import org.hipparchus.linear.FieldVector;

public interface FieldMatrix<T extends FieldElement<T>>
extends AnyMatrix {
    public Field<T> getField();

    public FieldMatrix<T> createMatrix(int var1, int var2) throws MathIllegalArgumentException;

    public FieldMatrix<T> copy();

    public FieldMatrix<T> add(FieldMatrix<T> var1) throws MathIllegalArgumentException;

    public FieldMatrix<T> subtract(FieldMatrix<T> var1) throws MathIllegalArgumentException;

    public FieldMatrix<T> scalarAdd(T var1);

    public FieldMatrix<T> scalarMultiply(T var1);

    public FieldMatrix<T> multiply(FieldMatrix<T> var1) throws MathIllegalArgumentException;

    default public FieldMatrix<T> multiplyTransposed(FieldMatrix<T> m) throws MathIllegalArgumentException {
        return this.multiply(m.transpose());
    }

    default public FieldMatrix<T> transposeMultiply(FieldMatrix<T> m) throws MathIllegalArgumentException {
        return this.transpose().multiply(m);
    }

    public FieldMatrix<T> preMultiply(FieldMatrix<T> var1) throws MathIllegalArgumentException;

    public FieldMatrix<T> power(int var1) throws MathIllegalArgumentException;

    public T[][] getData();

    public FieldMatrix<T> getSubMatrix(int var1, int var2, int var3, int var4) throws MathIllegalArgumentException;

    public FieldMatrix<T> getSubMatrix(int[] var1, int[] var2) throws MathIllegalArgumentException, NullArgumentException;

    public void copySubMatrix(int var1, int var2, int var3, int var4, T[][] var5) throws MathIllegalArgumentException;

    public void copySubMatrix(int[] var1, int[] var2, T[][] var3) throws MathIllegalArgumentException, NullArgumentException;

    public void setSubMatrix(T[][] var1, int var2, int var3) throws MathIllegalArgumentException, NullArgumentException;

    public FieldMatrix<T> getRowMatrix(int var1) throws MathIllegalArgumentException;

    public void setRowMatrix(int var1, FieldMatrix<T> var2) throws MathIllegalArgumentException;

    public FieldMatrix<T> getColumnMatrix(int var1) throws MathIllegalArgumentException;

    public void setColumnMatrix(int var1, FieldMatrix<T> var2) throws MathIllegalArgumentException;

    public FieldVector<T> getRowVector(int var1) throws MathIllegalArgumentException;

    public void setRowVector(int var1, FieldVector<T> var2) throws MathIllegalArgumentException;

    public FieldVector<T> getColumnVector(int var1) throws MathIllegalArgumentException;

    public void setColumnVector(int var1, FieldVector<T> var2) throws MathIllegalArgumentException;

    public T[] getRow(int var1) throws MathIllegalArgumentException;

    public void setRow(int var1, T[] var2) throws MathIllegalArgumentException;

    public T[] getColumn(int var1) throws MathIllegalArgumentException;

    public void setColumn(int var1, T[] var2) throws MathIllegalArgumentException;

    public T getEntry(int var1, int var2) throws MathIllegalArgumentException;

    public void setEntry(int var1, int var2, T var3) throws MathIllegalArgumentException;

    public void addToEntry(int var1, int var2, T var3) throws MathIllegalArgumentException;

    public void multiplyEntry(int var1, int var2, T var3) throws MathIllegalArgumentException;

    public FieldMatrix<T> transpose();

    public T getTrace() throws MathIllegalArgumentException;

    public T[] operate(T[] var1) throws MathIllegalArgumentException;

    public FieldVector<T> operate(FieldVector<T> var1) throws MathIllegalArgumentException;

    public T[] preMultiply(T[] var1) throws MathIllegalArgumentException;

    public FieldVector<T> preMultiply(FieldVector<T> var1) throws MathIllegalArgumentException;

    public T walkInRowOrder(FieldMatrixChangingVisitor<T> var1);

    public T walkInRowOrder(FieldMatrixPreservingVisitor<T> var1);

    public T walkInRowOrder(FieldMatrixChangingVisitor<T> var1, int var2, int var3, int var4, int var5) throws MathIllegalArgumentException;

    public T walkInRowOrder(FieldMatrixPreservingVisitor<T> var1, int var2, int var3, int var4, int var5) throws MathIllegalArgumentException;

    public T walkInColumnOrder(FieldMatrixChangingVisitor<T> var1);

    public T walkInColumnOrder(FieldMatrixPreservingVisitor<T> var1);

    public T walkInColumnOrder(FieldMatrixChangingVisitor<T> var1, int var2, int var3, int var4, int var5) throws MathIllegalArgumentException;

    public T walkInColumnOrder(FieldMatrixPreservingVisitor<T> var1, int var2, int var3, int var4, int var5) throws MathIllegalArgumentException;

    public T walkInOptimizedOrder(FieldMatrixChangingVisitor<T> var1);

    public T walkInOptimizedOrder(FieldMatrixPreservingVisitor<T> var1);

    public T walkInOptimizedOrder(FieldMatrixChangingVisitor<T> var1, int var2, int var3, int var4, int var5) throws MathIllegalArgumentException;

    public T walkInOptimizedOrder(FieldMatrixPreservingVisitor<T> var1, int var2, int var3, int var4, int var5) throws MathIllegalArgumentException;
}

