/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.linear;

import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.linear.FieldMatrix;

public interface FieldVector<T extends FieldElement<T>> {
    public Field<T> getField();

    public FieldVector<T> copy();

    public FieldVector<T> add(FieldVector<T> var1) throws MathIllegalArgumentException;

    public FieldVector<T> subtract(FieldVector<T> var1) throws MathIllegalArgumentException;

    public FieldVector<T> mapAdd(T var1) throws NullArgumentException;

    public FieldVector<T> mapAddToSelf(T var1) throws NullArgumentException;

    public FieldVector<T> mapSubtract(T var1) throws NullArgumentException;

    public FieldVector<T> mapSubtractToSelf(T var1) throws NullArgumentException;

    public FieldVector<T> mapMultiply(T var1) throws NullArgumentException;

    public FieldVector<T> mapMultiplyToSelf(T var1) throws NullArgumentException;

    public FieldVector<T> mapDivide(T var1) throws NullArgumentException, MathRuntimeException;

    public FieldVector<T> mapDivideToSelf(T var1) throws NullArgumentException, MathRuntimeException;

    public FieldVector<T> mapInv() throws MathRuntimeException;

    public FieldVector<T> mapInvToSelf() throws MathRuntimeException;

    public FieldVector<T> ebeMultiply(FieldVector<T> var1) throws MathIllegalArgumentException;

    public FieldVector<T> ebeDivide(FieldVector<T> var1) throws MathIllegalArgumentException, MathRuntimeException;

    public T dotProduct(FieldVector<T> var1) throws MathIllegalArgumentException;

    public FieldVector<T> projection(FieldVector<T> var1) throws MathIllegalArgumentException, MathRuntimeException;

    public FieldMatrix<T> outerProduct(FieldVector<T> var1);

    public T getEntry(int var1) throws MathIllegalArgumentException;

    public void setEntry(int var1, T var2) throws MathIllegalArgumentException;

    public int getDimension();

    public FieldVector<T> append(FieldVector<T> var1);

    public FieldVector<T> append(T var1);

    public FieldVector<T> getSubVector(int var1, int var2) throws MathIllegalArgumentException;

    public void setSubVector(int var1, FieldVector<T> var2) throws MathIllegalArgumentException;

    public void set(T var1);

    public T[] toArray();
}

