/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode;

import java.lang.reflect.Array;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.ode.ExpandableODE;
import org.hipparchus.ode.LocalizedODEFormats;
import org.hipparchus.ode.ODEJacobiansProvider;
import org.hipparchus.ode.ODEState;
import org.hipparchus.ode.OrdinaryDifferentialEquation;
import org.hipparchus.ode.ParameterConfiguration;
import org.hipparchus.ode.ParameterJacobianWrapper;
import org.hipparchus.ode.ParametersController;
import org.hipparchus.ode.SecondaryODE;

public class VariationalEquation {
    private final ODEJacobiansProvider jode;
    private final ExpandableODE expandable;
    private final int index;
    private double[] matricesData;

    public VariationalEquation(ExpandableODE expandable, OrdinaryDifferentialEquation ode, double[] hY, ParametersController controller, ParameterConfiguration ... paramsAndSteps) throws MismatchedEquations {
        this(expandable, new ParameterJacobianWrapper(ode, hY, controller, paramsAndSteps));
    }

    public VariationalEquation(ExpandableODE expandable, ODEJacobiansProvider jode) throws MismatchedEquations {
        OrdinaryDifferentialEquation ode = jode instanceof ParameterJacobianWrapper ? ((ParameterJacobianWrapper)jode).getODE() : jode;
        if (expandable.getPrimary() != ode) {
            throw new MismatchedEquations();
        }
        this.jode = jode;
        this.expandable = expandable;
        this.index = expandable.addSecondaryEquations(new JacobiansSecondaryODE());
        this.matricesData = new double[(jode.getDimension() + jode.getParametersNames().size()) * jode.getDimension()];
        for (int i = 0; i < jode.getDimension(); ++i) {
            this.matricesData[i * (jode.getDimension() + 1)] = 1.0;
        }
    }

    public void setInitialMainStateJacobian(double[][] dYdY0) throws MathIllegalArgumentException {
        this.checkDimension(this.jode.getDimension(), dYdY0);
        this.checkDimension(this.jode.getDimension(), dYdY0[0]);
        int i = 0;
        for (double[] row : dYdY0) {
            System.arraycopy(row, 0, this.matricesData, i, this.jode.getDimension());
            i += this.jode.getDimension();
        }
    }

    public void setInitialParameterJacobian(String pName, double[] dYdP) throws MathIllegalArgumentException {
        this.checkDimension(this.jode.getDimension(), dYdP);
        int i = this.jode.getDimension() * this.jode.getDimension();
        for (String knownParameter : this.jode.getParametersNames()) {
            if (pName.equals(knownParameter)) {
                System.arraycopy(dYdP, 0, this.matricesData, i, this.jode.getDimension());
                return;
            }
            i += this.jode.getDimension();
        }
        throw new MathIllegalArgumentException(LocalizedODEFormats.UNKNOWN_PARAMETER, pName);
    }

    public ODEState setUpInitialState(ODEState initialState) {
        double[][] secondary = new double[this.expandable.getMapper().getNumberOfEquations() - 1][];
        for (int i = 0; i < initialState.getNumberOfSecondaryStates(); ++i) {
            if (i + 1 == this.index) continue;
            secondary[i] = initialState.getSecondaryState(i + 1);
        }
        secondary[this.index - 1] = this.matricesData;
        return new ODEState(initialState.getTime(), initialState.getPrimaryState(), secondary);
    }

    public double[][] extractMainSetJacobian(ODEState state) {
        double[] p = state.getSecondaryState(this.index);
        double[][] dYdY0 = new double[this.jode.getDimension()][this.jode.getDimension()];
        int j = 0;
        for (int i = 0; i < this.jode.getDimension(); ++i) {
            System.arraycopy(p, j, dYdY0[i], 0, this.jode.getDimension());
            j += this.jode.getDimension();
        }
        return dYdY0;
    }

    public double[] extractParameterJacobian(ODEState state, String pName) {
        double[] p = state.getSecondaryState(this.index);
        double[] dYdP = new double[this.jode.getDimension()];
        int i = this.jode.getDimension() * this.jode.getDimension();
        for (String knownParameter : this.jode.getParametersNames()) {
            if (pName.equals(knownParameter)) {
                System.arraycopy(p, i, dYdP, 0, this.jode.getDimension());
                break;
            }
            i += this.jode.getDimension();
        }
        return dYdP;
    }

    private void checkDimension(int expected, Object array) throws MathIllegalArgumentException {
        int arrayDimension;
        int n = arrayDimension = array == null ? 0 : Array.getLength(array);
        if (arrayDimension != expected) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, arrayDimension, expected);
        }
    }

    public static class MismatchedEquations
    extends MathIllegalArgumentException {
        private static final long serialVersionUID = 20120902L;

        public MismatchedEquations() {
            super(LocalizedODEFormats.UNMATCHED_ODE_IN_EXPANDED_SET, new Object[0]);
        }
    }

    private class JacobiansSecondaryODE
    implements SecondaryODE {
        private JacobiansSecondaryODE() {
        }

        @Override
        public int getDimension() {
            return VariationalEquation.this.jode.getDimension() * (VariationalEquation.this.jode.getDimension() + VariationalEquation.this.jode.getParametersNames().size());
        }

        @Override
        public double[] computeDerivatives(double t, double[] y, double[] yDot, double[] z) throws MathIllegalArgumentException, MathIllegalStateException {
            int zIndex;
            double[] zDot = new double[z.length];
            double[][] dFdY = VariationalEquation.this.jode.computeMainStateJacobian(t, y, yDot);
            for (int i = 0; i < VariationalEquation.this.jode.getDimension(); ++i) {
                double[] dFdYi = dFdY[i];
                for (int j = 0; j < VariationalEquation.this.jode.getDimension(); ++j) {
                    int startIndex;
                    double s = 0.0;
                    zIndex = startIndex = j;
                    for (int l = 0; l < VariationalEquation.this.jode.getDimension(); ++l) {
                        s += dFdYi[l] * z[zIndex];
                        zIndex += VariationalEquation.this.jode.getDimension();
                    }
                    zDot[startIndex + i * ((VariationalEquation)VariationalEquation.this).jode.getDimension()] = s;
                }
            }
            int startIndex = VariationalEquation.this.jode.getDimension() * VariationalEquation.this.jode.getDimension();
            for (String name : VariationalEquation.this.jode.getParametersNames()) {
                double[] dFdP = VariationalEquation.this.jode.computeParameterJacobian(t, y, yDot, name);
                for (int i = 0; i < VariationalEquation.this.jode.getDimension(); ++i) {
                    double[] dFdYi = dFdY[i];
                    zIndex = startIndex;
                    double s = dFdP[i];
                    for (int l = 0; l < VariationalEquation.this.jode.getDimension(); ++l) {
                        s += dFdYi[l] * z[zIndex];
                        ++zIndex;
                    }
                    zDot[startIndex + i] = s;
                }
                startIndex += VariationalEquation.this.jode.getDimension();
            }
            return zDot;
        }
    }
}

