/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.ode.FieldEquationsMapper;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.RungeKuttaFieldStateInterpolator;

class GillFieldStateInterpolator<T extends RealFieldElement<T>>
extends RungeKuttaFieldStateInterpolator<T> {
    private final T one_minus_inv_sqrt_2;
    private final T one_plus_inv_sqrt_2;

    GillFieldStateInterpolator(Field<T> field, boolean forward, T[][] yDotK, FieldODEStateAndDerivative<T> globalPreviousState, FieldODEStateAndDerivative<T> globalCurrentState, FieldODEStateAndDerivative<T> softPreviousState, FieldODEStateAndDerivative<T> softCurrentState, FieldEquationsMapper<T> mapper) {
        super(field, forward, yDotK, globalPreviousState, globalCurrentState, softPreviousState, softCurrentState, mapper);
        RealFieldElement sqrt = (RealFieldElement)((RealFieldElement)((RealFieldElement)field.getZero()).add(0.5)).sqrt();
        this.one_minus_inv_sqrt_2 = ((RealFieldElement)field.getOne()).subtract(sqrt);
        this.one_plus_inv_sqrt_2 = ((RealFieldElement)field.getOne()).add(sqrt);
    }

    @Override
    protected GillFieldStateInterpolator<T> create(Field<T> newField, boolean newForward, T[][] newYDotK, FieldODEStateAndDerivative<T> newGlobalPreviousState, FieldODEStateAndDerivative<T> newGlobalCurrentState, FieldODEStateAndDerivative<T> newSoftPreviousState, FieldODEStateAndDerivative<T> newSoftCurrentState, FieldEquationsMapper<T> newMapper) {
        return new GillFieldStateInterpolator(newField, newForward, newYDotK, newGlobalPreviousState, newGlobalCurrentState, newSoftPreviousState, newSoftCurrentState, newMapper);
    }

    @Override
    protected FieldODEStateAndDerivative<T> computeInterpolatedStateAndDerivatives(FieldEquationsMapper<T> mapper, T time, T theta, T thetaH, T oneMinusThetaH) {
        RealFieldElement[] interpolatedDerivatives;
        RealFieldElement[] interpolatedState;
        RealFieldElement one = (RealFieldElement)time.getField().getOne();
        RealFieldElement twoTheta = (RealFieldElement)theta.multiply((int)2);
        RealFieldElement fourTheta2 = twoTheta.multiply(twoTheta);
        RealFieldElement coeffDot1 = (RealFieldElement)((RealFieldElement)theta.multiply(twoTheta.subtract(3.0))).add(1.0);
        RealFieldElement cDot23 = (RealFieldElement)twoTheta.multiply(one.subtract(theta));
        RealFieldElement coeffDot2 = (RealFieldElement)cDot23.multiply(this.one_minus_inv_sqrt_2);
        RealFieldElement coeffDot3 = (RealFieldElement)cDot23.multiply(this.one_plus_inv_sqrt_2);
        RealFieldElement coeffDot4 = (RealFieldElement)theta.multiply(twoTheta.subtract(1.0));
        if (this.getGlobalPreviousState() != null && theta.getReal() <= 0.5) {
            RealFieldElement s = (RealFieldElement)thetaH.divide(6.0);
            RealFieldElement c23 = s.multiply(((RealFieldElement)theta.multiply((int)6)).subtract(fourTheta2));
            RealFieldElement coeff1 = (RealFieldElement)s.multiply(((RealFieldElement)fourTheta2.subtract(theta.multiply((int)9))).add(6.0));
            RealFieldElement coeff2 = (RealFieldElement)c23.multiply(this.one_minus_inv_sqrt_2);
            RealFieldElement coeff3 = (RealFieldElement)c23.multiply(this.one_plus_inv_sqrt_2);
            RealFieldElement coeff4 = (RealFieldElement)s.multiply(fourTheta2.subtract(theta.multiply((int)3)));
            interpolatedState = this.previousStateLinearCombination(new RealFieldElement[]{coeff1, coeff2, coeff3, coeff4});
            interpolatedDerivatives = this.derivativeLinearCombination(new RealFieldElement[]{coeffDot1, coeffDot2, coeffDot3, coeffDot4});
        } else {
            RealFieldElement s = (RealFieldElement)oneMinusThetaH.divide(-6.0);
            RealFieldElement c23 = s.multiply(((RealFieldElement)twoTheta.add(2.0)).subtract(fourTheta2));
            RealFieldElement coeff1 = (RealFieldElement)s.multiply(((RealFieldElement)fourTheta2.subtract(theta.multiply((int)5))).add(1.0));
            RealFieldElement coeff2 = (RealFieldElement)c23.multiply(this.one_minus_inv_sqrt_2);
            RealFieldElement coeff3 = (RealFieldElement)c23.multiply(this.one_plus_inv_sqrt_2);
            RealFieldElement coeff4 = (RealFieldElement)s.multiply(((RealFieldElement)fourTheta2.add(theta)).add(1.0));
            interpolatedState = this.currentStateLinearCombination(new RealFieldElement[]{coeff1, coeff2, coeff3, coeff4});
            interpolatedDerivatives = this.derivativeLinearCombination(new RealFieldElement[]{coeffDot1, coeffDot2, coeffDot3, coeffDot4});
        }
        return mapper.mapStateAndDerivative((RealFieldElement)time, interpolatedState, interpolatedDerivatives);
    }
}

