/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.ode.EquationsMapper;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.sampling.AbstractODEStateInterpolator;
import org.hipparchus.util.FastMath;

class GraggBulirschStoerStateInterpolator
extends AbstractODEStateInterpolator {
    private static final long serialVersionUID = 20160329L;
    private final double[][] yMidDots;
    private final double[][] polynomials;
    private final double[] errfac;
    private final int currentDegree;

    GraggBulirschStoerStateInterpolator(boolean forward, ODEStateAndDerivative globalPreviousState, ODEStateAndDerivative globalCurrentState, ODEStateAndDerivative softPreviousState, ODEStateAndDerivative softCurrentState, EquationsMapper mapper, double[][] yMidDots, int mu) {
        super(forward, globalPreviousState, globalCurrentState, softPreviousState, softCurrentState, mapper);
        this.yMidDots = (double[][])yMidDots.clone();
        this.currentDegree = mu + 4;
        this.polynomials = new double[this.currentDegree + 1][this.getCurrentState().getCompleteStateDimension()];
        if (this.currentDegree <= 4) {
            this.errfac = null;
        } else {
            this.errfac = new double[this.currentDegree - 4];
            for (int i = 0; i < this.errfac.length; ++i) {
                int ip5 = i + 5;
                this.errfac[i] = 1.0 / (double)(ip5 * ip5);
                double e = 0.5 * FastMath.sqrt((double)(i + 1) / (double)ip5);
                for (int j = 0; j <= i; ++j) {
                    int n = i;
                    this.errfac[n] = this.errfac[n] * (e / (double)(j + 1));
                }
            }
        }
        this.computeCoefficients(mu);
    }

    @Override
    protected GraggBulirschStoerStateInterpolator create(boolean newForward, ODEStateAndDerivative newGlobalPreviousState, ODEStateAndDerivative newGlobalCurrentState, ODEStateAndDerivative newSoftPreviousState, ODEStateAndDerivative newSoftCurrentState, EquationsMapper newMapper) {
        return new GraggBulirschStoerStateInterpolator(newForward, newGlobalPreviousState, newGlobalCurrentState, newSoftPreviousState, newSoftCurrentState, newMapper, this.yMidDots, this.currentDegree - 4);
    }

    private void computeCoefficients(int mu) {
        double[] y0Dot = this.getGlobalPreviousState().getCompleteDerivative();
        double[] y1Dot = this.getGlobalCurrentState().getCompleteDerivative();
        double[] y1 = this.getGlobalCurrentState().getCompleteState();
        double[] previousState = this.getGlobalPreviousState().getCompleteState();
        double h = this.getGlobalCurrentState().getTime() - this.getGlobalPreviousState().getTime();
        for (int i = 0; i < previousState.length; ++i) {
            double yp0 = h * y0Dot[i];
            double yp1 = h * y1Dot[i];
            double ydiff = y1[i] - previousState[i];
            double aspl = ydiff - yp1;
            double bspl = yp0 - ydiff;
            this.polynomials[0][i] = previousState[i];
            this.polynomials[1][i] = ydiff;
            this.polynomials[2][i] = aspl;
            this.polynomials[3][i] = bspl;
            if (mu < 0) {
                return;
            }
            double ph0 = 0.5 * (previousState[i] + y1[i]) + 0.125 * (aspl + bspl);
            this.polynomials[4][i] = 16.0 * (this.yMidDots[0][i] - ph0);
            if (mu <= 0) continue;
            double ph1 = ydiff + 0.25 * (aspl - bspl);
            this.polynomials[5][i] = 16.0 * (this.yMidDots[1][i] - ph1);
            if (mu <= 1) continue;
            double ph2 = yp1 - yp0;
            this.polynomials[6][i] = 16.0 * (this.yMidDots[2][i] - ph2 + this.polynomials[4][i]);
            if (mu <= 2) continue;
            double ph3 = 6.0 * (bspl - aspl);
            this.polynomials[7][i] = 16.0 * (this.yMidDots[3][i] - ph3 + 3.0 * this.polynomials[5][i]);
            for (int j = 4; j <= mu; ++j) {
                double fac1 = 0.5 * (double)j * (double)(j - 1);
                double fac2 = 2.0 * fac1 * (double)(j - 2) * (double)(j - 3);
                this.polynomials[j + 4][i] = 16.0 * (this.yMidDots[j][i] + fac1 * this.polynomials[j + 2][i] - fac2 * this.polynomials[j][i]);
            }
        }
    }

    public double estimateError(double[] scale) {
        double error = 0.0;
        if (this.currentDegree >= 5) {
            for (int i = 0; i < scale.length; ++i) {
                double e = this.polynomials[this.currentDegree][i] / scale[i];
                error += e * e;
            }
            error = FastMath.sqrt(error / (double)scale.length) * this.errfac[this.currentDegree - 5];
        }
        return error;
    }

    @Override
    protected ODEStateAndDerivative computeInterpolatedStateAndDerivatives(EquationsMapper mapper, double time, double theta, double thetaH, double oneMinusThetaH) {
        int dimension = mapper.getTotalDimension();
        double h = thetaH / theta;
        double oneMinusTheta = 1.0 - theta;
        double theta05 = theta - 0.5;
        double tOmT = theta * oneMinusTheta;
        double t4 = tOmT * tOmT;
        double t4Dot = 2.0 * tOmT * (1.0 - 2.0 * theta);
        double dot1 = 1.0 / h;
        double dot2 = theta * (2.0 - 3.0 * theta) / h;
        double dot3 = ((3.0 * theta - 4.0) * theta + 1.0) / h;
        double[] interpolatedState = new double[dimension];
        double[] interpolatedDerivatives = new double[dimension];
        for (int i = 0; i < dimension; ++i) {
            double p0 = this.polynomials[0][i];
            double p1 = this.polynomials[1][i];
            double p2 = this.polynomials[2][i];
            double p3 = this.polynomials[3][i];
            interpolatedState[i] = p0 + theta * (p1 + oneMinusTheta * (p2 * theta + p3 * oneMinusTheta));
            interpolatedDerivatives[i] = dot1 * p1 + dot2 * p2 + dot3 * p3;
            if (this.currentDegree <= 3) continue;
            double cDot = 0.0;
            double c = this.polynomials[this.currentDegree][i];
            for (int j = this.currentDegree - 1; j > 3; --j) {
                double d = 1.0 / (double)(j - 3);
                cDot = d * (theta05 * cDot + c);
                c = this.polynomials[j][i] + c * d * theta05;
            }
            int n = i;
            interpolatedState[n] = interpolatedState[n] + t4 * c;
            int n2 = i;
            interpolatedDerivatives[n2] = interpolatedDerivatives[n2] + (t4 * cDot + t4Dot * c) / h;
        }
        if (h == 0.0) {
            System.arraycopy(this.yMidDots[1], 0, interpolatedDerivatives, 0, dimension);
        }
        return mapper.mapStateAndDerivative(time, interpolatedState, interpolatedDerivatives);
    }
}

