/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.optim;

import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.optim.AbstractConvergenceChecker;
import org.hipparchus.optim.PointVectorValuePair;
import org.hipparchus.util.FastMath;

public class SimpleVectorValueChecker
extends AbstractConvergenceChecker<PointVectorValuePair> {
    private static final int ITERATION_CHECK_DISABLED = -1;
    private final int maxIterationCount;

    public SimpleVectorValueChecker(double relativeThreshold, double absoluteThreshold) {
        super(relativeThreshold, absoluteThreshold);
        this.maxIterationCount = -1;
    }

    public SimpleVectorValueChecker(double relativeThreshold, double absoluteThreshold, int maxIter) {
        super(relativeThreshold, absoluteThreshold);
        if (maxIter <= 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_SMALL_BOUND_EXCLUDED, maxIter, 0);
        }
        this.maxIterationCount = maxIter;
    }

    @Override
    public boolean converged(int iteration, PointVectorValuePair previous, PointVectorValuePair current) {
        if (this.maxIterationCount != -1 && iteration >= this.maxIterationCount) {
            return true;
        }
        double[] p = previous.getValueRef();
        double[] c = current.getValueRef();
        for (int i = 0; i < p.length; ++i) {
            double size;
            double pi = p[i];
            double ci = c[i];
            double difference = FastMath.abs(pi - ci);
            if (!(difference > (size = FastMath.max(FastMath.abs(pi), FastMath.abs(ci))) * this.getRelativeThreshold()) || !(difference > this.getAbsoluteThreshold())) continue;
            return false;
        }
        return true;
    }
}

