/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.random;

import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.random.RandomGenerator;
import org.hipparchus.util.FastMath;

abstract class BaseRandomGenerator
implements RandomGenerator {
    private double nextGaussian = Double.NaN;

    BaseRandomGenerator() {
    }

    @Override
    public void setSeed(int seed) {
        this.setSeed(new int[]{seed});
    }

    @Override
    public void setSeed(long seed) {
        this.setSeed(new int[]{(int)(seed >>> 32), (int)(seed & 0xFFFFFFFFL)});
    }

    @Override
    public int nextInt(int n) throws IllegalArgumentException {
        int val;
        int bits;
        if (n <= 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_SMALL_BOUND_EXCLUDED, n, 0);
        }
        if ((n & -n) == n) {
            return (int)((long)n * (long)(this.nextInt() >>> 1) >> 31);
        }
        while ((bits = this.nextInt() >>> 1) - (val = bits % n) + (n - 1) < 0) {
        }
        return val;
    }

    @Override
    public long nextLong(long n) {
        long val;
        long bits;
        if (n <= 0L) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_SMALL_BOUND_EXCLUDED, n, 0);
        }
        while ((bits = this.nextLong() >>> 1) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }

    @Override
    public double nextGaussian() {
        double random;
        if (Double.isNaN(this.nextGaussian)) {
            double x = this.nextDouble();
            double y = this.nextDouble();
            double alpha = Math.PI * 2 * x;
            double r = FastMath.sqrt(-2.0 * FastMath.log(y));
            random = r * FastMath.cos(alpha);
            this.nextGaussian = r * FastMath.sin(alpha);
        } else {
            random = this.nextGaussian;
            this.nextGaussian = Double.NaN;
        }
        return random;
    }

    protected void clearCache() {
        this.nextGaussian = Double.NaN;
    }

    public String toString() {
        return this.getClass().getName();
    }
}

