/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive;

import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.stat.descriptive.UnivariateStatistic;
import org.hipparchus.util.MathUtils;

public abstract class AbstractUnivariateStatistic
implements UnivariateStatistic {
    private double[] storedData;

    protected AbstractUnivariateStatistic() {
    }

    protected AbstractUnivariateStatistic(AbstractUnivariateStatistic original) {
        MathUtils.checkNotNull(original);
        this.storedData = original.storedData != null ? (double[])original.storedData.clone() : null;
    }

    @Override
    public abstract double evaluate(double[] var1, int var2, int var3) throws MathIllegalArgumentException;

    @Override
    public abstract UnivariateStatistic copy();

    public void setData(double[] values) {
        this.storedData = values == null ? null : (double[])values.clone();
    }

    public double[] getData() {
        return this.storedData == null ? null : (double[])this.storedData.clone();
    }

    protected double[] getDataRef() {
        return this.storedData;
    }

    public void setData(double[] values, int begin, int length) throws MathIllegalArgumentException {
        MathUtils.checkNotNull(values, LocalizedCoreFormats.INPUT_ARRAY, new Object[0]);
        if (begin < 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.START_POSITION, begin);
        }
        if (length < 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.LENGTH, length);
        }
        if (begin + length > values.length) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.SUBARRAY_ENDS_AFTER_ARRAY_END, begin + length, values.length, true);
        }
        this.storedData = new double[length];
        System.arraycopy(values, begin, this.storedData, 0, length);
    }

    public double evaluate() throws MathIllegalArgumentException {
        return this.evaluate(this.storedData);
    }
}

