/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive;

import java.io.Serializable;
import java.util.function.DoubleConsumer;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.stat.descriptive.AggregatableStatistic;
import org.hipparchus.stat.descriptive.StatisticalSummary;
import org.hipparchus.stat.descriptive.StatisticalSummaryValues;
import org.hipparchus.stat.descriptive.moment.GeometricMean;
import org.hipparchus.stat.descriptive.moment.Mean;
import org.hipparchus.stat.descriptive.moment.SecondMoment;
import org.hipparchus.stat.descriptive.moment.Variance;
import org.hipparchus.stat.descriptive.rank.Max;
import org.hipparchus.stat.descriptive.rank.Min;
import org.hipparchus.stat.descriptive.rank.RandomPercentile;
import org.hipparchus.stat.descriptive.summary.Sum;
import org.hipparchus.stat.descriptive.summary.SumOfLogs;
import org.hipparchus.stat.descriptive.summary.SumOfSquares;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.Precision;

public class StreamingStatistics
implements StatisticalSummary,
AggregatableStatistic<StreamingStatistics>,
DoubleConsumer,
Serializable {
    private static final long serialVersionUID = 20160422L;
    private long n;
    private final SecondMoment secondMoment;
    private final Min minImpl;
    private final Max maxImpl;
    private final Sum sumImpl;
    private final SumOfSquares sumOfSquaresImpl;
    private final SumOfLogs sumOfLogsImpl;
    private final Mean meanImpl;
    private final Variance varianceImpl;
    private final GeometricMean geoMeanImpl;
    private final Variance populationVariance;
    private final RandomPercentile randomPercentile;
    private final boolean computeMoments;
    private final boolean computeSumOfSquares;
    private final boolean computeSumOfLogs;
    private final boolean computePercentiles;
    private final boolean computeExtrema;

    public StreamingStatistics() {
        this(false);
    }

    public StreamingStatistics(boolean computePercentiles) {
        this(computePercentiles, true, true, true, true);
    }

    private StreamingStatistics(boolean computePercentiles, boolean computeMoments, boolean computeSumOfLogs, boolean computeSumOfSquares, boolean computeExtrema) {
        this.computeMoments = computeMoments;
        this.computeSumOfLogs = computeSumOfLogs;
        this.computeSumOfSquares = computeSumOfSquares;
        this.computePercentiles = computePercentiles;
        this.computeExtrema = computeExtrema;
        this.secondMoment = computeMoments ? new SecondMoment() : null;
        this.maxImpl = computeExtrema ? new Max() : null;
        this.minImpl = computeExtrema ? new Min() : null;
        this.sumImpl = computeMoments ? new Sum() : null;
        this.sumOfSquaresImpl = computeSumOfSquares ? new SumOfSquares() : null;
        this.sumOfLogsImpl = computeSumOfLogs ? new SumOfLogs() : null;
        this.meanImpl = computeMoments ? new Mean(this.secondMoment) : null;
        this.varianceImpl = computeMoments ? new Variance(this.secondMoment) : null;
        this.geoMeanImpl = computeSumOfLogs ? new GeometricMean(this.sumOfLogsImpl) : null;
        this.populationVariance = computeMoments ? new Variance(false, this.secondMoment) : null;
        this.randomPercentile = computePercentiles ? new RandomPercentile() : null;
    }

    StreamingStatistics(StreamingStatistics original) throws NullArgumentException {
        MathUtils.checkNotNull(original);
        this.n = original.n;
        this.secondMoment = original.computeMoments ? original.secondMoment.copy() : null;
        this.maxImpl = original.computeExtrema ? original.maxImpl.copy() : null;
        this.minImpl = original.computeExtrema ? original.minImpl.copy() : null;
        this.sumImpl = original.computeMoments ? original.sumImpl.copy() : null;
        this.sumOfLogsImpl = original.computeSumOfLogs ? original.sumOfLogsImpl.copy() : null;
        this.sumOfSquaresImpl = original.computeSumOfSquares ? original.sumOfSquaresImpl.copy() : null;
        this.meanImpl = original.computeMoments ? new Mean(this.secondMoment) : null;
        this.varianceImpl = original.computeMoments ? new Variance(this.secondMoment) : null;
        this.geoMeanImpl = original.computeSumOfLogs ? new GeometricMean(this.sumOfLogsImpl) : null;
        this.populationVariance = original.computeMoments ? new Variance(false, this.secondMoment) : null;
        this.randomPercentile = original.computePercentiles ? original.randomPercentile.copy() : null;
        this.computeMoments = original.computeMoments;
        this.computeSumOfLogs = original.computeSumOfLogs;
        this.computeSumOfSquares = original.computeSumOfSquares;
        this.computePercentiles = original.computePercentiles;
        this.computeExtrema = original.computeExtrema;
    }

    public StreamingStatistics copy() {
        return new StreamingStatistics(this);
    }

    public StatisticalSummary getSummary() {
        return new StatisticalSummaryValues(this.getMean(), this.getVariance(), this.getN(), this.getMax(), this.getMin(), this.getSum());
    }

    public void addValue(double value) {
        if (this.computeMoments) {
            this.secondMoment.increment(value);
            this.sumImpl.increment(value);
        }
        if (this.computeExtrema) {
            this.minImpl.increment(value);
            this.maxImpl.increment(value);
        }
        if (this.computeSumOfSquares) {
            this.sumOfSquaresImpl.increment(value);
        }
        if (this.computeSumOfLogs) {
            this.sumOfLogsImpl.increment(value);
        }
        if (this.computePercentiles) {
            this.randomPercentile.increment(value);
        }
        ++this.n;
    }

    @Override
    public void accept(double value) {
        this.addValue(value);
    }

    public void clear() {
        this.n = 0L;
        if (this.computeExtrema) {
            this.minImpl.clear();
            this.maxImpl.clear();
        }
        if (this.computeMoments) {
            this.sumImpl.clear();
            this.secondMoment.clear();
        }
        if (this.computeSumOfLogs) {
            this.sumOfLogsImpl.clear();
        }
        if (this.computeSumOfSquares) {
            this.sumOfSquaresImpl.clear();
        }
        if (this.computePercentiles) {
            this.randomPercentile.clear();
        }
    }

    @Override
    public long getN() {
        return this.n;
    }

    @Override
    public double getMax() {
        return this.computeExtrema ? this.maxImpl.getResult() : Double.NaN;
    }

    @Override
    public double getMin() {
        return this.computeExtrema ? this.minImpl.getResult() : Double.NaN;
    }

    @Override
    public double getSum() {
        return this.computeMoments ? this.sumImpl.getResult() : Double.NaN;
    }

    public double getSumOfSquares() {
        return this.computeSumOfSquares ? this.sumOfSquaresImpl.getResult() : Double.NaN;
    }

    @Override
    public double getMean() {
        return this.computeMoments ? this.meanImpl.getResult() : Double.NaN;
    }

    @Override
    public double getVariance() {
        return this.computeMoments ? this.varianceImpl.getResult() : Double.NaN;
    }

    public double getPopulationVariance() {
        return this.computeMoments ? this.populationVariance.getResult() : Double.NaN;
    }

    public double getGeometricMean() {
        return this.computeSumOfLogs ? this.geoMeanImpl.getResult() : Double.NaN;
    }

    public double getSumOfLogs() {
        return this.computeSumOfLogs ? this.sumOfLogsImpl.getResult() : Double.NaN;
    }

    public double getSecondMoment() {
        return this.computeMoments ? this.secondMoment.getResult() : Double.NaN;
    }

    public double getQuadraticMean() {
        if (this.computeSumOfSquares) {
            long size = this.getN();
            return size > 0L ? FastMath.sqrt(this.getSumOfSquares() / (double)size) : Double.NaN;
        }
        return Double.NaN;
    }

    @Override
    public double getStandardDeviation() {
        long size = this.getN();
        if (this.computeMoments) {
            if (size > 0L) {
                return size > 1L ? FastMath.sqrt(this.getVariance()) : 0.0;
            }
            return Double.NaN;
        }
        return Double.NaN;
    }

    public double getMedian() {
        return this.randomPercentile != null ? this.randomPercentile.getResult(50.0) : Double.NaN;
    }

    public double getPercentile(double percentile) {
        return this.randomPercentile != null ? this.randomPercentile.getResult(percentile) : Double.NaN;
    }

    @Override
    public void aggregate(StreamingStatistics other) {
        MathUtils.checkNotNull(other);
        if (other.n > 0L) {
            this.n += other.n;
            if (this.computeMoments && other.computeMoments) {
                this.secondMoment.aggregate(other.secondMoment);
                this.sumImpl.aggregate(other.sumImpl);
            }
            if (this.computeExtrema && other.computeExtrema) {
                this.minImpl.aggregate(other.minImpl);
                this.maxImpl.aggregate(other.maxImpl);
            }
            if (this.computeSumOfLogs && other.computeSumOfLogs) {
                this.sumOfLogsImpl.aggregate(other.sumOfLogsImpl);
            }
            if (this.computeSumOfSquares && other.computeSumOfSquares) {
                this.sumOfSquaresImpl.aggregate(other.sumOfSquaresImpl);
            }
            if (this.computePercentiles && other.computePercentiles) {
                this.randomPercentile.aggregate(other.randomPercentile);
            }
        }
    }

    public String toString() {
        StringBuilder outBuffer = new StringBuilder(200);
        String endl = "\n";
        outBuffer.append("StreamingStatistics:").append(endl).append("n: ").append(this.getN()).append(endl).append("min: ").append(this.getMin()).append(endl).append("max: ").append(this.getMax()).append(endl).append("sum: ").append(this.getSum()).append(endl).append("mean: ").append(this.getMean()).append(endl).append("variance: ").append(this.getVariance()).append(endl).append("population variance: ").append(this.getPopulationVariance()).append(endl).append("standard deviation: ").append(this.getStandardDeviation()).append(endl).append("geometric mean: ").append(this.getGeometricMean()).append(endl).append("second moment: ").append(this.getSecondMoment()).append(endl).append("sum of squares: ").append(this.getSumOfSquares()).append(endl).append("sum of logs: ").append(this.getSumOfLogs()).append(endl);
        return outBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StreamingStatistics)) {
            return false;
        }
        StreamingStatistics other = (StreamingStatistics)object;
        return other.getN() == this.getN() && Precision.equalsIncludingNaN(other.getMax(), this.getMax()) && Precision.equalsIncludingNaN(other.getMin(), this.getMin()) && Precision.equalsIncludingNaN(other.getSum(), this.getSum()) && Precision.equalsIncludingNaN(other.getGeometricMean(), this.getGeometricMean()) && Precision.equalsIncludingNaN(other.getMean(), this.getMean()) && Precision.equalsIncludingNaN(other.getSumOfSquares(), this.getSumOfSquares()) && Precision.equalsIncludingNaN(other.getSumOfLogs(), this.getSumOfLogs()) && Precision.equalsIncludingNaN(other.getVariance(), this.getVariance()) && Precision.equalsIncludingNaN(other.getMedian(), this.getMedian());
    }

    public int hashCode() {
        int result = 31 + MathUtils.hash(this.getN());
        result = result * 31 + MathUtils.hash(this.getMax());
        result = result * 31 + MathUtils.hash(this.getMin());
        result = result * 31 + MathUtils.hash(this.getSum());
        result = result * 31 + MathUtils.hash(this.getGeometricMean());
        result = result * 31 + MathUtils.hash(this.getMean());
        result = result * 31 + MathUtils.hash(this.getSumOfSquares());
        result = result * 31 + MathUtils.hash(this.getSumOfLogs());
        result = result * 31 + MathUtils.hash(this.getVariance());
        result = result * 31 + MathUtils.hash(this.getMedian());
        return result;
    }

    public static StreamingStatisticsBuilder builder() {
        return new StreamingStatisticsBuilder();
    }

    public static class StreamingStatisticsBuilder {
        private boolean computeMoments = true;
        private boolean computeSumOfSquares = true;
        private boolean computeSumOfLogs = true;
        private boolean computePercentiles = false;
        private boolean computeExtrema = true;

        public StreamingStatisticsBuilder moments(boolean arg) {
            this.computeMoments = arg;
            return this;
        }

        public StreamingStatisticsBuilder sumOfLogs(boolean arg) {
            this.computeSumOfLogs = arg;
            return this;
        }

        public StreamingStatisticsBuilder sumOfSquares(boolean arg) {
            this.computeSumOfSquares = arg;
            return this;
        }

        public StreamingStatisticsBuilder percentiles(boolean arg) {
            this.computePercentiles = arg;
            return this;
        }

        public StreamingStatisticsBuilder extrema(boolean arg) {
            this.computeExtrema = arg;
            return this;
        }

        public StreamingStatistics build() {
            return new StreamingStatistics(this.computePercentiles, this.computeMoments, this.computeSumOfLogs, this.computeSumOfSquares, this.computeExtrema);
        }
    }
}

