/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive.moment;

import java.io.Serializable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.hipparchus.stat.descriptive.AggregatableStatistic;
import org.hipparchus.stat.descriptive.summary.SumOfLogs;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;

public class GeometricMean
extends AbstractStorelessUnivariateStatistic
implements AggregatableStatistic<GeometricMean>,
Serializable {
    private static final long serialVersionUID = 20150412L;
    private final SumOfLogs sumOfLogs;
    private final boolean incSumOfLogs;

    public GeometricMean() {
        this.sumOfLogs = new SumOfLogs();
        this.incSumOfLogs = true;
    }

    public GeometricMean(SumOfLogs sumOfLogs) {
        this.sumOfLogs = sumOfLogs;
        this.incSumOfLogs = false;
    }

    public GeometricMean(GeometricMean original) throws NullArgumentException {
        MathUtils.checkNotNull(original);
        this.sumOfLogs = original.sumOfLogs.copy();
        this.incSumOfLogs = original.incSumOfLogs;
    }

    @Override
    public GeometricMean copy() {
        return new GeometricMean(this);
    }

    @Override
    public void increment(double d) {
        if (this.incSumOfLogs) {
            this.sumOfLogs.increment(d);
        }
    }

    @Override
    public double getResult() {
        if (this.sumOfLogs.getN() > 0L) {
            return FastMath.exp(this.sumOfLogs.getResult() / (double)this.sumOfLogs.getN());
        }
        return Double.NaN;
    }

    @Override
    public void clear() {
        if (this.incSumOfLogs) {
            this.sumOfLogs.clear();
        }
    }

    @Override
    public void aggregate(GeometricMean other) {
        MathUtils.checkNotNull(other);
        if (this.incSumOfLogs) {
            this.sumOfLogs.aggregate(other.sumOfLogs);
        }
    }

    @Override
    public double evaluate(double[] values, int begin, int length) throws MathIllegalArgumentException {
        return FastMath.exp(this.sumOfLogs.evaluate(values, begin, length) / (double)length);
    }

    @Override
    public long getN() {
        return this.sumOfLogs.getN();
    }
}

