/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive.moment;

import java.io.Serializable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.stat.StatUtils;
import org.hipparchus.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.hipparchus.stat.descriptive.AggregatableStatistic;
import org.hipparchus.stat.descriptive.WeightedEvaluation;
import org.hipparchus.stat.descriptive.moment.FirstMoment;
import org.hipparchus.stat.descriptive.summary.Sum;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public class Mean
extends AbstractStorelessUnivariateStatistic
implements AggregatableStatistic<Mean>,
WeightedEvaluation,
Serializable {
    private static final long serialVersionUID = 20150412L;
    protected final FirstMoment moment;
    protected final boolean incMoment;

    public Mean() {
        this.moment = new FirstMoment();
        this.incMoment = true;
    }

    public Mean(FirstMoment m1) {
        this.moment = m1;
        this.incMoment = false;
    }

    public Mean(Mean original) throws NullArgumentException {
        MathUtils.checkNotNull(original);
        this.moment = original.moment.copy();
        this.incMoment = original.incMoment;
    }

    @Override
    public void increment(double d) {
        if (this.incMoment) {
            this.moment.increment(d);
        }
    }

    @Override
    public void clear() {
        if (this.incMoment) {
            this.moment.clear();
        }
    }

    @Override
    public double getResult() {
        return this.moment.m1;
    }

    @Override
    public long getN() {
        return this.moment.getN();
    }

    @Override
    public void aggregate(Mean other) {
        MathUtils.checkNotNull(other);
        if (this.incMoment) {
            this.moment.aggregate(other.moment);
        }
    }

    @Override
    public double evaluate(double[] values, int begin, int length) throws MathIllegalArgumentException {
        if (MathArrays.verifyValues(values, begin, length)) {
            double sampleSize = length;
            double xbar = StatUtils.sum(values, begin, length) / sampleSize;
            double correction = 0.0;
            for (int i = begin; i < begin + length; ++i) {
                correction += values[i] - xbar;
            }
            return xbar + correction / sampleSize;
        }
        return Double.NaN;
    }

    @Override
    public double evaluate(double[] values, double[] weights, int begin, int length) throws MathIllegalArgumentException {
        if (MathArrays.verifyValues(values, weights, begin, length)) {
            Sum sum = new Sum();
            double sumw = sum.evaluate(weights, begin, length);
            double xbarw = sum.evaluate(values, weights, begin, length) / sumw;
            double correction = 0.0;
            for (int i = begin; i < begin + length; ++i) {
                correction += weights[i] * (values[i] - xbarw);
            }
            return xbarw + correction / sumw;
        }
        return Double.NaN;
    }

    @Override
    public Mean copy() {
        return new Mean(this);
    }
}

