/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive.moment;

import java.io.Serializable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.hipparchus.stat.descriptive.moment.SecondMoment;
import org.hipparchus.stat.descriptive.moment.Variance;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;

public class StandardDeviation
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = 20150412L;
    private final Variance variance;

    public StandardDeviation() {
        this(new Variance());
    }

    public StandardDeviation(SecondMoment m2) {
        this(new Variance(m2));
    }

    public StandardDeviation(boolean isBiasCorrected) {
        this(new Variance(isBiasCorrected));
    }

    public StandardDeviation(boolean isBiasCorrected, SecondMoment m2) {
        this(new Variance(isBiasCorrected, m2));
    }

    private StandardDeviation(Variance variance) {
        this.variance = variance;
    }

    public StandardDeviation(StandardDeviation original) throws NullArgumentException {
        MathUtils.checkNotNull(original);
        this.variance = original.variance.copy();
    }

    @Override
    public void increment(double d) {
        this.variance.increment(d);
    }

    @Override
    public long getN() {
        return this.variance.getN();
    }

    @Override
    public double getResult() {
        return FastMath.sqrt(this.variance.getResult());
    }

    @Override
    public void clear() {
        this.variance.clear();
    }

    @Override
    public double evaluate(double[] values, int begin, int length) throws MathIllegalArgumentException {
        return FastMath.sqrt(this.variance.evaluate(values, begin, length));
    }

    public double evaluate(double[] values, double mean, int begin, int length) throws MathIllegalArgumentException {
        return FastMath.sqrt(this.variance.evaluate(values, mean, begin, length));
    }

    public double evaluate(double[] values, double mean) throws MathIllegalArgumentException {
        return FastMath.sqrt(this.variance.evaluate(values, mean));
    }

    public boolean isBiasCorrected() {
        return this.variance.isBiasCorrected();
    }

    public StandardDeviation withBiasCorrection(boolean biasCorrection) {
        return new StandardDeviation(this.variance.withBiasCorrection(biasCorrection));
    }

    @Override
    public StandardDeviation copy() {
        return new StandardDeviation(this);
    }
}

