/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive.moment;

import java.io.Serializable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.stat.StatUtils;
import org.hipparchus.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.hipparchus.stat.descriptive.AggregatableStatistic;
import org.hipparchus.stat.descriptive.WeightedEvaluation;
import org.hipparchus.stat.descriptive.moment.Mean;
import org.hipparchus.stat.descriptive.moment.SecondMoment;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public class Variance
extends AbstractStorelessUnivariateStatistic
implements AggregatableStatistic<Variance>,
WeightedEvaluation,
Serializable {
    private static final long serialVersionUID = 20150412L;
    protected final SecondMoment moment;
    protected final boolean incMoment;
    private final boolean isBiasCorrected;

    public Variance() {
        this(true);
    }

    public Variance(SecondMoment m2) {
        this(true, m2);
    }

    public Variance(boolean isBiasCorrected) {
        this(new SecondMoment(), true, isBiasCorrected);
    }

    public Variance(boolean isBiasCorrected, SecondMoment m2) {
        this(m2, false, isBiasCorrected);
    }

    private Variance(SecondMoment m2, boolean incMoment, boolean isBiasCorrected) {
        this.moment = m2;
        this.incMoment = incMoment;
        this.isBiasCorrected = isBiasCorrected;
    }

    public Variance(Variance original) throws NullArgumentException {
        MathUtils.checkNotNull(original);
        this.moment = original.moment.copy();
        this.incMoment = original.incMoment;
        this.isBiasCorrected = original.isBiasCorrected;
    }

    @Override
    public void increment(double d) {
        if (this.incMoment) {
            this.moment.increment(d);
        }
    }

    @Override
    public double getResult() {
        if (this.moment.n == 0L) {
            return Double.NaN;
        }
        if (this.moment.n == 1L) {
            return 0.0;
        }
        if (this.isBiasCorrected) {
            return this.moment.m2 / ((double)this.moment.n - 1.0);
        }
        return this.moment.m2 / (double)this.moment.n;
    }

    @Override
    public long getN() {
        return this.moment.getN();
    }

    @Override
    public void clear() {
        if (this.incMoment) {
            this.moment.clear();
        }
    }

    @Override
    public void aggregate(Variance other) {
        MathUtils.checkNotNull(other);
        if (this.incMoment) {
            this.moment.aggregate(other.moment);
        }
    }

    @Override
    public double evaluate(double[] values, int begin, int length) throws MathIllegalArgumentException {
        double var = Double.NaN;
        if (MathArrays.verifyValues(values, begin, length)) {
            if (length == 1) {
                var = 0.0;
            } else if (length > 1) {
                double m = StatUtils.mean(values, begin, length);
                var = this.evaluate(values, m, begin, length);
            }
        }
        return var;
    }

    @Override
    public double evaluate(double[] values, double[] weights, int begin, int length) throws MathIllegalArgumentException {
        double var = Double.NaN;
        if (MathArrays.verifyValues(values, weights, begin, length)) {
            if (length == 1) {
                var = 0.0;
            } else if (length > 1) {
                Mean mean = new Mean();
                double m = mean.evaluate(values, weights, begin, length);
                var = this.evaluate(values, weights, m, begin, length);
            }
        }
        return var;
    }

    public double evaluate(double[] values, double mean, int begin, int length) throws MathIllegalArgumentException {
        double var = Double.NaN;
        if (MathArrays.verifyValues(values, begin, length)) {
            if (length == 1) {
                var = 0.0;
            } else if (length > 1) {
                double accum = 0.0;
                double dev = 0.0;
                double accum2 = 0.0;
                for (int i = begin; i < begin + length; ++i) {
                    dev = values[i] - mean;
                    accum += dev * dev;
                    accum2 += dev;
                }
                double len = length;
                var = this.isBiasCorrected ? (accum - accum2 * accum2 / len) / (len - 1.0) : (accum - accum2 * accum2 / len) / len;
            }
        }
        return var;
    }

    public double evaluate(double[] values, double mean) throws MathIllegalArgumentException {
        return this.evaluate(values, mean, 0, values.length);
    }

    public double evaluate(double[] values, double[] weights, double mean, int begin, int length) throws MathIllegalArgumentException {
        double var = Double.NaN;
        if (MathArrays.verifyValues(values, weights, begin, length)) {
            if (length == 1) {
                var = 0.0;
            } else if (length > 1) {
                double accum = 0.0;
                double dev = 0.0;
                double accum2 = 0.0;
                for (int i = begin; i < begin + length; ++i) {
                    dev = values[i] - mean;
                    accum += weights[i] * (dev * dev);
                    accum2 += weights[i] * dev;
                }
                double sumWts = 0.0;
                for (int i = begin; i < begin + length; ++i) {
                    sumWts += weights[i];
                }
                var = this.isBiasCorrected ? (accum - accum2 * accum2 / sumWts) / (sumWts - 1.0) : (accum - accum2 * accum2 / sumWts) / sumWts;
            }
        }
        return var;
    }

    public double evaluate(double[] values, double[] weights, double mean) throws MathIllegalArgumentException {
        return this.evaluate(values, weights, mean, 0, values.length);
    }

    public boolean isBiasCorrected() {
        return this.isBiasCorrected;
    }

    public Variance withBiasCorrection(boolean biasCorrection) {
        return new Variance(this.moment, this.incMoment, biasCorrection);
    }

    @Override
    public Variance copy() {
        return new Variance(this);
    }
}

