/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive.summary;

import java.io.Serializable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.hipparchus.stat.descriptive.AggregatableStatistic;
import org.hipparchus.stat.descriptive.WeightedEvaluation;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public class Product
extends AbstractStorelessUnivariateStatistic
implements AggregatableStatistic<Product>,
WeightedEvaluation,
Serializable {
    private static final long serialVersionUID = 20150412L;
    private long n;
    private double value;

    public Product() {
        this.n = 0L;
        this.value = 1.0;
    }

    public Product(Product original) throws NullArgumentException {
        MathUtils.checkNotNull(original);
        this.n = original.n;
        this.value = original.value;
    }

    @Override
    public void increment(double d) {
        this.value *= d;
        ++this.n;
    }

    @Override
    public double getResult() {
        return this.value;
    }

    @Override
    public long getN() {
        return this.n;
    }

    @Override
    public void clear() {
        this.value = 1.0;
        this.n = 0L;
    }

    @Override
    public void aggregate(Product other) {
        MathUtils.checkNotNull(other);
        if (other.n > 0L) {
            this.n += other.n;
            this.value *= other.value;
        }
    }

    @Override
    public double evaluate(double[] values, int begin, int length) throws MathIllegalArgumentException {
        double product = Double.NaN;
        if (MathArrays.verifyValues(values, begin, length, true)) {
            product = 1.0;
            for (int i = begin; i < begin + length; ++i) {
                product *= values[i];
            }
        }
        return product;
    }

    @Override
    public double evaluate(double[] values, double[] weights, int begin, int length) throws MathIllegalArgumentException {
        double product = Double.NaN;
        if (MathArrays.verifyValues(values, weights, begin, length, true)) {
            product = 1.0;
            for (int i = begin; i < begin + length; ++i) {
                product *= FastMath.pow(values[i], weights[i]);
            }
        }
        return product;
    }

    @Override
    public Product copy() {
        return new Product(this);
    }
}

