/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.util;

import java.util.Arrays;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.RealFieldElement;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.SinCos;

public class Tuple
implements RealFieldElement<Tuple> {
    private final double[] values;
    private final transient TupleField field;

    public Tuple(double ... x) {
        this(new TupleField(x.length), (double[])x.clone());
    }

    private Tuple(TupleField field, double[] x) {
        this.values = x;
        this.field = field;
    }

    public int getDimension() {
        return this.values.length;
    }

    public double getComponent(int index) {
        return this.values[index];
    }

    public double[] getComponents() {
        return (double[])this.values.clone();
    }

    @Override
    public Field<Tuple> getField() {
        return this.field;
    }

    @Override
    public Tuple add(Tuple a) {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = this.values[i] + a.values[i];
        }
        return result;
    }

    @Override
    public Tuple subtract(Tuple a) {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = this.values[i] - a.values[i];
        }
        return result;
    }

    @Override
    public Tuple negate() {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = -this.values[i];
        }
        return result;
    }

    @Override
    public Tuple multiply(Tuple a) {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = this.values[i] * a.values[i];
        }
        return result;
    }

    @Override
    public Tuple multiply(int n) {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = this.values[i] * (double)n;
        }
        return result;
    }

    @Override
    public Tuple divide(Tuple a) {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = this.values[i] / a.values[i];
        }
        return result;
    }

    @Override
    public Tuple reciprocal() {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = 1.0 / this.values[i];
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Tuple) {
            Tuple that = (Tuple)obj;
            if (this.getDimension() == that.getDimension()) {
                boolean equals = true;
                for (int i = 0; i < this.values.length; ++i) {
                    equals &= Double.doubleToRawLongBits(this.values[i]) == Double.doubleToRawLongBits(that.values[i]);
                }
                return equals;
            }
        }
        return false;
    }

    public int hashCode() {
        return 884057156 + Arrays.hashCode(this.values);
    }

    @Override
    public double getReal() {
        return this.values[0];
    }

    @Override
    public Tuple add(double a) {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = this.values[i] + a;
        }
        return result;
    }

    @Override
    public Tuple subtract(double a) {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = this.values[i] - a;
        }
        return result;
    }

    @Override
    public Tuple multiply(double a) {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = this.values[i] * a;
        }
        return result;
    }

    @Override
    public Tuple divide(double a) {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = this.values[i] / a;
        }
        return result;
    }

    @Override
    public Tuple remainder(double a) {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = FastMath.IEEEremainder(this.values[i], a);
        }
        return result;
    }

    @Override
    public Tuple remainder(Tuple a) {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = FastMath.IEEEremainder(this.values[i], a.values[i]);
        }
        return result;
    }

    @Override
    public Tuple abs() {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = FastMath.abs(this.values[i]);
        }
        return result;
    }

    @Override
    public Tuple ceil() {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = FastMath.ceil(this.values[i]);
        }
        return result;
    }

    @Override
    public Tuple floor() {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = FastMath.floor(this.values[i]);
        }
        return result;
    }

    @Override
    public Tuple rint() {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = FastMath.rint(this.values[i]);
        }
        return result;
    }

    @Override
    public long round() {
        return FastMath.round(this.values[0]);
    }

    @Override
    public Tuple signum() {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = FastMath.signum(this.values[i]);
        }
        return result;
    }

    @Override
    public Tuple copySign(Tuple sign) {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = FastMath.copySign(this.values[i], sign.values[i]);
        }
        return result;
    }

    @Override
    public Tuple copySign(double sign) {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = FastMath.copySign(this.values[i], sign);
        }
        return result;
    }

    @Override
    public Tuple scalb(int n) {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = FastMath.scalb(this.values[i], n);
        }
        return result;
    }

    @Override
    public Tuple hypot(Tuple y) {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = FastMath.hypot(this.values[i], y.values[i]);
        }
        return result;
    }

    @Override
    public Tuple sqrt() {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = FastMath.sqrt(this.values[i]);
        }
        return result;
    }

    @Override
    public Tuple cbrt() {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = FastMath.cbrt(this.values[i]);
        }
        return result;
    }

    @Override
    public Tuple rootN(int n) {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = this.values[i] < 0.0 ? -FastMath.pow(-this.values[i], 1.0 / (double)n) : FastMath.pow(this.values[i], 1.0 / (double)n);
        }
        return result;
    }

    @Override
    public Tuple pow(double p) {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = FastMath.pow(this.values[i], p);
        }
        return result;
    }

    @Override
    public Tuple pow(int n) {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = FastMath.pow(this.values[i], n);
        }
        return result;
    }

    @Override
    public Tuple pow(Tuple e) {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = FastMath.pow(this.values[i], e.values[i]);
        }
        return result;
    }

    @Override
    public Tuple exp() {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = FastMath.exp(this.values[i]);
        }
        return result;
    }

    @Override
    public Tuple expm1() {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = FastMath.expm1(this.values[i]);
        }
        return result;
    }

    @Override
    public Tuple log() {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = FastMath.log(this.values[i]);
        }
        return result;
    }

    @Override
    public Tuple log1p() {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = FastMath.log1p(this.values[i]);
        }
        return result;
    }

    @Override
    public Tuple log10() {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = FastMath.log10(this.values[i]);
        }
        return result;
    }

    @Override
    public Tuple cos() {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = FastMath.cos(this.values[i]);
        }
        return result;
    }

    @Override
    public Tuple sin() {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = FastMath.sin(this.values[i]);
        }
        return result;
    }

    @Override
    public FieldSinCos<Tuple> sinCos() {
        Tuple sin = new Tuple(this.field, new double[this.values.length]);
        Tuple cos = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            SinCos sc = FastMath.sinCos(this.values[i]);
            sin.values[i] = sc.sin();
            cos.values[i] = sc.cos();
        }
        return new FieldSinCos<Tuple>(sin, cos);
    }

    @Override
    public Tuple tan() {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = FastMath.tan(this.values[i]);
        }
        return result;
    }

    @Override
    public Tuple acos() {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = FastMath.acos(this.values[i]);
        }
        return result;
    }

    @Override
    public Tuple asin() {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = FastMath.asin(this.values[i]);
        }
        return result;
    }

    @Override
    public Tuple atan() {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = FastMath.atan(this.values[i]);
        }
        return result;
    }

    @Override
    public Tuple atan2(Tuple x) {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = FastMath.atan2(this.values[i], x.values[i]);
        }
        return result;
    }

    @Override
    public Tuple cosh() {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = FastMath.cosh(this.values[i]);
        }
        return result;
    }

    @Override
    public Tuple sinh() {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = FastMath.sinh(this.values[i]);
        }
        return result;
    }

    @Override
    public Tuple tanh() {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = FastMath.tanh(this.values[i]);
        }
        return result;
    }

    @Override
    public Tuple acosh() {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = FastMath.acosh(this.values[i]);
        }
        return result;
    }

    @Override
    public Tuple asinh() {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = FastMath.asinh(this.values[i]);
        }
        return result;
    }

    @Override
    public Tuple atanh() {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = FastMath.atanh(this.values[i]);
        }
        return result;
    }

    @Override
    public Tuple toDegrees() {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = FastMath.toDegrees(this.values[i]);
        }
        return result;
    }

    @Override
    public Tuple toRadians() {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = FastMath.toRadians(this.values[i]);
        }
        return result;
    }

    public Tuple linearCombination(Tuple[] a, Tuple[] b) throws MathIllegalArgumentException {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        MathUtils.checkDimension(a.length, b.length);
        double[] aDouble = new double[a.length];
        double[] bDouble = new double[b.length];
        for (int i = 0; i < this.values.length; ++i) {
            for (int j = 0; j < a.length; ++j) {
                aDouble[j] = a[j].values[i];
                bDouble[j] = b[j].values[i];
            }
            result.values[i] = MathArrays.linearCombination(aDouble, bDouble);
        }
        return result;
    }

    public Tuple linearCombination(double[] a, Tuple[] b) throws MathIllegalArgumentException {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        MathUtils.checkDimension(a.length, b.length);
        double[] bDouble = new double[b.length];
        for (int i = 0; i < this.values.length; ++i) {
            for (int j = 0; j < a.length; ++j) {
                bDouble[j] = b[j].values[i];
            }
            result.values[i] = MathArrays.linearCombination(a, bDouble);
        }
        return result;
    }

    @Override
    public Tuple linearCombination(Tuple a1, Tuple b1, Tuple a2, Tuple b2) {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = MathArrays.linearCombination(a1.values[i], b1.values[i], a2.values[i], b2.values[i]);
        }
        return result;
    }

    @Override
    public Tuple linearCombination(double a1, Tuple b1, double a2, Tuple b2) {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = MathArrays.linearCombination(a1, b1.values[i], a2, b2.values[i]);
        }
        return result;
    }

    @Override
    public Tuple linearCombination(Tuple a1, Tuple b1, Tuple a2, Tuple b2, Tuple a3, Tuple b3) {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = MathArrays.linearCombination(a1.values[i], b1.values[i], a2.values[i], b2.values[i], a3.values[i], b3.values[i]);
        }
        return result;
    }

    @Override
    public Tuple linearCombination(double a1, Tuple b1, double a2, Tuple b2, double a3, Tuple b3) {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = MathArrays.linearCombination(a1, b1.values[i], a2, b2.values[i], a3, b3.values[i]);
        }
        return result;
    }

    @Override
    public Tuple linearCombination(Tuple a1, Tuple b1, Tuple a2, Tuple b2, Tuple a3, Tuple b3, Tuple a4, Tuple b4) {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = MathArrays.linearCombination(a1.values[i], b1.values[i], a2.values[i], b2.values[i], a3.values[i], b3.values[i], a4.values[i], b4.values[i]);
        }
        return result;
    }

    @Override
    public Tuple linearCombination(double a1, Tuple b1, double a2, Tuple b2, double a3, Tuple b3, double a4, Tuple b4) {
        Tuple result = new Tuple(this.field, new double[this.values.length]);
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = MathArrays.linearCombination(a1, b1.values[i], a2, b2.values[i], a3, b3.values[i], a4, b4.values[i]);
        }
        return result;
    }

    private static class TupleField
    implements Field<Tuple> {
        private final Tuple zero;
        private final Tuple one;

        TupleField(int dimension) {
            double[] zeroData = new double[dimension];
            double[] oneData = new double[dimension];
            Arrays.fill(oneData, 1.0);
            this.zero = new Tuple(this, zeroData);
            this.one = new Tuple(this, oneData);
        }

        @Override
        public Tuple getZero() {
            return this.zero;
        }

        @Override
        public Tuple getOne() {
            return this.one;
        }

        @Override
        public Class<? extends FieldElement<Tuple>> getRuntimeClass() {
            return Tuple.class;
        }

        public boolean equals(Object other) {
            if (other instanceof TupleField) {
                return this.zero.getDimension() == ((TupleField)other).zero.getDimension();
            }
            return false;
        }

        public int hashCode() {
            return 0x6672493D ^ this.zero.getDimension();
        }
    }
}

