/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class CelestialBodyPointed
implements AttitudeProvider {
    private final Frame celestialFrame;
    private final PVCoordinatesProvider pointedBody;
    private final Vector3D phasingCel;
    private final Vector3D pointingSat;
    private final Vector3D phasingSat;

    public CelestialBodyPointed(Frame celestialFrame, PVCoordinatesProvider pointedBody, Vector3D phasingCel, Vector3D pointingSat, Vector3D phasingSat) {
        this.celestialFrame = celestialFrame;
        this.pointedBody = pointedBody;
        this.phasingCel = phasingCel;
        this.pointingSat = pointingSat;
        this.phasingSat = phasingSat;
    }

    @Override
    public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        TimeStampedPVCoordinates satPV = pvProv.getPVCoordinates(date, this.celestialFrame);
        TimeStampedPVCoordinates bodyPV = this.pointedBody.getPVCoordinates(date, this.celestialFrame);
        PVCoordinates pointing = new PVCoordinates(satPV, (PVCoordinates)bodyPV);
        Vector3D pointingP = pointing.getPosition();
        double r2 = Vector3D.dotProduct(pointingP, pointingP);
        Vector3D rotAxisCel = new Vector3D(1.0 / r2, Vector3D.crossProduct(pointingP, pointing.getVelocity()));
        Vector3D v1 = Vector3D.crossProduct(rotAxisCel, this.phasingCel);
        Vector3D v2 = Vector3D.crossProduct(pointingP, this.phasingCel);
        double compensation = -Vector3D.dotProduct(v1, v2) / v2.getNormSq();
        Vector3D phasedRotAxisCel = new Vector3D(1.0, rotAxisCel, compensation, pointingP);
        Rotation celToSatRotation = new Rotation(pointingP, this.phasingCel, this.pointingSat, this.phasingSat);
        Transform transform = new Transform(date, celToSatRotation, celToSatRotation.applyTo(phasedRotAxisCel));
        if (frame != this.celestialFrame) {
            transform = new Transform(date, frame.getTransformTo(this.celestialFrame, date), transform);
        }
        return new Attitude(date, frame, transform.getRotation(), transform.getRotationRate(), transform.getRotationAcceleration());
    }

    @Override
    public <T extends RealFieldElement<T>> FieldAttitude<T> getAttitude(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        Field<T> field = date.getField();
        TimeStampedFieldPVCoordinates<T> satPV = pvProv.getPVCoordinates(date, this.celestialFrame);
        FieldPVCoordinates<Field<T>> bodyPV = new FieldPVCoordinates<Field<T>>(field, (PVCoordinates)this.pointedBody.getPVCoordinates(date.toAbsoluteDate(), this.celestialFrame));
        FieldPVCoordinates<Field<T>> pointing = new FieldPVCoordinates<Field<T>>(satPV, bodyPV);
        FieldVector3D<Field<T>> pointingP = pointing.getPosition();
        Field<T> r2 = FieldVector3D.dotProduct(pointingP, pointingP);
        FieldVector3D<Field<T>> rotAxisCel = new FieldVector3D<Field<T>>((RealFieldElement)r2.reciprocal(), FieldVector3D.crossProduct(pointingP, pointing.getVelocity()));
        FieldVector3D<Field<T>> v1 = FieldVector3D.crossProduct(rotAxisCel, this.phasingCel);
        FieldVector3D<Field<T>> v2 = FieldVector3D.crossProduct(pointingP, this.phasingCel);
        RealFieldElement compensation = (RealFieldElement)((Object)((RealFieldElement)FieldVector3D.dotProduct(v1, v2).negate()).divide(v2.getNormSq()));
        FieldVector3D<Field<T>> phasedRotAxisCel = new FieldVector3D<Field<T>>((RealFieldElement)field.getOne(), rotAxisCel, compensation, pointingP);
        FieldRotation<Field<Field<T>>> celToSatRotation = new FieldRotation<Field<Field<T>>>(pointingP, new FieldVector3D<T>(field, this.phasingCel), new FieldVector3D<T>(field, this.pointingSat), new FieldVector3D<T>(field, this.phasingSat));
        FieldTransform<Field<T>> transform = new FieldTransform<Field<T>>(date, celToSatRotation, celToSatRotation.applyTo(phasedRotAxisCel));
        if (frame != this.celestialFrame) {
            transform = new FieldTransform<Field<Field<T>>>(date, frame.getTransformTo(this.celestialFrame, date), transform);
        }
        return new FieldAttitude<Field<T>>(date, frame, transform.getRotation(), transform.getRotationRate(), transform.getRotationAcceleration());
    }
}

