/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.bodies;

import java.io.Serializable;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.euclidean.twod.Vector2D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.Precision;
import org.orekit.bodies.Ellipse;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;

public class Ellipsoid
implements Serializable {
    private static final long serialVersionUID = 20140924L;
    private final Frame frame;
    private final double a;
    private final double b;
    private final double c;

    public Ellipsoid(Frame frame, double a, double b, double c) {
        this.frame = frame;
        this.a = a;
        this.b = b;
        this.c = c;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double getC() {
        return this.c;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public boolean isInside(Vector3D point) {
        double scaledZ;
        double scaledY;
        double scaledX = point.getX() / this.a;
        return scaledX * scaledX + (scaledY = point.getY() / this.b) * scaledY + (scaledZ = point.getZ() / this.c) * scaledZ <= 1.0;
    }

    public Ellipse getPlaneSection(Vector3D planePoint, Vector3D planeNormal) throws MathRuntimeException {
        double m;
        double bMA;
        Vector3D u = planeNormal.orthogonal();
        Vector3D v = Vector3D.crossProduct(planeNormal, u).normalize();
        double xUOa = u.getX() / this.a;
        double yUOb = u.getY() / this.b;
        double zUOc = u.getZ() / this.c;
        double xVOa = v.getX() / this.a;
        double yVOb = v.getY() / this.b;
        double zVOc = v.getZ() / this.c;
        double xPOa = planePoint.getX() / this.a;
        double yPOb = planePoint.getY() / this.b;
        double zPOc = planePoint.getZ() / this.c;
        double alpha = xUOa * xUOa + yUOb * yUOb + zUOc * zUOc;
        double beta = xVOa * xVOa + yVOb * yVOb + zVOc * zVOc;
        double gamma = MathArrays.linearCombination(xUOa, xVOa, yUOb, yVOb, zUOc, zVOc);
        double delta = MathArrays.linearCombination(xPOa, xUOa, yPOb, yUOb, zPOc, zUOc);
        double epsilon = MathArrays.linearCombination(xPOa, xVOa, yPOb, yVOb, zPOc, zVOc);
        double zeta = MathArrays.linearCombination(xPOa, xPOa, yPOb, yPOb, zPOc, zPOc, 1.0, -1.0);
        double tanTheta = FastMath.abs(gamma) < Precision.SAFE_MIN ? 0.0 : ((bMA = beta - alpha) >= 0.0 ? -2.0 * gamma / (bMA + FastMath.sqrt(bMA * bMA + 4.0 * gamma * gamma)) : -2.0 * gamma / (bMA - FastMath.sqrt(bMA * bMA + 4.0 * gamma * gamma)));
        double tan2 = tanTheta * tanTheta;
        double cos2 = 1.0 / (1.0 + tan2);
        double sin2 = tan2 * cos2;
        double cosSin = tanTheta * cos2;
        double cos = FastMath.sqrt(cos2);
        double sin = tanTheta * cos;
        double denom = MathArrays.linearCombination(gamma, gamma, -alpha, beta);
        double tauC = MathArrays.linearCombination(beta, delta, -gamma, epsilon) / denom;
        double nuC = MathArrays.linearCombination(alpha, epsilon, -gamma, delta) / denom;
        double twogcs = 2.0 * gamma * cosSin;
        double bigA = alpha * cos2 + beta * sin2 + twogcs;
        double bigB = alpha * sin2 + beta * cos2 - twogcs;
        double bigF = (alpha * tauC + 2.0 * (gamma * nuC + delta)) * tauC + (beta * nuC + 2.0 * epsilon) * nuC + zeta;
        double l = FastMath.sqrt(-bigF / bigA);
        if (Double.isNaN(l + (m = FastMath.sqrt(-bigF / bigB)))) {
            return null;
        }
        if (l > m) {
            return new Ellipse(new Vector3D(1.0, planePoint, tauC, u, nuC, v), new Vector3D(cos, u, sin, v), new Vector3D(-sin, u, cos, v), l, m, this.frame);
        }
        return new Ellipse(new Vector3D(1.0, planePoint, tauC, u, nuC, v), new Vector3D(sin, u, -cos, v), new Vector3D(cos, u, sin, v), m, l, this.frame);
    }

    public Vector3D pointOnLimb(Vector3D observer, Vector3D outside) throws MathRuntimeException {
        double ypt2;
        double ypt1;
        double xpt2;
        double xpt1;
        double s;
        if (this.isInside(observer)) {
            throw new OrekitException((Localizable)OrekitMessages.POINT_INSIDE_ELLIPSOID, new Object[0]);
        }
        Vector3D normal = Vector3D.crossProduct(observer, outside);
        Ellipse section = this.getPlaneSection(Vector3D.ZERO, normal);
        Vector2D observer2D = section.toPlane(observer);
        double ap = section.getA();
        double bp = section.getB();
        double xpo = observer2D.getX() / ap;
        double ypo = observer2D.getY() / bp;
        double xpo2 = xpo * xpo;
        double ypo2 = ypo * ypo;
        double alphap = ypo2 + xpo2;
        double gammap = 1.0 - ypo2;
        double sqrt = FastMath.sqrt(alphap - 1.0);
        double sqrtp = FastMath.abs(ypo) * sqrt;
        double sqrtSigned = FastMath.copySign(sqrt, ypo);
        if (xpo > 0.0) {
            s = xpo + sqrtp;
            xpt1 = s / alphap;
            xpt2 = gammap / s;
            ypt1 = (ypo - xpo * sqrtSigned) / alphap;
            ypt2 = (xpo * ypo + sqrtSigned) / s;
        } else {
            s = xpo - sqrtp;
            xpt1 = gammap / s;
            xpt2 = s / alphap;
            ypt2 = (ypo + xpo * sqrtSigned) / alphap;
            ypt1 = (xpo * ypo - sqrtSigned) / s;
        }
        Vector3D tp1 = section.toSpace(new Vector2D(ap * xpt1, bp * ypt1));
        Vector3D tp2 = section.toSpace(new Vector2D(ap * xpt2, bp * ypt2));
        return Vector3D.distance(tp1, outside) <= Vector3D.distance(tp2, outside) ? tp1 : tp2;
    }
}

