/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.bodies;

import java.text.NumberFormat;
import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.CompositeFormat;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;

public class FieldGeodeticPoint<T extends RealFieldElement<T>> {
    private final T latitude;
    private final T longitude;
    private final T altitude;
    private FieldVector3D<T> zenith;
    private FieldVector3D<T> nadir;
    private FieldVector3D<T> north;
    private FieldVector3D<T> south;
    private FieldVector3D<T> east;
    private FieldVector3D<T> west;

    public FieldGeodeticPoint(T latitude, T longitude, T altitude) {
        double lat = MathUtils.normalizeAngle(latitude.getReal(), 1.5707963267948966);
        double lon = MathUtils.normalizeAngle(longitude.getReal(), 0.0);
        if (lat > 1.5707963267948966) {
            lat = Math.PI - lat;
            lon = MathUtils.normalizeAngle(longitude.getReal() + Math.PI, 0.0);
        }
        double deltaLat = lat - latitude.getReal();
        double deltaLon = lon - longitude.getReal();
        this.latitude = (RealFieldElement)latitude.add(deltaLat);
        this.longitude = (RealFieldElement)longitude.add(deltaLon);
        this.altitude = altitude;
    }

    public T getLatitude() {
        return this.latitude;
    }

    public T getLongitude() {
        return this.longitude;
    }

    public T getAltitude() {
        return this.altitude;
    }

    public FieldVector3D<T> getZenith() {
        if (this.zenith == null) {
            RealFieldElement cosLat = (RealFieldElement)this.latitude.cos();
            RealFieldElement sinLat = (RealFieldElement)this.latitude.sin();
            RealFieldElement cosLon = (RealFieldElement)this.longitude.cos();
            RealFieldElement sinLon = (RealFieldElement)this.longitude.sin();
            this.zenith = new FieldVector3D<RealFieldElement>(cosLon.multiply(cosLat), sinLon.multiply(cosLat), sinLat);
        }
        return this.zenith;
    }

    public FieldVector3D<T> getNadir() {
        if (this.nadir == null) {
            this.nadir = this.getZenith().negate();
        }
        return this.nadir;
    }

    public FieldVector3D<T> getNorth() {
        if (this.north == null) {
            RealFieldElement cosLat = (RealFieldElement)this.latitude.cos();
            RealFieldElement sinLat = (RealFieldElement)this.latitude.sin();
            RealFieldElement cosLon = (RealFieldElement)this.longitude.cos();
            RealFieldElement sinLon = (RealFieldElement)this.longitude.sin();
            this.north = new FieldVector3D<RealFieldElement>((RealFieldElement)cosLon.multiply(sinLat).negate(), (RealFieldElement)sinLon.multiply(sinLat).negate(), cosLat);
        }
        return this.north;
    }

    public FieldVector3D<T> getSouth() {
        if (this.south == null) {
            this.south = this.getNorth().negate();
        }
        return this.south;
    }

    public FieldVector3D<T> getEast() {
        if (this.east == null) {
            this.east = new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)this.longitude.sin()).negate(), (RealFieldElement)this.longitude.cos(), (RealFieldElement)this.longitude.getField().getZero());
        }
        return this.east;
    }

    public FieldVector3D<T> getWest() {
        if (this.west == null) {
            this.west = this.getEast().negate();
        }
        return this.west;
    }

    public boolean equals(Object object) {
        if (object instanceof FieldGeodeticPoint) {
            FieldGeodeticPoint other = (FieldGeodeticPoint)object;
            return this.getLatitude().equals(other.getLatitude()) && this.getLongitude().equals(other.getLongitude()) && this.getAltitude().equals(other.getAltitude());
        }
        return false;
    }

    public int hashCode() {
        return this.getLatitude().hashCode() ^ this.getLongitude().hashCode() ^ this.getAltitude().hashCode();
    }

    public String toString() {
        NumberFormat format = CompositeFormat.getDefaultNumberFormat();
        return "{lat: " + format.format(FastMath.toDegrees(this.getLatitude().getReal())) + " deg, lon: " + format.format(FastMath.toDegrees(this.getLongitude().getReal())) + " deg, alt: " + format.format(this.getAltitude().getReal()) + "}";
    }
}

