/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.bodies;

import java.io.Serializable;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldLine;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Line;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.euclidean.twod.Vector2D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.Ellipse;
import org.orekit.bodies.Ellipsoid;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class OneAxisEllipsoid
extends Ellipsoid
implements BodyShape {
    private static final long serialVersionUID = 20130518L;
    private static final double ANGULAR_THRESHOLD = 1.0E-4;
    private final Frame bodyFrame;
    private final double ae2;
    private final double ap2;
    private final double f;
    private final double e2;
    private final double g;
    private final double g2;
    private double angularThreshold;

    public OneAxisEllipsoid(double ae, double f, Frame bodyFrame) {
        super(bodyFrame, ae, ae, ae * (1.0 - f));
        this.f = f;
        this.ae2 = ae * ae;
        this.e2 = f * (2.0 - f);
        this.g = 1.0 - f;
        this.g2 = this.g * this.g;
        this.ap2 = this.ae2 * this.g2;
        this.setAngularThreshold(1.0E-12);
        this.bodyFrame = bodyFrame;
    }

    public void setAngularThreshold(double angularThreshold) {
        this.angularThreshold = angularThreshold;
    }

    public double getEquatorialRadius() {
        return this.getA();
    }

    public double getFlattening() {
        return this.f;
    }

    @Override
    public Frame getBodyFrame() {
        return this.bodyFrame;
    }

    public Vector3D getCartesianIntersectionPoint(Line line, Vector3D close, Frame frame, AbsoluteDate date) {
        double c;
        double cz2;
        double a;
        double ac;
        double dz;
        double dy;
        Transform frameToBodyFrame = frame.getTransformTo(this.bodyFrame, date);
        Line lineInBodyFrame = frameToBodyFrame.transformLine(line);
        Vector3D point = lineInBodyFrame.getOrigin();
        double x = point.getX();
        double y = point.getY();
        double z = point.getZ();
        double z2 = z * z;
        double r2 = x * x + y * y;
        Vector3D direction = lineInBodyFrame.getDirection();
        double dx = direction.getX();
        double b = -(this.g2 * (x * dx + y * (dy = direction.getY())) + z * (dz = direction.getZ()));
        double b2 = b * b;
        if (b2 < (ac = (a = 1.0 - this.e2 * (cz2 = dx * dx + dy * dy)) * (c = this.g2 * (r2 - this.ae2) + z2))) {
            return null;
        }
        double s = FastMath.sqrt(b2 - ac);
        double k1 = b < 0.0 ? (b - s) / a : c / (b + s);
        double k2 = c / (a * k1);
        Vector3D closeInBodyFrame = frameToBodyFrame.transformPosition(close);
        double closeAbscissa = lineInBodyFrame.getAbscissa(closeInBodyFrame);
        double k = FastMath.abs(k1 - closeAbscissa) < FastMath.abs(k2 - closeAbscissa) ? k1 : k2;
        return lineInBodyFrame.pointAt(k);
    }

    @Override
    public GeodeticPoint getIntersectionPoint(Line line, Vector3D close, Frame frame, AbsoluteDate date) {
        Vector3D intersection = this.getCartesianIntersectionPoint(line, close, frame, date);
        if (intersection == null) {
            return null;
        }
        double ix = intersection.getX();
        double iy = intersection.getY();
        double iz = intersection.getZ();
        double lambda = FastMath.atan2(iy, ix);
        double phi = FastMath.atan2(iz, this.g2 * FastMath.sqrt(ix * ix + iy * iy));
        return new GeodeticPoint(phi, lambda, 0.0);
    }

    public <T extends RealFieldElement<T>> FieldVector3D<T> getCartesianIntersectionPoint(FieldLine<T> line, FieldVector3D<T> close, Frame frame, FieldAbsoluteDate<T> date) {
        FieldTransform<T> frameToBodyFrame = frame.getTransformTo(this.bodyFrame, date);
        FieldLine<T> lineInBodyFrame = frameToBodyFrame.transformLine(line);
        FieldVector3D<T> point = lineInBodyFrame.getOrigin();
        T x = point.getX();
        T y = point.getY();
        T z = point.getZ();
        RealFieldElement z2 = (RealFieldElement)z.multiply(z);
        RealFieldElement r2 = (RealFieldElement)((RealFieldElement)x.multiply(x)).add(y.multiply(y));
        FieldVector3D<T> direction = lineInBodyFrame.getDirection();
        T dx = direction.getX();
        T dy = direction.getY();
        T dz = direction.getZ();
        RealFieldElement cz2 = (RealFieldElement)((RealFieldElement)dx.multiply(dx)).add(dy.multiply(dy));
        RealFieldElement a = (RealFieldElement)((RealFieldElement)((RealFieldElement)cz2.multiply(this.e2)).subtract(1.0)).negate();
        RealFieldElement b = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)x.multiply(dx)).add(y.multiply(dy))).multiply(this.g2)).add(z.multiply(dz))).negate();
        RealFieldElement c = ((RealFieldElement)((RealFieldElement)r2.subtract(this.ae2)).multiply(this.g2)).add(z2);
        RealFieldElement b2 = b.multiply(b);
        RealFieldElement ac = a.multiply(c);
        if (b2.getReal() < ac.getReal()) {
            return null;
        }
        RealFieldElement s = (RealFieldElement)b2.subtract(ac).sqrt();
        RealFieldElement k1 = b.getReal() < 0.0 ? b.subtract(s).divide(a) : c.divide(b.add(s));
        RealFieldElement k2 = c.divide(a.multiply(k1));
        FieldVector3D<T> closeInBodyFrame = frameToBodyFrame.transformPosition(close);
        T closeAbscissa = lineInBodyFrame.getAbscissa(closeInBodyFrame);
        RealFieldElement k = FastMath.abs(k1.getReal() - closeAbscissa.getReal()) < FastMath.abs(k2.getReal() - closeAbscissa.getReal()) ? k1 : k2;
        return lineInBodyFrame.pointAt(k);
    }

    @Override
    public <T extends RealFieldElement<T>> FieldGeodeticPoint<T> getIntersectionPoint(FieldLine<T> line, FieldVector3D<T> close, Frame frame, FieldAbsoluteDate<T> date) {
        FieldVector3D<T> intersection = this.getCartesianIntersectionPoint(line, close, frame, date);
        if (intersection == null) {
            return null;
        }
        T ix = intersection.getX();
        T iy = intersection.getY();
        Object iz = intersection.getZ();
        RealFieldElement lambda = (RealFieldElement)iy.atan2(ix);
        RealFieldElement phi = (RealFieldElement)iz.atan2(((RealFieldElement)((RealFieldElement)((RealFieldElement)ix.multiply(ix)).add(iy.multiply(iy))).sqrt()).multiply(this.g2));
        return new FieldGeodeticPoint<RealFieldElement>(phi, lambda, (RealFieldElement)phi.getField().getZero());
    }

    @Override
    public Vector3D transform(GeodeticPoint point) {
        double longitude = point.getLongitude();
        double cLambda = FastMath.cos(longitude);
        double sLambda = FastMath.sin(longitude);
        double latitude = point.getLatitude();
        double cPhi = FastMath.cos(latitude);
        double sPhi = FastMath.sin(latitude);
        double h = point.getAltitude();
        double n = this.getA() / FastMath.sqrt(1.0 - this.e2 * sPhi * sPhi);
        double r = (n + h) * cPhi;
        return new Vector3D(r * cLambda, r * sLambda, (this.g2 * n + h) * sPhi);
    }

    @Override
    public <T extends RealFieldElement<T>> FieldVector3D<T> transform(FieldGeodeticPoint<T> point) {
        T latitude = point.getLatitude();
        T longitude = point.getLongitude();
        Object altitude = point.getAltitude();
        RealFieldElement cLambda = (RealFieldElement)longitude.cos();
        RealFieldElement sLambda = (RealFieldElement)longitude.sin();
        RealFieldElement cPhi = (RealFieldElement)latitude.cos();
        RealFieldElement sPhi = (RealFieldElement)latitude.sin();
        RealFieldElement n = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)sPhi.multiply(sPhi).multiply(this.e2)).subtract(1.0)).negate()).sqrt()).reciprocal()).multiply(this.getA());
        RealFieldElement r = ((RealFieldElement)n.add(altitude)).multiply(cPhi);
        return new FieldVector3D<RealFieldElement>(r.multiply(cLambda), r.multiply(sLambda), (RealFieldElement)sPhi.multiply(altitude.add(n.multiply(this.g2))));
    }

    @Override
    public Vector3D projectToGround(Vector3D point, AbsoluteDate date, Frame frame) {
        Transform toBody = frame.getTransformTo(this.bodyFrame, date);
        Vector3D p = toBody.transformPosition(point);
        double z = p.getZ();
        double r = FastMath.hypot(p.getX(), p.getY());
        Ellipse meridian = new Ellipse(Vector3D.ZERO, r == 0.0 ? Vector3D.PLUS_I : new Vector3D(p.getX() / r, p.getY() / r, 0.0), Vector3D.PLUS_K, this.getA(), this.getC(), this.bodyFrame);
        Vector3D groundPoint = meridian.toSpace(meridian.projectToEllipse(new Vector2D(r, z)));
        return toBody.getInverse().transformPosition(groundPoint);
    }

    @Override
    public TimeStampedPVCoordinates projectToGround(TimeStampedPVCoordinates pv, Frame frame) {
        Transform toBody = frame.getTransformTo(this.bodyFrame, pv.getDate());
        TimeStampedPVCoordinates pvInBodyFrame = toBody.transformPVCoordinates(pv);
        Vector3D p = pvInBodyFrame.getPosition();
        double r = FastMath.hypot(p.getX(), p.getY());
        Vector3D meridian = r == 0.0 ? Vector3D.PLUS_I : new Vector3D(p.getX() / r, p.getY() / r, 0.0);
        Ellipse firstPrincipalCurvature = new Ellipse(Vector3D.ZERO, meridian, Vector3D.PLUS_K, this.getA(), this.getC(), this.bodyFrame);
        TimeStampedPVCoordinates gpFirst = firstPrincipalCurvature.projectToEllipse(pvInBodyFrame);
        Vector3D gpP = gpFirst.getPosition();
        double gr = MathArrays.linearCombination(gpP.getX(), meridian.getX(), gpP.getY(), meridian.getY());
        double gz = gpP.getZ();
        Vector3D east = new Vector3D(-meridian.getY(), meridian.getX(), 0.0);
        Vector3D zenith = new Vector3D(gr * this.getC() / this.getA(), meridian, gz * this.getA() / this.getC(), Vector3D.PLUS_K).normalize();
        Vector3D north = Vector3D.crossProduct(zenith, east);
        Ellipse secondPrincipalCurvature = this.getPlaneSection(gpP, north);
        TimeStampedPVCoordinates gpSecond = secondPrincipalCurvature.projectToEllipse(pvInBodyFrame);
        Vector gpV = gpFirst.getVelocity().add((Vector)gpSecond.getVelocity());
        Vector gpA = gpFirst.getAcceleration().add((Vector)gpSecond.getAcceleration());
        TimeStampedPVCoordinates groundPV = new TimeStampedPVCoordinates(pv.getDate(), gpP, (Vector3D)gpV, (Vector3D)gpA);
        return toBody.getInverse().transformPVCoordinates(groundPV);
    }

    @Override
    public GeodeticPoint transform(Vector3D point, Frame frame, AbsoluteDate date) {
        double h;
        double phi;
        Vector3D pointInBodyFrame = frame.getTransformTo(this.bodyFrame, date).transformPosition(point);
        double r2 = pointInBodyFrame.getX() * pointInBodyFrame.getX() + pointInBodyFrame.getY() * pointInBodyFrame.getY();
        double r = FastMath.sqrt(r2);
        double z = pointInBodyFrame.getZ();
        double lambda = FastMath.atan2(pointInBodyFrame.getY(), pointInBodyFrame.getX());
        if (r <= 1.0E-4 * FastMath.abs(z)) {
            double osculatingRadius = this.ae2 / this.getC();
            double evoluteCuspZ = FastMath.copySign(this.getA() * this.e2 / this.g, -z);
            double deltaZ = z - evoluteCuspZ;
            phi = FastMath.copySign(1.5707963267948966 - FastMath.atan(r / FastMath.abs(deltaZ)), deltaZ);
            h = FastMath.hypot(deltaZ, r) - osculatingRadius;
        } else if (FastMath.abs(z) <= 1.0E-4 * r) {
            double osculatingRadius = this.ap2 / this.getA();
            double evoluteCuspR = this.getA() * this.e2;
            double deltaR = r - evoluteCuspR;
            if (deltaR >= 0.0) {
                phi = deltaR == 0.0 ? 0.0 : FastMath.atan(z / deltaR);
                h = FastMath.hypot(deltaR, z) - osculatingRadius;
            } else {
                double rClose = r / this.e2;
                double zClose = FastMath.copySign(this.g * FastMath.sqrt(this.ae2 - rClose * rClose), z);
                phi = FastMath.atan((zClose - z) / (rClose - r));
                h = -FastMath.hypot(r - rClose, z - zClose);
            }
        } else {
            double epsPhi = 1.0E-15;
            double epsH = 1.0E-14 * FastMath.max(this.getA(), FastMath.sqrt(r2 + z * z));
            double c = this.getA() * this.e2;
            double absZ = FastMath.abs(z);
            double zc = this.g * absZ;
            double sn = absZ;
            double sn2 = sn * sn;
            double cn = this.g * r;
            double cn2 = cn * cn;
            double an2 = cn2 + sn2;
            double an = FastMath.sqrt(an2);
            double bn = 0.0;
            phi = Double.POSITIVE_INFINITY;
            h = Double.POSITIVE_INFINITY;
            for (int i = 0; i < 10; ++i) {
                double oldSn = sn;
                double oldCn = cn;
                double oldPhi = phi;
                double oldH = h;
                double an3 = an2 * an;
                double csncn = c * sn * cn;
                bn = 1.5 * csncn * ((r * sn - zc * cn) * an - csncn);
                sn = (zc * an3 + c * sn2 * sn) * an3 - bn * sn;
                cn = (r * an3 - c * cn2 * cn) * an3 - bn * cn;
                if (sn * oldSn < 0.0 || cn < 0.0) {
                    while (sn * oldSn < 0.0 || cn < 0.0) {
                        sn = (sn + oldSn) / 2.0;
                        cn = (cn + oldCn) / 2.0;
                    }
                    continue;
                }
                int exp = (FastMath.getExponent(sn) + FastMath.getExponent(cn)) / 2;
                sn = FastMath.scalb(sn, -exp);
                cn = FastMath.scalb(cn, -exp);
                sn2 = sn * sn;
                cn2 = cn * cn;
                an2 = cn2 + sn2;
                an = FastMath.sqrt(an2);
                double cc = this.g * cn;
                h = (r * cc + absZ * sn - this.getA() * this.g * an) / FastMath.sqrt(an2 - this.e2 * cn2);
                if (FastMath.abs(oldH - h) < epsH && FastMath.abs(oldPhi - (phi = FastMath.copySign(FastMath.atan(sn / cc), z))) < 1.0E-15) break;
            }
        }
        return new GeodeticPoint(phi, lambda, h);
    }

    @Override
    public <T extends RealFieldElement<T>> FieldGeodeticPoint<T> transform(FieldVector3D<T> point, Frame frame, FieldAbsoluteDate<T> date) {
        RealFieldElement h;
        RealFieldElement phi;
        FieldVector3D<T> pointInBodyFrame = frame.getTransformTo(this.bodyFrame, date).transformPosition(point);
        RealFieldElement r2 = (RealFieldElement)((RealFieldElement)pointInBodyFrame.getX().multiply(pointInBodyFrame.getX())).add(pointInBodyFrame.getY().multiply(pointInBodyFrame.getY()));
        RealFieldElement r = (RealFieldElement)r2.sqrt();
        RealFieldElement z = pointInBodyFrame.getZ();
        RealFieldElement lambda = (RealFieldElement)pointInBodyFrame.getY().atan2(pointInBodyFrame.getX());
        if (r.getReal() <= 1.0E-4 * FastMath.abs(z.getReal())) {
            double osculatingRadius = this.ae2 / this.getC();
            double evoluteCuspZ = FastMath.copySign(this.getA() * this.e2 / this.g, -z.getReal());
            RealFieldElement deltaZ = (RealFieldElement)z.subtract(evoluteCuspZ);
            phi = ((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)r.divide(deltaZ.abs())).atan()).negate()).add(1.5707963267948966)).copySign(deltaZ);
            h = (RealFieldElement)deltaZ.hypot(r).subtract(osculatingRadius);
        } else if (FastMath.abs(z.getReal()) <= 1.0E-4 * r.getReal()) {
            double osculatingRadius = this.ap2 / this.getA();
            double evoluteCuspR = this.getA() * this.e2;
            RealFieldElement deltaR = (RealFieldElement)r.subtract(evoluteCuspR);
            if (deltaR.getReal() >= 0.0) {
                phi = deltaR.getReal() == 0.0 ? (RealFieldElement)z.getField().getZero() : (RealFieldElement)z.divide((RealFieldElement)deltaR).atan();
                h = (RealFieldElement)((RealFieldElement)deltaR.hypot(z)).subtract(osculatingRadius);
            } else {
                RealFieldElement rClose = (RealFieldElement)r.divide(this.e2);
                RealFieldElement zClose = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)rClose.multiply(rClose).negate()).add(this.ae2)).sqrt()).multiply(this.g)).copySign(z);
                phi = (RealFieldElement)((RealFieldElement)zClose.subtract(z)).divide(rClose.subtract(r)).atan();
                h = (RealFieldElement)r.subtract(rClose).hypot(z.subtract((RealFieldElement)zClose)).negate();
            }
        } else {
            double epsPhi = 1.0E-15;
            double epsH = 1.0E-14 * this.getA();
            double c = this.getA() * this.e2;
            RealFieldElement absZ = (RealFieldElement)z.abs();
            RealFieldElement zc = (RealFieldElement)absZ.multiply(this.g);
            RealFieldElement sn = absZ;
            RealFieldElement sn2 = sn.multiply(sn);
            RealFieldElement cn = (RealFieldElement)r.multiply(this.g);
            RealFieldElement cn2 = cn.multiply(cn);
            RealFieldElement an2 = cn2.add(sn2);
            RealFieldElement an = (RealFieldElement)an2.sqrt();
            RealFieldElement bn = (RealFieldElement)an.getField().getZero();
            phi = (RealFieldElement)((RealFieldElement)an.getField().getZero()).add(Double.POSITIVE_INFINITY);
            h = (RealFieldElement)((RealFieldElement)an.getField().getZero()).add(Double.POSITIVE_INFINITY);
            for (int i = 0; i < 10; ++i) {
                RealFieldElement oldSn = sn;
                RealFieldElement oldCn = cn;
                RealFieldElement oldPhi = phi;
                RealFieldElement oldH = h;
                RealFieldElement an3 = an2.multiply(an);
                RealFieldElement csncn = (RealFieldElement)sn.multiply(cn).multiply(c);
                bn = ((RealFieldElement)csncn.multiply(1.5)).multiply(r.multiply(sn).subtract(zc.multiply(cn)).multiply(an).subtract(csncn));
                sn = ((RealFieldElement)zc.multiply(an3).add(sn2.multiply(sn).multiply(c))).multiply(an3).subtract(bn.multiply(sn));
                cn = ((RealFieldElement)r.multiply(an3).subtract(cn2.multiply(cn).multiply(c))).multiply(an3).subtract(bn.multiply(cn));
                if (sn.getReal() * oldSn.getReal() < 0.0 || cn.getReal() < 0.0) {
                    while (sn.getReal() * oldSn.getReal() < 0.0 || cn.getReal() < 0.0) {
                        sn = (RealFieldElement)sn.add(oldSn).multiply(0.5);
                        cn = (RealFieldElement)cn.add(oldCn).multiply(0.5);
                    }
                    continue;
                }
                int exp = (FastMath.getExponent(sn.getReal()) + FastMath.getExponent(cn.getReal())) / 2;
                sn = (RealFieldElement)sn.scalb(-exp);
                cn = (RealFieldElement)cn.scalb(-exp);
                sn2 = sn.multiply(sn);
                cn2 = cn.multiply(cn);
                an2 = cn2.add(sn2);
                an = (RealFieldElement)an2.sqrt();
                RealFieldElement cc = (RealFieldElement)cn.multiply(this.g);
                h = (RealFieldElement)((RealFieldElement)r.multiply(cc).add(absZ.multiply(sn)).subtract(an.multiply(this.getA() * this.g))).divide(((RealFieldElement)an2.subtract(cn2.multiply(this.e2))).sqrt());
                if (!(FastMath.abs(oldH.getReal() - h.getReal()) < epsH)) continue;
                phi = (RealFieldElement)((RealFieldElement)sn.divide(cc).atan()).copySign(z);
                if (FastMath.abs(oldPhi.getReal() - phi.getReal()) < 1.0E-15) break;
            }
        }
        return new FieldGeodeticPoint<RealFieldElement>(phi, lambda, h);
    }

    public FieldGeodeticPoint<DerivativeStructure> transform(PVCoordinates point, Frame frame, AbsoluteDate date) {
        Transform toBody = frame.getTransformTo(this.bodyFrame, date);
        PVCoordinates pointInBodyFrame = toBody.transformPVCoordinates(point);
        FieldVector3D<DerivativeStructure> p = pointInBodyFrame.toDerivativeStructureVector(2);
        DerivativeStructure pr2 = p.getX().multiply(p.getX()).add(p.getY().multiply(p.getY()));
        DerivativeStructure pr = pr2.sqrt();
        DerivativeStructure pz = p.getZ();
        TimeStampedPVCoordinates groundPoint = this.projectToGround(new TimeStampedPVCoordinates(date, pointInBodyFrame), this.bodyFrame);
        FieldVector3D<DerivativeStructure> gp = groundPoint.toDerivativeStructureVector(2);
        DerivativeStructure gpr2 = gp.getX().multiply(gp.getX()).add(gp.getY().multiply(gp.getY()));
        DerivativeStructure gpr = gpr2.sqrt();
        DerivativeStructure gpz = gp.getZ();
        DerivativeStructure dr = pr.subtract(gpr);
        DerivativeStructure dz = pz.subtract(gpz);
        double insideIfNegative = this.g2 * (pr2.getReal() - this.ae2) + pz.getReal() * pz.getReal();
        return new FieldGeodeticPoint<DerivativeStructure>(DerivativeStructure.atan2(gpz, gpr.multiply(this.g2)), DerivativeStructure.atan2(p.getY(), p.getX()), DerivativeStructure.hypot(dr, dz).copySign(insideIfNegative));
    }

    private Object writeReplace() {
        return new DataTransferObject(this.getA(), this.f, this.bodyFrame, this.angularThreshold);
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20130518L;
        private final double ae;
        private final double f;
        private final Frame bodyFrame;
        private final double angularThreshold;

        DataTransferObject(double ae, double f, Frame bodyFrame, double angularThreshold) {
            this.ae = ae;
            this.f = f;
            this.bodyFrame = bodyFrame;
            this.angularThreshold = angularThreshold;
        }

        private Object readResolve() {
            OneAxisEllipsoid ellipsoid = new OneAxisEllipsoid(this.ae, this.f, this.bodyFrame);
            ellipsoid.setAngularThreshold(this.angularThreshold);
            return ellipsoid;
        }
    }
}

