/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.hipparchus.exception.DummyLocalizable;
import org.hipparchus.exception.Localizable;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.data.DataLoader;
import org.orekit.data.DataProvider;
import org.orekit.data.DataProvidersManager;
import org.orekit.data.NamedData;
import org.orekit.data.ZipJarCrawler;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;

public class DirectoryCrawler
implements DataProvider {
    private final File root;

    public DirectoryCrawler(File root) {
        if (!root.isDirectory()) {
            throw new OrekitException((Localizable)OrekitMessages.NOT_A_DIRECTORY, root.getAbsolutePath());
        }
        this.root = root;
    }

    @Override
    @Deprecated
    @DefaultDataContext
    public boolean feed(Pattern supported, DataLoader visitor) {
        return this.feed(supported, visitor, DataContext.getDefault().getDataProvidersManager());
    }

    @Override
    public boolean feed(Pattern supported, DataLoader visitor, DataProvidersManager manager) {
        try {
            return this.feed(supported, visitor, manager, this.root);
        }
        catch (IOException | ParseException ioe) {
            throw new OrekitException(ioe, new DummyLocalizable(ioe.getMessage()), new Object[0]);
        }
    }

    private boolean feed(Pattern supported, DataLoader visitor, DataProvidersManager manager, File directory) throws IOException, ParseException {
        File[] list = directory.listFiles();
        if (list == null) {
            throw new OrekitException((Localizable)OrekitMessages.NOT_A_DIRECTORY, directory.getAbsolutePath());
        }
        Arrays.sort(list, File::compareTo);
        OrekitException delayedException = null;
        boolean loaded = false;
        for (File file : list) {
            try {
                if (!visitor.stillAcceptsData()) continue;
                if (file.isDirectory()) {
                    loaded = this.feed(supported, visitor, manager, file) || loaded;
                    continue;
                }
                if (ZIP_ARCHIVE_PATTERN.matcher(file.getName()).matches()) {
                    ZipJarCrawler zipProvider = new ZipJarCrawler(file);
                    loaded = zipProvider.feed(supported, visitor, manager) || loaded;
                    continue;
                }
                NamedData data = new NamedData(file.getName(), () -> new FileInputStream(file));
                if (!supported.matcher((data = manager.applyAllFilters(data)).getName()).matches()) continue;
                try (InputStream input = data.getStreamOpener().openStream();){
                    visitor.loadData(input, file.getPath());
                    loaded = true;
                }
            }
            catch (OrekitException oe) {
                delayedException = oe;
            }
        }
        if (!loaded && delayedException != null) {
            throw delayedException;
        }
        return loaded;
    }
}

