/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.data;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.hipparchus.exception.DummyLocalizable;
import org.orekit.data.AbstractListCrawler;
import org.orekit.data.ZipJarCrawler;
import org.orekit.errors.OrekitException;

public class NetworkCrawler
extends AbstractListCrawler<URL> {
    private int timeout = 10000;

    public NetworkCrawler(URL ... inputs) {
        super(inputs);
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    protected String getCompleteName(URL input) {
        try {
            return input.toURI().toString();
        }
        catch (URISyntaxException ue) {
            throw new OrekitException(ue, new DummyLocalizable(ue.getMessage()), new Object[0]);
        }
    }

    @Override
    protected String getBaseName(URL input) {
        return new File(input.getPath()).getName();
    }

    @Override
    protected ZipJarCrawler getZipJarCrawler(URL input) {
        return new ZipJarCrawler(input);
    }

    @Override
    protected InputStream getStream(URL input) throws IOException {
        URLConnection connection = input.openConnection();
        connection.setConnectTimeout(this.timeout);
        return connection.getInputStream();
    }
}

