/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.data;

import org.hipparchus.RealFieldElement;
import org.orekit.data.BodiesElements;
import org.orekit.data.FieldBodiesElements;
import org.orekit.data.SeriesTerm;

class PlanetaryTerm
extends SeriesTerm {
    private final int cMe;
    private final int cVe;
    private final int cE;
    private final int cMa;
    private final int cJu;
    private final int cSa;
    private final int cUr;
    private final int cNe;
    private final int cPa;

    PlanetaryTerm(int cMe, int cVe, int cE, int cMa, int cJu, int cSa, int cUr, int cNe, int cPa) {
        this.cMe = cMe;
        this.cVe = cVe;
        this.cE = cE;
        this.cMa = cMa;
        this.cJu = cJu;
        this.cSa = cSa;
        this.cUr = cUr;
        this.cNe = cNe;
        this.cPa = cPa;
    }

    @Override
    protected double argument(BodiesElements elements) {
        return (double)this.cMe * elements.getLMe() + (double)this.cVe * elements.getLVe() + (double)this.cE * elements.getLE() + (double)this.cMa * elements.getLMa() + (double)this.cJu * elements.getLJu() + (double)this.cSa * elements.getLSa() + (double)this.cUr * elements.getLUr() + (double)this.cNe * elements.getLNe() + (double)this.cPa * elements.getPa();
    }

    @Override
    protected double argumentDerivative(BodiesElements elements) {
        return (double)this.cMe * elements.getLMeDot() + (double)this.cVe * elements.getLVeDot() + (double)this.cE * elements.getLEDot() + (double)this.cMa * elements.getLMaDot() + (double)this.cJu * elements.getLJuDot() + (double)this.cSa * elements.getLSaDot() + (double)this.cUr * elements.getLUrDot() + (double)this.cNe * elements.getLNeDot() + (double)this.cPa * elements.getPaDot();
    }

    @Override
    protected <T extends RealFieldElement<T>> T argument(FieldBodiesElements<T> elements) {
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)elements.getLMe().multiply((int)this.cMe)).add(elements.getLVe().multiply((int)this.cVe))).add(elements.getLE().multiply((int)this.cE))).add(elements.getLMa().multiply((int)this.cMa))).add(elements.getLJu().multiply((int)this.cJu))).add(elements.getLSa().multiply((int)this.cSa))).add(elements.getLUr().multiply((int)this.cUr))).add(elements.getLNe().multiply((int)this.cNe))).add(elements.getPa().multiply((int)this.cPa)));
    }

    @Override
    protected <T extends RealFieldElement<T>> T argumentDerivative(FieldBodiesElements<T> elements) {
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)elements.getLMeDot().multiply((int)this.cMe)).add(elements.getLVeDot().multiply((int)this.cVe))).add(elements.getLEDot().multiply((int)this.cE))).add(elements.getLMaDot().multiply((int)this.cMa))).add(elements.getLJuDot().multiply((int)this.cJu))).add(elements.getLSaDot().multiply((int)this.cSa))).add(elements.getLUrDot().multiply((int)this.cUr))).add(elements.getLNeDot().multiply((int)this.cNe))).add(elements.getPaDot().multiply((int)this.cPa)));
    }
}

