/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hipparchus.exception.DummyLocalizable;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.orekit.data.NutationCodec;
import org.orekit.data.PoissonSeries;
import org.orekit.data.PolynomialNutation;
import org.orekit.data.PolynomialParser;
import org.orekit.data.SeriesTerm;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;

public class PoissonSeriesParser {
    private static final String UNKNOWN_TYPE_PATTERN = "\\S+";
    private static final String OPTIONAL_FIELD_PATTERN = "\\S*";
    private static final String INTEGER_TYPE_PATTERN = "[-+]?\\p{Digit}+";
    private static final String REAL_TYPE_PATTERN = "[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?";
    private static final String DOODSON_TYPE_PATTERN = "\\p{Digit}{2,3}[.,]\\p{Digit}{3}";
    private final PolynomialParser polynomialParser;
    private final String[] fieldsPatterns;
    private final int optional;
    private final int gamma;
    private final int firstDoodson;
    private final int doodson;
    private final int firstDelaunay;
    private final int firstPlanetary;
    private final int[] sinCosColumns;
    private final double[] sinCosFactors;

    private PoissonSeriesParser(PolynomialParser polynomialParser, String[] fieldsPatterns, int optional, int gamma, int firstDoodson, int doodson, int firstDelaunay, int firstPlanetary, int[] sinCosColumns, double[] factors) {
        this.polynomialParser = polynomialParser;
        this.fieldsPatterns = fieldsPatterns;
        this.optional = optional;
        this.gamma = gamma;
        this.firstDoodson = firstDoodson;
        this.doodson = doodson;
        this.firstDelaunay = firstDelaunay;
        this.firstPlanetary = firstPlanetary;
        this.sinCosColumns = sinCosColumns;
        this.sinCosFactors = factors;
    }

    public PoissonSeriesParser(int totalColumns) {
        this(null, PoissonSeriesParser.createInitialFieldsPattern(totalColumns), -1, -1, -1, -1, -1, -1, new int[0], new double[0]);
    }

    private static String[] createInitialFieldsPattern(int totalColumns) {
        String[] patterns = new String[totalColumns];
        PoissonSeriesParser.setPatterns(patterns, 1, totalColumns, UNKNOWN_TYPE_PATTERN);
        return patterns;
    }

    private static void setPatterns(String[] array, int first, int count, String pattern) {
        if (first > 0) {
            Arrays.fill(array, first - 1, first - 1 + count, pattern);
        }
    }

    public PoissonSeriesParser withPolynomialPart(char freeVariable, PolynomialParser.Unit unit) {
        return new PoissonSeriesParser(new PolynomialParser(freeVariable, unit), this.fieldsPatterns, this.optional, this.gamma, this.firstDoodson, this.doodson, this.firstDelaunay, this.firstPlanetary, this.sinCosColumns, this.sinCosFactors);
    }

    public PoissonSeriesParser withOptionalColumn(int column) {
        String[] newFieldsPatterns = (String[])this.fieldsPatterns.clone();
        PoissonSeriesParser.setPatterns(newFieldsPatterns, this.optional, 1, UNKNOWN_TYPE_PATTERN);
        PoissonSeriesParser.setPatterns(newFieldsPatterns, column, 1, OPTIONAL_FIELD_PATTERN);
        return new PoissonSeriesParser(this.polynomialParser, newFieldsPatterns, column, this.gamma, this.firstDoodson, this.doodson, this.firstDelaunay, this.firstPlanetary, this.sinCosColumns, this.sinCosFactors);
    }

    public PoissonSeriesParser withGamma(int column) {
        if (this.firstDoodson > 0 && column > 0) {
            throw new OrekitException((Localizable)OrekitMessages.CANNOT_PARSE_BOTH_TAU_AND_GAMMA, new Object[0]);
        }
        String[] newFieldsPatterns = (String[])this.fieldsPatterns.clone();
        PoissonSeriesParser.setPatterns(newFieldsPatterns, this.gamma, 1, UNKNOWN_TYPE_PATTERN);
        PoissonSeriesParser.setPatterns(newFieldsPatterns, column, 1, INTEGER_TYPE_PATTERN);
        return new PoissonSeriesParser(this.polynomialParser, newFieldsPatterns, this.optional, column, this.firstDoodson, this.doodson, this.firstDelaunay, this.firstPlanetary, this.sinCosColumns, this.sinCosFactors);
    }

    public PoissonSeriesParser withDoodson(int firstMultiplierColumn, int numberColumn) {
        if (this.gamma > 0 && firstMultiplierColumn > 0) {
            throw new OrekitException((Localizable)OrekitMessages.CANNOT_PARSE_BOTH_TAU_AND_GAMMA, new Object[0]);
        }
        String[] newFieldsPatterns = (String[])this.fieldsPatterns.clone();
        PoissonSeriesParser.setPatterns(newFieldsPatterns, this.firstDoodson, 6, UNKNOWN_TYPE_PATTERN);
        PoissonSeriesParser.setPatterns(newFieldsPatterns, firstMultiplierColumn, 6, INTEGER_TYPE_PATTERN);
        PoissonSeriesParser.setPatterns(newFieldsPatterns, this.doodson, 1, UNKNOWN_TYPE_PATTERN);
        PoissonSeriesParser.setPatterns(newFieldsPatterns, numberColumn, 1, DOODSON_TYPE_PATTERN);
        return new PoissonSeriesParser(this.polynomialParser, newFieldsPatterns, this.optional, this.gamma, firstMultiplierColumn, numberColumn, this.firstDelaunay, this.firstPlanetary, this.sinCosColumns, this.sinCosFactors);
    }

    public PoissonSeriesParser withFirstDelaunay(int firstColumn) {
        String[] newFieldsPatterns = (String[])this.fieldsPatterns.clone();
        PoissonSeriesParser.setPatterns(newFieldsPatterns, this.firstDelaunay, 5, UNKNOWN_TYPE_PATTERN);
        PoissonSeriesParser.setPatterns(newFieldsPatterns, firstColumn, 5, INTEGER_TYPE_PATTERN);
        return new PoissonSeriesParser(this.polynomialParser, newFieldsPatterns, this.optional, this.gamma, this.firstDoodson, this.doodson, firstColumn, this.firstPlanetary, this.sinCosColumns, this.sinCosFactors);
    }

    public PoissonSeriesParser withFirstPlanetary(int firstColumn) {
        String[] newFieldsPatterns = (String[])this.fieldsPatterns.clone();
        PoissonSeriesParser.setPatterns(newFieldsPatterns, this.firstPlanetary, 9, UNKNOWN_TYPE_PATTERN);
        PoissonSeriesParser.setPatterns(newFieldsPatterns, firstColumn, 9, INTEGER_TYPE_PATTERN);
        return new PoissonSeriesParser(this.polynomialParser, newFieldsPatterns, this.optional, this.gamma, this.firstDoodson, this.doodson, this.firstDelaunay, firstColumn, this.sinCosColumns, this.sinCosFactors);
    }

    public PoissonSeriesParser withSinCos(int degree, int sinColumn, double sinFactor, int cosColumn, double cosFactor) {
        int maxDegree = FastMath.max(degree, this.sinCosColumns.length / 2 - 1);
        int[] newSinCosColumns = new int[2 * (maxDegree + 1)];
        Arrays.fill(newSinCosColumns, -1);
        System.arraycopy(this.sinCosColumns, 0, newSinCosColumns, 0, this.sinCosColumns.length);
        newSinCosColumns[2 * degree] = sinColumn;
        newSinCosColumns[2 * degree + 1] = cosColumn;
        double[] newSinCosFactors = new double[2 * (maxDegree + 1)];
        Arrays.fill(newSinCosFactors, Double.NaN);
        System.arraycopy(this.sinCosFactors, 0, newSinCosFactors, 0, this.sinCosFactors.length);
        newSinCosFactors[2 * degree] = sinFactor;
        newSinCosFactors[2 * degree + 1] = cosFactor;
        String[] newFieldsPatterns = (String[])this.fieldsPatterns.clone();
        if (2 * degree < this.sinCosColumns.length) {
            PoissonSeriesParser.setPatterns(newFieldsPatterns, this.sinCosColumns[2 * degree], 1, UNKNOWN_TYPE_PATTERN);
        }
        PoissonSeriesParser.setPatterns(newFieldsPatterns, sinColumn, 1, REAL_TYPE_PATTERN);
        if (2 * degree + 1 < this.sinCosColumns.length) {
            PoissonSeriesParser.setPatterns(newFieldsPatterns, this.sinCosColumns[2 * degree + 1], 1, UNKNOWN_TYPE_PATTERN);
        }
        PoissonSeriesParser.setPatterns(newFieldsPatterns, cosColumn, 1, REAL_TYPE_PATTERN);
        return new PoissonSeriesParser(this.polynomialParser, newFieldsPatterns, this.optional, this.gamma, this.firstDoodson, this.doodson, this.firstDelaunay, this.firstPlanetary, newSinCosColumns, newSinCosFactors);
    }

    public PoissonSeries parse(InputStream stream, String name) {
        if (stream == null) {
            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_FIND_FILE, name);
        }
        Pattern degreeSectionHeaderPattern = Pattern.compile("^\\p{Space}*j\\p{Space}*=\\p{Space}*(\\p{Digit}+)[\\p{Alpha}\\p{Space}]+=\\p{Space}*(\\p{Digit}+)\\p{Space}*$");
        StringBuilder builder = new StringBuilder("^\\p{Space}*");
        for (int i = 0; i < this.fieldsPatterns.length; ++i) {
            builder.append("(");
            builder.append(this.fieldsPatterns[i]);
            builder.append(")");
            builder.append(i < this.fieldsPatterns.length - 1 ? "\\p{Space}+" : "\\p{Space}*$");
        }
        Pattern regularLinePattern = Pattern.compile(builder.toString());
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
            int lineNumber = 0;
            int expectedIndex = -1;
            int nTerms = -1;
            int count = 0;
            int degree = 0;
            PolynomialNutation polynomial = this.polynomialParser == null ? new PolynomialNutation(new double[0]) : null;
            HashMap<Long, SeriesTerm> series = new HashMap<Long, SeriesTerm>();
            String line = reader.readLine();
            while (line != null) {
                line = line.replace('\u2212', '-');
                ++lineNumber;
                Matcher regularMatcher = regularLinePattern.matcher(line);
                if (regularMatcher.matches()) {
                    long key;
                    int cPa;
                    if (expectedIndex > 0 && Integer.parseInt(regularMatcher.group(1)) != expectedIndex) {
                        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, regularMatcher.group());
                    }
                    int cTau = this.firstDoodson < 0 ? 0 : Integer.parseInt(regularMatcher.group(this.firstDoodson));
                    int cS = this.firstDoodson < 0 ? 0 : Integer.parseInt(regularMatcher.group(this.firstDoodson + 1));
                    int cH = this.firstDoodson < 0 ? 0 : Integer.parseInt(regularMatcher.group(this.firstDoodson + 2));
                    int cP = this.firstDoodson < 0 ? 0 : Integer.parseInt(regularMatcher.group(this.firstDoodson + 3));
                    int cNprime = this.firstDoodson < 0 ? 0 : Integer.parseInt(regularMatcher.group(this.firstDoodson + 4));
                    int cPs = this.firstDoodson < 0 ? 0 : Integer.parseInt(regularMatcher.group(this.firstDoodson + 5));
                    int nDoodson = this.doodson < 0 ? 0 : Integer.parseInt(regularMatcher.group(this.doodson).replaceAll("[.,]", ""));
                    int cGamma = this.gamma < 0 ? 0 : Integer.parseInt(regularMatcher.group(this.gamma));
                    int cL = Integer.parseInt(regularMatcher.group(this.firstDelaunay));
                    int cLPrime = Integer.parseInt(regularMatcher.group(this.firstDelaunay + 1));
                    int cF = Integer.parseInt(regularMatcher.group(this.firstDelaunay + 2));
                    int cD = Integer.parseInt(regularMatcher.group(this.firstDelaunay + 3));
                    int cOmega = Integer.parseInt(regularMatcher.group(this.firstDelaunay + 4));
                    int cMe = this.firstPlanetary < 0 ? 0 : Integer.parseInt(regularMatcher.group(this.firstPlanetary));
                    int cVe = this.firstPlanetary < 0 ? 0 : Integer.parseInt(regularMatcher.group(this.firstPlanetary + 1));
                    int cE = this.firstPlanetary < 0 ? 0 : Integer.parseInt(regularMatcher.group(this.firstPlanetary + 2));
                    int cMa = this.firstPlanetary < 0 ? 0 : Integer.parseInt(regularMatcher.group(this.firstPlanetary + 3));
                    int cJu = this.firstPlanetary < 0 ? 0 : Integer.parseInt(regularMatcher.group(this.firstPlanetary + 4));
                    int cSa = this.firstPlanetary < 0 ? 0 : Integer.parseInt(regularMatcher.group(this.firstPlanetary + 5));
                    int cUr = this.firstPlanetary < 0 ? 0 : Integer.parseInt(regularMatcher.group(this.firstPlanetary + 6));
                    int cNe = this.firstPlanetary < 0 ? 0 : Integer.parseInt(regularMatcher.group(this.firstPlanetary + 7));
                    int n = cPa = this.firstPlanetary < 0 ? 0 : Integer.parseInt(regularMatcher.group(this.firstPlanetary + 8));
                    if (nDoodson > 0) {
                        cGamma = cTau;
                        cL = -cL;
                        cLPrime = -cLPrime;
                        cF = -cF;
                        cD = -cD;
                        cOmega = -cOmega;
                        if (nDoodson != this.doodsonToDoodsonNumber(cTau, cS, cH, cP, cNprime, cPs) || nDoodson != this.delaunayToDoodsonNumber(cGamma, cL, cLPrime, cF, cD, cOmega)) {
                            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, regularMatcher.group());
                        }
                    }
                    SeriesTerm term = series.containsKey(key = NutationCodec.encode(cGamma, cL, cLPrime, cF, cD, cOmega, cMe, cVe, cE, cMa, cJu, cSa, cUr, cNe, cPa)) ? (SeriesTerm)series.get(key) : SeriesTerm.buildTerm(cGamma, cL, cLPrime, cF, cD, cOmega, cMe, cVe, cE, cMa, cJu, cSa, cUr, cNe, cPa);
                    boolean nonZero = false;
                    for (int d = 0; d < this.sinCosColumns.length / 2; ++d) {
                        double sinCoeff = this.parseCoefficient(regularMatcher, this.sinCosColumns[2 * d], this.sinCosFactors[2 * d]);
                        double cosCoeff = this.parseCoefficient(regularMatcher, this.sinCosColumns[2 * d + 1], this.sinCosFactors[2 * d + 1]);
                        if (Precision.equals(sinCoeff, 0.0, 0) && Precision.equals(cosCoeff, 0.0, 0)) continue;
                        nonZero = true;
                        term.add(0, degree + d, sinCoeff, cosCoeff);
                        ++count;
                    }
                    if (nonZero) {
                        series.put(key, term);
                    }
                    if (expectedIndex > 0) {
                        ++expectedIndex;
                    }
                } else {
                    double[] coefficients;
                    Matcher headerMatcher = degreeSectionHeaderPattern.matcher(line);
                    if (headerMatcher.matches()) {
                        int nextDegree = Integer.parseInt(headerMatcher.group(1));
                        if (nextDegree != degree + 1 && (degree != 0 || nextDegree != 0)) {
                            throw new OrekitException((Localizable)OrekitMessages.MISSING_SERIE_J_IN_FILE, degree + 1, name, lineNumber);
                        }
                        if (nextDegree == 0) {
                            expectedIndex = 1;
                        }
                        if (nextDegree > 0 && count != nTerms) {
                            throw new OrekitException((Localizable)OrekitMessages.NOT_A_SUPPORTED_IERS_DATA_FILE, name);
                        }
                        nTerms = Integer.parseInt(headerMatcher.group(2));
                        count = 0;
                        degree = nextDegree;
                    } else if (polynomial == null && (coefficients = this.polynomialParser.parse(line)) != null) {
                        polynomial = new PolynomialNutation(coefficients);
                    }
                }
                line = reader.readLine();
            }
            if (polynomial == null || series.isEmpty()) {
                throw new OrekitException((Localizable)OrekitMessages.NOT_A_SUPPORTED_IERS_DATA_FILE, name);
            }
            if (nTerms > 0 && count != nTerms) {
                throw new OrekitException((Localizable)OrekitMessages.NOT_A_SUPPORTED_IERS_DATA_FILE, name);
            }
            return new PoissonSeries(polynomial, series);
        }
        catch (IOException ioe) {
            throw new OrekitException(ioe, new DummyLocalizable(ioe.getMessage()), new Object[0]);
        }
    }

    private double parseCoefficient(Matcher matcher, int group, double scale) {
        if (group < 0) {
            return 0.0;
        }
        return scale * Double.parseDouble(matcher.group(group));
    }

    private int delaunayToDoodsonNumber(int cGamma, int cL, int cLPrime, int cF, int cD, int cOmega) {
        int cTau = cGamma;
        int cS = cGamma + (cL + cF + cD);
        int cH = cLPrime - cD;
        int cP = -cL;
        int cNprime = cF - cOmega;
        int cPs = -cLPrime;
        return this.doodsonToDoodsonNumber(cTau, cS, cH, cP, cNprime, cPs);
    }

    private int doodsonToDoodsonNumber(int cTau, int cS, int cH, int cP, int cNprime, int cPs) {
        return ((((cTau * 10 + (cS + 5)) * 10 + (cH + 5)) * 10 + (cP + 5)) * 10 + (cNprime + 5)) * 10 + (cPs + 5);
    }
}

