/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.iod;

import org.hipparchus.analysis.solvers.LaguerreSolver;
import org.hipparchus.complex.Complex;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.LUDecomposition;
import org.hipparchus.util.FastMath;
import org.orekit.frames.Frame;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinates;

public class IodLaplace {
    private final double mu;

    public IodLaplace(double mu) {
        this.mu = mu;
    }

    public CartesianOrbit estimate(Frame frame, PVCoordinates obsPva, AbsoluteDate obsDate1, Vector3D los1, AbsoluteDate obsDate2, Vector3D los2, AbsoluteDate obsDate3, Vector3D los3) {
        Vector Ldotdot;
        double t3;
        double t2 = obsDate2.durationFrom(obsDate1);
        Vector Ldot = ((Vector3D)los1.scalarMultiply((t2 - (t3 = obsDate3.durationFrom(obsDate1))) / (t2 * t3)).add((Vector)los2.scalarMultiply((2.0 * t2 - t3) / (t2 * (t2 - t3))))).add((Vector)los3.scalarMultiply(t2 / (t3 * (t3 - t2))));
        double D = 2.0 * this.getDeterminant(los2, (Vector3D)Ldot, (Vector3D)(Ldotdot = ((Vector3D)los1.scalarMultiply(2.0 / (t2 * t3)).add((Vector)los2.scalarMultiply(2.0 / (t2 * (t2 - t3))))).add((Vector)los3.scalarMultiply(2.0 / (t3 * (t3 - t2))))));
        if (FastMath.abs(D) < 1.0E-14) {
            return null;
        }
        double Dsq = D * D;
        double R = obsPva.getPosition().getNorm();
        double RdotL = obsPva.getPosition().dotProduct(los2);
        double D1 = this.getDeterminant(los2, (Vector3D)Ldot, obsPva.getAcceleration());
        double D2 = this.getDeterminant(los2, (Vector3D)Ldot, obsPva.getPosition());
        double[] coeff = new double[]{-4.0 * this.mu * this.mu * D2 * D2 / Dsq, 0.0, 0.0, 4.0 * this.mu * D2 * (RdotL / D - 2.0 * D1 / Dsq), 0.0, 0.0, 4.0 * D1 * RdotL / D - 4.0 * D1 * D1 / Dsq - R * R, 0.0, 1.0};
        LaguerreSolver solver = new LaguerreSolver(1.0E-10, 1.0E-10, 1.0E-10);
        Complex[] roots = solver.solveAllComplex(coeff, 5.0 * R);
        double rMag = 0.0;
        for (int i = 0; i < roots.length; ++i) {
            if (!(roots[i].getReal() > rMag) || !(FastMath.abs(roots[i].getImaginary()) < solver.getAbsoluteAccuracy())) continue;
            rMag = roots[i].getReal();
        }
        if (rMag == 0.0) {
            return null;
        }
        double rCubed = rMag * rMag * rMag;
        double rho = -2.0 * D1 / D - 2.0 * this.mu * D2 / (D * rCubed);
        Vector posVec = los2.scalarMultiply(rho).add((Vector)obsPva.getPosition());
        double D3 = this.getDeterminant(los2, obsPva.getAcceleration(), (Vector3D)Ldotdot);
        double D4 = this.getDeterminant(los2, obsPva.getPosition(), (Vector3D)Ldotdot);
        double rhoDot = -D3 / D - this.mu * D4 / (D * rCubed);
        Vector velVec = ((Vector3D)los2.scalarMultiply(rhoDot).add((Vector)((Vector3D)Ldot).scalarMultiply(rho))).add((Vector)obsPva.getVelocity());
        return new CartesianOrbit(new PVCoordinates((Vector3D)posVec, (Vector3D)velVec), frame, obsDate2, this.mu);
    }

    private double getDeterminant(Vector3D col0, Vector3D col1, Vector3D col2) {
        Array2DRowRealMatrix mat = new Array2DRowRealMatrix(3, 3);
        mat.setColumn(0, col0.toArray());
        mat.setColumn(1, col1.toArray());
        mat.setColumn(2, col2.toArray());
        return new LUDecomposition(mat).getDeterminant();
    }
}

